/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import org.biopax.paxtools.impl.level3.XrefImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.PublicationXref;
import org.biopax.paxtools.util.BPCollections;

public class PublicationXrefImpl
extends XrefImpl
implements PublicationXref {
    private String title;
    private Set<String> url;
    private Set<String> source;
    private Set<String> author;
    private int year = UNKNOWN_INT;

    public PublicationXrefImpl() {
        this.url = BPCollections.I.createSet();
        this.source = BPCollections.I.createSet();
        this.author = BPCollections.I.createSet();
    }

    public Class<? extends PublicationXref> getModelInterface() {
        return PublicationXref.class;
    }

    @Override
    public Set<String> getAuthor() {
        return this.author;
    }

    @Override
    public void addAuthor(String author) {
        if (author != null && author.length() > 0) {
            this.author.add(author);
        }
    }

    @Override
    public void removeAuthor(String author) {
        if (author != null) {
            this.author.remove(author);
        }
    }

    @Override
    public Set<String> getSource() {
        return this.source;
    }

    @Override
    public void addSource(String source) {
        if (source != null && source.length() > 0) {
            this.source.add(source);
        }
    }

    @Override
    public void removeSource(String source) {
        if (source != null) {
            this.source.remove(source);
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Set<String> getUrl() {
        return this.url;
    }

    @Override
    public void addUrl(String url) {
        if (url != null && url.length() > 0) {
            this.url.add(url);
        }
    }

    @Override
    public void removeUrl(String url) {
        if (url != null) {
            this.url.remove(url);
        }
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public void setYear(int year) {
        this.year = year;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement other) {
        if (!(other instanceof PublicationXref)) {
            return false;
        }
        PublicationXref that = (PublicationXref)other;
        boolean eqv = this.year == that.getYear() && (this.title != null ? this.title.equals(that.getTitle()) : that.getTitle() == null) && this.author.containsAll(that.getAuthor()) && this.source.containsAll(that.getSource()) && this.url.containsAll(that.getUrl());
        return eqv && super.semanticallyEquivalent(other);
    }
}

