/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sbgn;

import java.util.ArrayList;
import java.util.List;
import org.ivis.layout.LGraphObject;
import org.ivis.layout.LNode;
import org.ivis.layout.Updatable;
import org.ivis.layout.cose.CoSEGraph;
import org.sbgn.bindings.Bbox;
import org.sbgn.bindings.Glyph;

class VNode
implements Updatable {
    public Glyph glyph;
    ArrayList<Glyph> stateGlyphs;
    ArrayList<Glyph> infoGlyphs;
    private static final String MACROMOLECULE = "macromolecule";
    private static final String UNIT_OF_INFORMATION = "unit of information";
    private static final String STATE_VARIABLE = "state variable";
    private static final String SOURCE_AND_SINK = "source and sink";
    private static final String ASSOCIATION = "association";
    private static final String DISSOCIATION = "dissociation";
    private static final String OMITTED_PROCESS = "omitted process";
    private static final String UNCERTAIN_PROCESS = "uncertain process";
    private static final String SIMPLE_CHEMICAL = "simple chemical";
    private static final String PROCESS = "process";
    private static final String COMPLEX = "complex";
    private static final String AND = "and";
    private static final String OR = "or";
    private static final String NOT = "not";
    private static final String PHENOTYPE = "phenotype";
    private static final String PERTURBING_AGENT = "perturbing agent";
    private static final String TAG = "tag";
    private static final String NUCLEIC_ACID_FEATURE = "nucleic acid feature";
    private static final String UNSPECIFIED_ENTITY = "unspecified entity";
    private static final String NONE = "NA";
    private static final int LOWERCASE_LETTER_PIXEL_WIDTH = 6;
    private static final int UPPERCASE_LETTER_PIXEL_WIDTH = 9;
    private static final int MAX_STATE_AND_INFO_WIDTH = 35;
    private static final int MAX_STATE_AND_INFO_HEIGHT = 10;
    private static final int OFFSET_BTW_INFO_GLYPHS = 5;
    private static final int MAX_INFO_BOX_NUMBER = 4;
    private static final int MAX_MACROMOLECULE_HEIGHT_WITH_INFO_BOXES = 25;
    private static final int NON_SUPPORTED_GLYPH_OFFSET = 2;
    private static Bound SOURCE_AND_SINK_BOUND;
    private static Bound LOGICAL_OPERATOR_BOUND;
    private static Bound PROCESS_NODES_BOUND;
    private static Bound MACROMOLECULE_BOUND;
    private static Bound NUCLEIC_ACID_FEATURE_BOUND;
    private static Bound SIMPLE_CHEMICAL_BOUND;
    private static Bound UNSPECIFIED_ENTITY_BOUND;
    private static Bound PHENOTYPE_BOUND;
    private static Bound PERTURBING_AGENT_BOUND;
    private static Bound TAG_BOUND;
    private static Bound INFO_BOUND;
    private static Bound STATE_BOUND;
    private static Bound COMPLEX_BOUND;

    public VNode(Glyph g) {
        SOURCE_AND_SINK_BOUND = new Bound(15.0f, 15.0f);
        LOGICAL_OPERATOR_BOUND = new Bound(15.0f, 15.0f);
        PROCESS_NODES_BOUND = new Bound(15.0f, 15.0f);
        MACROMOLECULE_BOUND = new Bound(48.0f, 25.0f);
        NUCLEIC_ACID_FEATURE_BOUND = new Bound(50.0f, 25.0f);
        SIMPLE_CHEMICAL_BOUND = new Bound(48.0f, 20.0f);
        UNSPECIFIED_ENTITY_BOUND = new Bound(40.0f, 40.0f);
        PHENOTYPE_BOUND = new Bound(50.0f, 20.0f);
        TAG_BOUND = new Bound(50.0f, 20.0f);
        PERTURBING_AGENT_BOUND = new Bound(50.0f, 20.0f);
        COMPLEX_BOUND = new Bound(48.0f, 20.0f);
        INFO_BOUND = new Bound(35.0f, 10.0f);
        STATE_BOUND = new Bound(35.0f, 10.0f);
        this.stateGlyphs = new ArrayList();
        this.infoGlyphs = new ArrayList();
        this.glyph = g;
        Bbox b = new Bbox();
        this.glyph.setBbox(b);
        if (this.glyph.getClazz() == null) {
            this.glyph.setClazz(NONE);
        }
        this.setSizeAccordingToClass();
    }

    @Override
    public void update(LGraphObject lGraphObj) {
        if (lGraphObj instanceof CoSEGraph) {
            return;
        }
        LNode lNode = (LNode)lGraphObj;
        this.glyph.getBbox().setX((float)lNode.getLeft());
        this.glyph.getBbox().setY((float)lNode.getTop());
        this.placeStateAndInfoGlyphs();
    }

    public void setBounds(float w, float h) {
        this.glyph.getBbox().setW(w);
        this.glyph.getBbox().setH(h);
    }

    public void setSizeAccordingToClass() {
        String glyphClass = this.glyph.getClazz();
        if (glyphClass.equalsIgnoreCase(NONE)) {
            return;
        }
        if (glyphClass.equalsIgnoreCase(SOURCE_AND_SINK)) {
            this.setBounds(SOURCE_AND_SINK_BOUND.getWidth(), SOURCE_AND_SINK_BOUND.getHeight());
        } else if (glyphClass.equalsIgnoreCase(AND) || glyphClass.equalsIgnoreCase(OR) || glyphClass.equalsIgnoreCase(NOT)) {
            this.setBounds(LOGICAL_OPERATOR_BOUND.getWidth(), LOGICAL_OPERATOR_BOUND.getHeight());
        } else if (glyphClass.equalsIgnoreCase(ASSOCIATION) || glyphClass.equalsIgnoreCase(DISSOCIATION) || glyphClass.equalsIgnoreCase(OMITTED_PROCESS) || glyphClass.equalsIgnoreCase(UNCERTAIN_PROCESS) || glyphClass.equalsIgnoreCase(PROCESS)) {
            this.setBounds(PROCESS_NODES_BOUND.getWidth(), PROCESS_NODES_BOUND.getHeight());
        } else if (glyphClass.equalsIgnoreCase(SIMPLE_CHEMICAL)) {
            this.setBounds(SIMPLE_CHEMICAL_BOUND.getWidth(), SIMPLE_CHEMICAL_BOUND.getHeight());
        } else if (glyphClass.equalsIgnoreCase(UNSPECIFIED_ENTITY)) {
            this.setBounds(UNSPECIFIED_ENTITY_BOUND.getWidth(), UNSPECIFIED_ENTITY_BOUND.getHeight());
        } else if (glyphClass.equalsIgnoreCase(MACROMOLECULE)) {
            this.setBounds(MACROMOLECULE_BOUND.getWidth(), MACROMOLECULE_BOUND.getHeight());
        } else if (glyphClass.equalsIgnoreCase(NUCLEIC_ACID_FEATURE)) {
            this.setBounds(NUCLEIC_ACID_FEATURE_BOUND.getWidth(), NUCLEIC_ACID_FEATURE_BOUND.getHeight());
        } else if (glyphClass.equalsIgnoreCase(STATE_VARIABLE)) {
            this.setBounds(STATE_BOUND.getWidth(), STATE_BOUND.getHeight());
        } else if (glyphClass.equalsIgnoreCase(UNIT_OF_INFORMATION)) {
            this.setBounds(INFO_BOUND.getWidth(), INFO_BOUND.getHeight());
        } else if (glyphClass.equalsIgnoreCase(PHENOTYPE)) {
            this.setBounds(PHENOTYPE_BOUND.getWidth(), PHENOTYPE_BOUND.getHeight());
        } else if (glyphClass.equalsIgnoreCase(PERTURBING_AGENT)) {
            this.setBounds(PERTURBING_AGENT_BOUND.getWidth(), PERTURBING_AGENT_BOUND.getHeight());
        } else if (glyphClass.equalsIgnoreCase(TAG)) {
            this.setBounds(TAG_BOUND.getWidth(), TAG_BOUND.getHeight());
        } else if (glyphClass.equalsIgnoreCase(COMPLEX)) {
            this.setBounds(COMPLEX_BOUND.getWidth(), COMPLEX_BOUND.getHeight());
        }
        if (this.glyph.getClone() != null) {
            Bbox glyphBbox = this.glyph.getBbox();
            this.setBounds(3.0f * glyphBbox.getW() / 4.0f, 3.0f * glyphBbox.getH() / 4.0f);
        }
        if (glyphClass.equalsIgnoreCase(MACROMOLECULE) || glyphClass.equalsIgnoreCase(NUCLEIC_ACID_FEATURE) || glyphClass.equalsIgnoreCase(SIMPLE_CHEMICAL) || glyphClass.equalsIgnoreCase(COMPLEX)) {
            this.updateSizeForStateAndInfo();
        }
    }

    public int calcReqWidthByStateAndInfos(List<Glyph> stateORinfoList) {
        int wholeSize = 0;
        int count = 0;
        for (Glyph tmpGlyph : stateORinfoList) {
            String text;
            if (tmpGlyph.getState() != null) {
                text = tmpGlyph.getState().getValue();
                if (tmpGlyph.getState().getVariable() != null && tmpGlyph.getState().getVariable().length() > 0 && tmpGlyph.getState().getVariable() != null) {
                    text = text + "@" + tmpGlyph.getState().getVariable();
                }
            } else if (tmpGlyph.getLabel() != null) {
                text = tmpGlyph.getLabel().getText();
            } else {
                throw new RuntimeException("Encountered an information glyph with no state variable (as modification boxes should have) and no label (as molecule type boxed should have). glyph = " + tmpGlyph);
            }
            int numOfUpper = 0;
            int numOfLower = 0;
            for (int i = 0; i < text.length(); ++i) {
                if (Character.isLowerCase(text.charAt(i))) {
                    ++numOfLower;
                    continue;
                }
                ++numOfUpper;
            }
            Bbox b = new Bbox();
            tmpGlyph.setBbox(b);
            float requiredSize = numOfLower * 6 + numOfUpper * 9;
            if (requiredSize < 35.0f) {
                tmpGlyph.getBbox().setW(requiredSize);
            } else {
                tmpGlyph.getBbox().setW(VNode.STATE_BOUND.width);
            }
            tmpGlyph.getBbox().setH(10.0f);
            if (count < 2) {
                wholeSize = (int)((float)wholeSize + tmpGlyph.getBbox().getW());
            }
            ++count;
        }
        return wholeSize;
    }

    public void updateSizeForStateAndInfo() {
        for (Glyph glyph : this.glyph.getGlyph()) {
            if (glyph.getClazz() == STATE_VARIABLE) {
                this.stateGlyphs.add(glyph);
                continue;
            }
            if (glyph.getClazz() != UNIT_OF_INFORMATION) continue;
            this.infoGlyphs.add(glyph);
        }
        int wholeWidthOfStates = this.calcReqWidthByStateAndInfos(this.stateGlyphs);
        int wholeWidthOfInfos = this.calcReqWidthByStateAndInfos(this.infoGlyphs);
        int numOfStates = this.stateGlyphs.size();
        int numOfInfos = this.infoGlyphs.size();
        int totNumStateInfo = numOfInfos + numOfStates;
        int multiplier = totNumStateInfo <= 2 ? 2 : 3;
        float requiredWidth = multiplier * 5 + (multiplier - 1) * 35;
        if (totNumStateInfo > 0) {
            this.glyph.getBbox().setH(this.glyph.getBbox().getH() + 5.0f);
        }
        if (this.glyph.getBbox().getW() < requiredWidth) {
            this.glyph.getBbox().setW(requiredWidth);
        }
    }

    public void placeStateAndInfoGlyphs() {
        int numOfStates = this.stateGlyphs.size();
        int numOfInfos = this.infoGlyphs.size();
        if (numOfStates > 0 || numOfInfos > 0) {
            this.glyph.getBbox().setH(this.glyph.getBbox().getH() - 5.0f);
        }
        float parent_y_up = this.glyph.getBbox().getY() - VNode.INFO_BOUND.height / 2.0f;
        float parent_y_bot = this.glyph.getBbox().getY() + this.glyph.getBbox().getH() - VNode.INFO_BOUND.height / 2.0f;
        float parent_x_up = this.glyph.getBbox().getX();
        float parentWidth = this.glyph.getBbox().getW();
        String parentID = this.glyph.getId();
        int maxNumberOfStates = this.stateGlyphs.size();
        int maxNumberOfInfos = this.infoGlyphs.size();
        if (maxNumberOfInfos + maxNumberOfStates > 4 && (maxNumberOfInfos < 2 || maxNumberOfStates < 2)) {
            int minimum = Math.min(maxNumberOfInfos, maxNumberOfStates);
            if (maxNumberOfInfos - minimum == 0) {
                maxNumberOfInfos = minimum;
                maxNumberOfStates -= maxNumberOfInfos;
            } else {
                maxNumberOfStates = minimum;
                maxNumberOfInfos -= maxNumberOfStates;
            }
        }
        int totalNumberOfStateAndInfos = maxNumberOfInfos + maxNumberOfStates;
        Glyph tmpglyph = null;
        int infoIndex = 0;
        int stateIndex = 0;
        int topUsedWidth = 0;
        int bottomUsedWidth = 0;
        int additionalStateInfoOffset = 0;
        boolean placeTopFlag = true;
        for (int i = 0; i < totalNumberOfStateAndInfos; ++i) {
            int offsetMultiplier;
            int n = offsetMultiplier = i % 4 <= 1 ? 1 : 2;
            if (maxNumberOfInfos - i > 0 && this.infoGlyphs.size() > 0) {
                tmpglyph = this.infoGlyphs.get(infoIndex++);
            } else if (this.stateGlyphs.size() > 0) {
                tmpglyph = this.stateGlyphs.get(stateIndex++);
            }
            if (placeTopFlag) {
                if (totalNumberOfStateAndInfos <= 2) {
                    tmpglyph.getBbox().setX(parent_x_up + parentWidth / 2.0f - tmpglyph.getBbox().getW() / 2.0f);
                    tmpglyph.getBbox().setY(parent_y_up - (float)additionalStateInfoOffset);
                    tmpglyph.setId(parentID + ".info." + (i + 1));
                } else {
                    tmpglyph.setId(parentID + ".info." + (i + 1));
                    tmpglyph.getBbox().setX(parent_x_up + (float)(offsetMultiplier * 5) + (float)topUsedWidth);
                    tmpglyph.getBbox().setY(parent_y_up - (float)additionalStateInfoOffset);
                }
                topUsedWidth = (int)((float)topUsedWidth + tmpglyph.getBbox().getW());
            } else {
                if (i % 2 == 1 && (totalNumberOfStateAndInfos == 2 || totalNumberOfStateAndInfos == 3)) {
                    tmpglyph.getBbox().setX(parent_x_up + parentWidth / 2.0f - tmpglyph.getBbox().getW() / 2.0f);
                    tmpglyph.getBbox().setY(parent_y_bot + (float)additionalStateInfoOffset);
                    tmpglyph.setId(parentID + ".state." + (i + 1));
                } else {
                    tmpglyph.setId(parentID + ".state." + (i + 1));
                    tmpglyph.getBbox().setX(parent_x_up + (float)(offsetMultiplier * 5) + (float)bottomUsedWidth);
                    tmpglyph.getBbox().setY(parent_y_bot + (float)additionalStateInfoOffset);
                }
                bottomUsedWidth = (int)((float)bottomUsedWidth + tmpglyph.getBbox().getW());
            }
            boolean bl = placeTopFlag = !placeTopFlag;
            if ((i + 1) % 4 != 0) continue;
            additionalStateInfoOffset += 2;
        }
    }

    public class Bound {
        public float width;
        public float height;

        public Bound(float width, float height) {
            this.width = width;
            this.height = height;
        }

        public float getWidth() {
            return this.width;
        }

        public void setWidth(float width) {
            this.width = width;
        }

        public float getHeight() {
            return this.height;
        }

        public void setHeight(float height) {
            this.height = height;
        }
    }
}

