/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.constraint;

import java.util.Collection;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.constraint.ConstraintAdapter;

public class Field
extends ConstraintAdapter {
    public static final Object EMPTY = new Object();
    public static final Object USE_SECOND_ARG = new Object();
    Object value;
    PathAccessor pa1;
    PathAccessor pa2;
    Operation oper;

    public Field(String accessorString, Operation oper, Object value) {
        super(value == USE_SECOND_ARG ? 2 : 1);
        this.value = value;
        this.pa1 = new PathAccessor(accessorString);
        this.oper = oper;
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            throw new IllegalArgumentException("The queried collection cannot be empty.");
        }
    }

    public Field(String accessorString1, String accessorString2, Operation oper) {
        super(2);
        this.pa1 = new PathAccessor(accessorString1);
        this.pa2 = new PathAccessor(accessorString2);
        this.oper = oper;
    }

    @Override
    public boolean satisfies(Match match, int ... ind) {
        this.assertIndLength(ind);
        BioPAXElement ele = match.get(ind[0]);
        Set values = this.pa1.getValueFromBean(ele);
        if (this.oper == Operation.NOT_EMPTY_AND_NOT_INTERSECT && values.isEmpty()) {
            return false;
        }
        if (this.value == EMPTY) {
            return values.isEmpty();
        }
        if (this.value == USE_SECOND_ARG) {
            BioPAXElement q = match.get(ind[1]);
            return this.oper == Operation.INTERSECT ? values.contains(q) : !values.contains(q);
        }
        if (this.value instanceof Collection) {
            Collection query = (Collection)this.value;
            values.retainAll(query);
            if (this.oper == Operation.INTERSECT) {
                return !values.isEmpty();
            }
            return values.isEmpty();
        }
        if (this.pa2 != null) {
            BioPAXElement q = match.get(ind[1]);
            Set others = this.pa2.getValueFromBean(q);
            switch (this.oper) {
                case INTERSECT: {
                    others.retainAll(values);
                    return !others.isEmpty();
                }
                case NOT_INTERSECT: {
                    others.retainAll(values);
                    return others.isEmpty();
                }
                case NOT_EMPTY_AND_NOT_INTERSECT: {
                    if (others.isEmpty()) {
                        return false;
                    }
                    others.retainAll(values);
                    return others.isEmpty();
                }
            }
            throw new RuntimeException("Unhandled operation: " + (Object)((Object)this.oper));
        }
        if (this.oper == Operation.INTERSECT) {
            return values.contains(this.value);
        }
        return !values.contains(this.value);
    }

    public static enum Operation {
        INTERSECT,
        NOT_INTERSECT,
        NOT_EMPTY_AND_NOT_INTERSECT;

    }
}

