/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.NucleicAcid;
import org.biopax.paxtools.model.level3.NucleicAcidReference;
import org.biopax.paxtools.model.level3.PublicationXref;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.pattern.miner.IDFetcher;
import org.biopax.paxtools.pattern.util.HGNC;

public class CommonIDFetcher
implements IDFetcher {
    boolean useUniprotIDs = false;

    @Override
    public Set<String> fetchID(BioPAXElement ele) {
        String id;
        String db;
        HashSet<String> set;
        block10: {
            block8: {
                Named e;
                block11: {
                    block9: {
                        set = new HashSet<String>();
                        if (!(ele instanceof SmallMoleculeReference) && !(ele instanceof SmallMolecule)) break block8;
                        e = (Named)ele;
                        if (e.getDisplayName() == null || e.getDisplayName().contains("...")) break block9;
                        set.add(e.getDisplayName());
                        break block10;
                    }
                    if (e.getStandardName() == null || e.getStandardName().contains("...")) break block11;
                    set.add(e.getStandardName());
                    break block10;
                }
                if (e.getName().isEmpty()) break block10;
                TreeSet<String> names = new TreeSet<String>();
                for (String name : e.getName()) {
                    if (name.contains("...")) continue;
                    names.add(name);
                }
                set.add(((Object)names).toString());
                break block10;
            }
            if (this.useUniprotIDs && ele.getUri().startsWith("http://identifiers.org/uniprot/")) {
                set.add(ele.getUri().substring(ele.getUri().lastIndexOf("/") + 1));
            } else if (ele instanceof XReferrable) {
                for (Xref xr : ((XReferrable)ele).getXref()) {
                    if (xr instanceof PublicationXref) continue;
                    db = xr.getDb();
                    id = xr.getId();
                    if (db == null || id == null || id.isEmpty()) continue;
                    db = db.toLowerCase();
                    if (!this.useUniprotIDs && db.startsWith("hgnc")) {
                        String symbol = HGNC.getSymbol(id);
                        if (symbol == null || symbol.isEmpty()) continue;
                        set.add(symbol);
                        continue;
                    }
                    if (!this.useUniprotIDs || !db.startsWith("uniprot")) continue;
                    set.add(id);
                }
            }
        }
        if (set.isEmpty() && (ele instanceof NucleicAcidReference || ele instanceof NucleicAcid)) {
            for (Xref xr : ((XReferrable)ele).getXref()) {
                if (xr instanceof PublicationXref) continue;
                db = xr.getDb();
                id = xr.getId();
                if (db == null || id == null || id.isEmpty() || !(db = db.toLowerCase()).equals("mirbase sequence")) continue;
                set.add(id);
            }
        }
        return set;
    }

    public void setUseUniprotIDs(boolean useUniprotIDs) {
        this.useUniprotIDs = useUniprotIDs;
    }
}

