/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;

public class FeatureCollector {
    public Map<EntityReference, Set<ModificationFeature>> collectFeatures(Model model, boolean active) {
        HashMap<EntityReference, Set<ModificationFeature>> map = new HashMap<EntityReference, Set<ModificationFeature>>();
        for (EntityReference er : model.getObjects(EntityReference.class)) {
            HashSet<ModificationFeature> features = new HashSet<ModificationFeature>();
            for (SimplePhysicalEntity spe : er.getEntityReferenceOf()) {
                boolean isAct = this.finalDecisionActive(spe);
                boolean isInact = this.finalDecisionInactive(spe);
                if (isAct && isInact) {
                    System.out.println("both active and inactive: " + spe.getDisplayName());
                }
                if (active && !isAct || !active && !isInact) continue;
                for (EntityFeature feat : spe.getFeature()) {
                    if (!(feat instanceof ModificationFeature)) continue;
                    features.add((ModificationFeature)feat);
                }
            }
            map.put(er, features);
        }
        return map;
    }

    protected boolean finalDecisionActive(PhysicalEntity pe) {
        return !this.labeledInactive(pe) && !this.activityInName(pe, false) && (this.hasActivity(pe) || this.labeledActive(pe) || this.activityInName(pe, true));
    }

    protected boolean finalDecisionInactive(PhysicalEntity pe) {
        return !this.labeledActive(pe) && !this.activityInName(pe, true) && (this.activityInName(pe, false) || this.labeledInactive(pe) || this.hasUbiquitin(pe));
    }

    protected boolean hasActivity(PhysicalEntity pe) {
        return this.hasBasicActivity(pe) || this.hasActivityInGeneric(pe, true) || this.hasActivityInGeneric(pe, false) || this.hasActivityInComplex(pe);
    }

    protected boolean hasActivityInComplex(PhysicalEntity pe) {
        for (Complex cmp : pe.getComponentOf()) {
            if (!this.hasBasicActivity(cmp) && !this.hasActivityInComplex(cmp) && !this.hasActivityInGeneric(cmp, true) && !this.hasActivityInGeneric(cmp, false)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasActivityInGeneric(PhysicalEntity pe, boolean up) {
        for (PhysicalEntity gen : up ? pe.getMemberPhysicalEntityOf() : pe.getMemberPhysicalEntity()) {
            if (!this.hasBasicActivity(gen) && !this.hasActivityInGeneric(gen, up) && !this.hasActivityInComplex(gen)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasBasicActivity(PhysicalEntity pe) {
        return !pe.getControllerOf().isEmpty();
    }

    protected boolean labeledActive(PhysicalEntity pe) {
        return this.hasFeature(pe, "residue modification, active");
    }

    protected boolean labeledInactive(PhysicalEntity pe) {
        return this.hasFeature(pe, "residue modification, inactive");
    }

    protected boolean hasUbiquitin(PhysicalEntity pe) {
        return this.hasFeature(pe, "ubiquitin");
    }

    protected boolean hasFeature(PhysicalEntity pe, String term) {
        for (Object o : new PathAccessor("PhysicalEntity/feature:ModificationFeature/modificationType/term").getValueFromBean(pe)) {
            if (!o.toString().contains(term)) continue;
            return true;
        }
        return false;
    }

    protected boolean nameContains(Named named, String term) {
        if (named.getDisplayName() != null && named.getDisplayName().toLowerCase().contains(term)) {
            return true;
        }
        if (named.getStandardName() != null && named.getStandardName().toLowerCase().contains(term)) {
            return true;
        }
        for (String name : named.getName()) {
            if (!name.toLowerCase().contains(term)) continue;
            return true;
        }
        return false;
    }

    protected boolean activityInName(Named named, boolean active) {
        if (!active) {
            return this.nameContains(named, "inactiv");
        }
        return this.nameContains(named, "activ") && !this.nameContains(named, "inactiv");
    }
}

