/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.alteredreaction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cbio.causality.model.Alteration;
import org.cbio.causality.model.AlterationPack;
import org.cbio.causality.model.Change;

public class Reaction {
    public String ID;
    public List<String> genes = new ArrayList<String>();
    Map<String, AlterationPack> alterations = new HashMap<String, AlterationPack>();
    Map<String, Integer> shares;
    public Change[] changes;
    Integer coverage;
    Double score;

    public void fillShares() {
        this.shares = new HashMap<String, Integer>();
        for (String gene : this.genes) {
            AlterationPack pack = this.alterations.get(gene);
            int cnt = pack.getAlteredCount(Alteration.ANY);
            this.shares.put(gene, cnt);
        }
        this.score = 1.0;
        this.assignScore();
    }

    private void assignScore() {
        for (Integer integer : this.shares.values()) {
            this.score = this.score * (double)integer.intValue();
        }
        this.score = Math.pow(this.score, 1.0 / (double)this.shares.size());
    }

    public void sortGenes() {
        if (this.shares == null) {
            this.fillShares();
        }
        Collections.sort(this.genes, new Comparator<String>(){

            @Override
            public int compare(String gene1, String gene2) {
                int c = Reaction.this.shares.get(gene2).compareTo(Reaction.this.shares.get(gene1));
                if (c != 0) {
                    return c;
                }
                return gene1.compareTo(gene2);
            }
        });
    }

    public void fillChanges() {
        this.changes = new Change[this.alterations.get(this.genes.get(0)).getSize()];
        int cnt = 0;
        for (int i = 0; i < this.changes.length; ++i) {
            for (String gene : this.genes) {
                if (!this.alterations.get(gene).getChange(Alteration.ANY, i).isAltered()) continue;
                this.changes[i] = Change.ACTIVATING;
                ++cnt;
                break;
            }
            if (this.changes[i] != null) continue;
            this.changes[i] = Change.NO_CHANGE;
        }
        this.coverage = cnt;
    }

    public boolean isSubsetOf(Reaction r) {
        return r.genes.containsAll(this.genes) && r.genes.size() > this.genes.size();
    }

    public String toString() {
        return this.ID + "\t" + this.coverage + "\t" + this.getGeneNames();
    }

    public String getGeneNames() {
        String s = "";
        for (String gene : this.genes) {
            s = s + "\t" + gene;
        }
        return s.trim();
    }

    public double getCoverageRatio() {
        return (double)this.coverage.intValue() / (double)this.changes.length;
    }
}

