/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.analysis;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.model.Edge;
import org.biopax.paxtools.query.model.GraphObject;
import org.biopax.paxtools.query.model.Node;

public class BFS {
    protected Map<GraphObject, Integer> dist;
    protected Map<GraphObject, Integer> colors;
    protected Set<org.cbio.causality.model.Node> sourceSet;
    protected Set<org.cbio.causality.model.Node> stopSet;
    protected Direction direction;
    protected int limit;
    protected LinkedList<org.cbio.causality.model.Node> queue;
    protected boolean startFromTranscription;
    public static final boolean UPWARD = true;
    public static final boolean DOWNWARD = false;
    public static final int WHITE = 0;
    public static final int GRAY = 1;
    public static final int BLACK = 2;

    public BFS(Set<org.cbio.causality.model.Node> sourceSet, Set<org.cbio.causality.model.Node> stopSet, Direction direction, int limit, boolean startFromTranscription) {
        if (direction == Direction.BOTHSTREAM) {
            throw new IllegalArgumentException("BOTHSTREAM is not a valid parameter in BFS");
        }
        if (startFromTranscription && direction == Direction.DOWNSTREAM) {
            throw new IllegalArgumentException("Cannot start from transcription when going downstream");
        }
        this.sourceSet = sourceSet;
        this.stopSet = stopSet;
        this.direction = direction;
        this.limit = limit;
        this.startFromTranscription = startFromTranscription;
    }

    public BFS() {
    }

    public Map<GraphObject, Integer> run() {
        return this.runBFS();
    }

    public Map<GraphObject, Integer> runBFS() {
        this.initMaps();
        if (this.limit > 0) {
            this.queue.addAll(this.sourceSet);
        }
        for (org.cbio.causality.model.Node source : this.sourceSet) {
            this.setLabel(source, 0);
            this.setColor(source, 1);
            source.setPathSign(1);
            this.labelEquivRecursive(source, true, 0, true, false, 1);
            this.labelEquivRecursive(source, false, 0, true, false, 1);
        }
        while (!this.queue.isEmpty()) {
            org.cbio.causality.model.Node current = this.queue.remove(0);
            this.processNode(current);
            this.setColor(current, 2);
        }
        return this.dist;
    }

    protected void initMaps() {
        this.dist = new HashMap<GraphObject, Integer>();
        this.colors = new HashMap<GraphObject, Integer>();
        this.queue = new LinkedList();
    }

    protected void processNode(org.cbio.causality.model.Node current) {
        if (current.isUbique()) {
            this.setColor(current, 2);
            return;
        }
        for (Edge edge : this.direction == Direction.DOWNSTREAM ? current.getDownstream() : current.getUpstream()) {
            boolean further;
            assert (edge != null);
            if (this.direction == Direction.DOWNSTREAM || !current.isBreadthNode()) {
                this.setLabel(edge, this.getLabel(current));
            } else {
                this.setLabel(edge, this.getLabel(current) + 1);
            }
            org.cbio.causality.model.Node neigh = (org.cbio.causality.model.Node)(this.direction == Direction.DOWNSTREAM ? edge.getTargetNode() : edge.getSourceNode());
            assert (neigh != null);
            int pathSign = current.getPathSign() * edge.getSign();
            int dist = this.getLabel(edge);
            if (neigh.isBreadthNode() && this.direction == Direction.DOWNSTREAM) {
                ++dist;
            }
            boolean bl = further = !(this.stopSet != null && this.isEquivalentInTheSet(neigh, this.stopSet) || neigh.isBreadthNode() && dist >= this.limit || neigh.isUbique() || this.startFromTranscription && !neigh.isBreadthNode() && dist <= 1 && !neigh.isTranscription());
            if (this.getColor(neigh) == 0) {
                this.setLabel(neigh, dist);
                neigh.setPathSign(pathSign);
                if (further) {
                    this.setColor(neigh, 1);
                    if (neigh.isBreadthNode()) {
                        this.queue.addLast(neigh);
                    } else {
                        this.queue.addFirst(neigh);
                    }
                } else {
                    this.setColor(neigh, 2);
                }
            } else if (this.getLabel(neigh) == dist && neigh.getPathSign() != pathSign) {
                neigh.setPathSign(0);
            }
            this.labelEquivRecursive(neigh, true, dist, further, !neigh.isBreadthNode(), pathSign);
            this.labelEquivRecursive(neigh, false, dist, further, !neigh.isBreadthNode(), pathSign);
        }
    }

    protected void labelEquivRecursive(org.cbio.causality.model.Node node, boolean up, int dist, boolean enqueue, boolean head, int pathSign) {
        for (Node equivalent : up ? node.getUpperEquivalent() : node.getLowerEquivalent()) {
            org.cbio.causality.model.Node equiv = (org.cbio.causality.model.Node)equivalent;
            if (this.getColor(equiv) == 0) {
                this.setLabel(equiv, dist);
                equiv.setPathSign(pathSign);
                if (enqueue) {
                    this.setColor(equiv, 1);
                    if (head) {
                        this.queue.addFirst(equiv);
                    } else {
                        this.queue.add(equiv);
                    }
                } else {
                    this.setColor(equiv, 2);
                }
            } else if (this.getLabel(equiv) == dist && equiv.getPathSign() != pathSign) {
                equiv.setPathSign(0);
            }
            this.labelEquivRecursive(equiv, up, dist, enqueue, head, pathSign);
        }
    }

    protected boolean isEquivalentInTheSet(org.cbio.causality.model.Node node, Set<org.cbio.causality.model.Node> set) {
        return set.contains(node) || this.isEquivalentInTheSet(node, true, set) || this.isEquivalentInTheSet(node, false, set);
    }

    protected boolean isEquivalentInTheSet(org.cbio.causality.model.Node node, boolean direction, Set<org.cbio.causality.model.Node> set) {
        for (Node equivalent : direction ? node.getUpperEquivalent() : node.getLowerEquivalent()) {
            org.cbio.causality.model.Node eq = (org.cbio.causality.model.Node)equivalent;
            if (set.contains(eq)) {
                return true;
            }
            boolean isIn = this.isEquivalentInTheSet(eq, direction, set);
            if (!isIn) continue;
            return true;
        }
        return false;
    }

    protected int getColor(org.cbio.causality.model.Node node) {
        if (!this.colors.containsKey(node)) {
            return 0;
        }
        return this.colors.get(node);
    }

    protected void setColor(org.cbio.causality.model.Node node, int color) {
        this.colors.put(node, color);
    }

    public int getLabel(GraphObject go) {
        if (!this.dist.containsKey(go)) {
            return Integer.MAX_VALUE - this.limit * 2;
        }
        return this.dist.get(go);
    }

    protected void setLabel(GraphObject go, int label) {
        this.dist.put(go, label);
    }
}

