/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.cbio.causality.analysis.BranchDataProvider;
import org.cbio.causality.analysis.GeneBranch;
import org.cbio.causality.analysis.Graph;

public class UpstreamTree {
    private Graph trav;
    private Graph lastStep;
    private BranchDataProvider data;

    public UpstreamTree(Graph trav, Graph lastStep, BranchDataProvider data) {
        this.trav = trav;
        this.lastStep = lastStep;
        this.data = data;
    }

    public UpstreamTree(Graph trav, Graph lastStep) {
        this(trav, lastStep, null);
    }

    public UpstreamTree(Graph trav) {
        this(trav, null, null);
    }

    public GeneBranch getTree(String to, Set<String> from, int limit) {
        GeneBranch result = new GeneBranch(to, this.data);
        HashMap<String, GeneBranch> map = new HashMap<String, GeneBranch>();
        HashMap<String, Integer> dist = new HashMap<String, Integer>();
        HashSet<String> visited = new HashSet<String>();
        visited.add(to);
        dist.put(to, 0);
        LinkedList<String> queue = new LinkedList<String>();
        for (String up : this.lastStep != null ? this.lastStep.getUpstream(to) : this.trav.getUpstream(to)) {
            dist.put(up, 1);
            visited.add(up);
            queue.add(up);
            GeneBranch node = new GeneBranch(up, this.data, to);
            result.branches.add(node);
            map.put(up, node);
        }
        for (int i = 2; i <= limit && !queue.isEmpty(); ++i) {
            ArrayList temp = new ArrayList(queue);
            queue.clear();
            for (String gene : temp) {
                assert (visited.contains(gene));
                assert (map.containsKey(gene));
                for (String up : this.trav.getUpstream(gene)) {
                    if (visited.contains(up)) {
                        if ((Integer)dist.get(up) != (Integer)dist.get(gene) + 1) continue;
                        ((GeneBranch)map.get((Object)gene)).branches.add((GeneBranch)map.get(up));
                        continue;
                    }
                    dist.put(up, i);
                    visited.add(up);
                    queue.add(up);
                    GeneBranch node = new GeneBranch(up, this.data, to);
                    if (!map.containsKey(gene)) {
                        System.out.println();
                    }
                    ((GeneBranch)map.get((Object)gene)).branches.add(node);
                    map.put(up, node);
                }
            }
        }
        result.removeNonTargetLeaf(from);
        return result;
    }
}

