/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.cbio.causality.data.AlterationProviderAdaptor;
import org.cbio.causality.idmapping.EntrezGene;
import org.cbio.causality.model.Alteration;
import org.cbio.causality.model.AlterationPack;
import org.cbio.causality.model.Change;
import org.cbio.causality.model.Node;
import org.cbio.causality.util.Summary;

public class GEOAccessor
extends AlterationProviderAdaptor {
    protected String gseID;
    protected String platformID;
    protected int[] testIndex;
    protected int[] controlIndex;
    protected Map<String, double[]> dataMap;
    protected Map<String, AlterationPack> memo;
    protected static String dataDirectory = "target/geo_data";
    protected static final String SERIES_URL_PREFIX = "ftp://ftp.ncbi.nih.gov/pub/geo/DATA/SeriesMatrix/";
    protected static final String SERIES_URL_SUFFIX = "_series_matrix.txt.gz";
    protected static final String PLATFORM_URL_PREFIX = "http://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?targ=self&form=text&view=data&acc=";
    protected static final String PLATFORM_LINE_INDICATOR = "!Series_platform_id";
    protected static final String[] EG_NAMES = new String[]{"ENTREZ_GENE_ID", "GENE"};
    protected static final String[] SYMBOL_NAMES = new String[]{"Gene Symbol", "GENE_SYMBOL"};
    static double devThr = 2.0;
    static double changeThr = 1.0;
    static double changeThrInverse = 1.0 / changeThr;

    public GEOAccessor(String gseID, int[] testIndex, int[] controlIndex) {
        this.gseID = gseID;
        this.testIndex = testIndex;
        this.controlIndex = controlIndex;
        try {
            this.parse();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void parse() throws IOException {
        System.out.println("Getting data file");
        File seriesFile = this.getSeriesFile();
        System.out.println("Getting platform file");
        File platformFile = this.getPlatformFile();
        System.out.println("Reading data");
        Map<String, List<String>> refMap = this.parsePlatform(platformFile);
        this.dataMap = this.parseDataFile(seriesFile, refMap);
        this.memo = new HashMap<String, AlterationPack>();
    }

    protected File getSeriesFile() {
        File file = new File(dataDirectory + File.separator + this.gseID);
        if (!file.exists()) {
            try {
                this.downloadSeries(this.gseID);
            }
            catch (IOException e) {
                System.err.println(e);
                return null;
            }
        }
        return file;
    }

    protected File getPlatformFile() {
        String fname;
        File file;
        if (this.platformID == null) {
            try {
                this.platformID = this.extractPlatformID(this.gseID);
            }
            catch (IOException e) {
                System.err.println(e);
                return null;
            }
        }
        if (!(file = new File(fname = dataDirectory + File.separator + this.platformID)).exists()) {
            try {
                this.downloadPlatformFile(this.platformID);
            }
            catch (IOException e) {
                System.err.println(e);
                return null;
            }
        }
        assert (file != null) : "Failed to download the file: " + fname;
        return file;
    }

    protected void downloadSeries(String gseID) throws IOException {
        int len;
        String URLname = SERIES_URL_PREFIX + gseID + "/" + gseID + SERIES_URL_SUFFIX;
        URL url = new URL(URLname);
        URLConnection con = url.openConnection();
        GZIPInputStream in = new GZIPInputStream(con.getInputStream());
        String target = dataDirectory + File.separator + gseID;
        FileOutputStream out = new FileOutputStream(target);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        in.close();
        ((OutputStream)out).close();
    }

    protected void downloadPlatformFile(String platformID) throws IOException {
        String currentRead;
        String URLname = PLATFORM_URL_PREFIX + platformID;
        URL url = new URL(URLname);
        URLConnection con = url.openConnection();
        BufferedWriter writer = new BufferedWriter(new FileWriter(dataDirectory + File.separator + platformID));
        BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
        while ((currentRead = reader.readLine()) != null) {
            writer.write(currentRead + "\n");
        }
        reader.close();
        writer.close();
    }

    protected String extractPlatformID(String gseID) throws IOException {
        String currentLine;
        File gseFile = new File(dataDirectory + File.separator + gseID);
        if (!gseFile.exists()) {
            this.downloadSeries(gseID);
        }
        BufferedReader br = new BufferedReader(new FileReader(gseFile));
        String platformName = null;
        while ((currentLine = br.readLine()) != null) {
            if (!currentLine.contains(PLATFORM_LINE_INDICATOR)) continue;
            platformName = currentLine.substring(currentLine.indexOf("G"), currentLine.lastIndexOf("\""));
            break;
        }
        return platformName;
    }

    protected boolean ignoreLine(String line) {
        return line.startsWith("^") || line.startsWith("!") || line.startsWith("#") || line.trim().length() == 0;
    }

    protected int indexOf(String[] array, String s) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(s)) continue;
            return i;
        }
        return -1;
    }

    protected int getColIndex(String[] cols, String[] possibleNames) {
        for (String name : possibleNames) {
            int ind = this.indexOf(cols, name);
            if (ind <= 0) continue;
            return ind;
        }
        return -1;
    }

    protected String[] parseToken(String token) {
        return token.split("[/ ]+");
    }

    protected Set<String> getEGIDs(String egs, String syms) {
        HashSet<String> ids = new HashSet<String>();
        if (egs != null) {
            ids.addAll(Arrays.asList(this.parseToken(egs)));
        }
        for (String sym : this.parseToken(syms)) {
            String id = EntrezGene.getID(sym);
            if (id == null) continue;
            ids.add(id);
        }
        return ids;
    }

    protected Map<String, List<String>> parsePlatform(File platformFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(platformFile));
        String line = reader.readLine();
        while (this.ignoreLine(line)) {
            line = reader.readLine();
        }
        String[] col = line.split("\t");
        int egIndex = this.getColIndex(col, EG_NAMES);
        int symIndex = this.getColIndex(col, SYMBOL_NAMES);
        if (egIndex < 0 && symIndex < 0) {
            throw new RuntimeException("Entrez Gene or Gene Symbol column not recognized. Header = " + line);
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        line = reader.readLine();
        while (line != null) {
            String[] s;
            if (!(this.ignoreLine(line) || (s = line.split("\t")).length <= egIndex && s.length <= symIndex)) {
                String sym;
                String id = s[0];
                String eg = egIndex > 0 ? s[egIndex].trim() : null;
                String string = sym = symIndex > 0 ? s[symIndex].trim() : null;
                if (eg != null && eg.length() != 0 || sym != null && sym.length() != 0) {
                    map.put(id, new ArrayList<String>(this.getEGIDs(eg, sym)));
                }
            }
            line = reader.readLine();
        }
        reader.close();
        return map;
    }

    protected double[] toNum(String[] valStr) {
        double[] v = new double[valStr.length];
        for (int i = 0; i < v.length; ++i) {
            try {
                v[i] = Double.parseDouble(valStr[i]);
                continue;
            }
            catch (NumberFormatException e) {
                v[i] = Double.NaN;
            }
        }
        return v;
    }

    protected Map<String, double[]> selectOne(Map<String, List<double[]>> eg2vals) {
        HashMap<String, double[]> eg2val = new HashMap<String, double[]>();
        for (String eg : eg2vals.keySet()) {
            double max = -1.7976931348623157E308;
            double[] maxV = null;
            for (double[] v : eg2vals.get(eg)) {
                double mean = Summary.absoluteMean(v);
                if (!(mean > max)) continue;
                max = mean;
                maxV = v;
            }
            eg2val.put(eg, maxV);
        }
        return eg2val;
    }

    protected Map<String, double[]> parseDataFile(File dataFile, Map<String, List<String>> refMap) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(dataFile));
        String line = reader.readLine();
        while (this.ignoreLine(line)) {
            line = reader.readLine();
        }
        reader.readLine();
        HashMap<String, List<double[]>> eg2vals = new HashMap<String, List<double[]>>();
        line = reader.readLine();
        while (line != null) {
            if (!this.ignoreLine(line)) {
                int tabind = line.indexOf("\t");
                String id = line.substring(0, tabind);
                if (id.startsWith("\"")) {
                    id = id.substring(1, id.length() - 1);
                }
                String[] valStr = line.substring(tabind + 1).split("\t");
                if (refMap.containsKey(id)) {
                    for (String eg : refMap.get(id)) {
                        if (!eg2vals.containsKey(eg)) {
                            eg2vals.put(eg, new ArrayList());
                        }
                        ((List)eg2vals.get(eg)).add(this.toNum(valStr));
                    }
                }
            }
            line = reader.readLine();
        }
        return this.selectOne(eg2vals);
    }

    @Override
    public AlterationPack getAlterations(Node node) {
        String id = this.getEntrezGeneID(node);
        if (this.memo.containsKey(id)) {
            return this.memo.get(id);
        }
        AlterationPack alt = this.getAlterations(id);
        this.memo.put(id, alt);
        return alt;
    }

    @Override
    public AlterationPack getAlterations(String id) {
        double[] value = this.dataMap.get(id);
        if (value == null) {
            return null;
        }
        double ctrlMean = Summary.mean(value, this.controlIndex);
        double ctrlSD = Summary.stdev(value, this.controlIndex);
        Change[] ch = new Change[this.testIndex.length];
        int index = 0;
        for (int i : this.testIndex) {
            double ratio = value[i] / ctrlMean;
            double dif = Math.abs(value[i] - ctrlMean);
            ch[index] = Change.NO_CHANGE;
            if (dif > devThr * ctrlSD) {
                if (ratio > changeThr) {
                    ch[index] = Change.ACTIVATING;
                } else if (ratio < changeThrInverse) {
                    ch[index] = Change.INHIBITING;
                }
            }
            ++index;
        }
        AlterationPack pack = new AlterationPack(id);
        pack.put(Alteration.EXPRESSION, ch);
        return pack;
    }

    static {
        File file = new File(dataDirectory);
        if (!file.exists()) {
            file.mkdirs();
        }
    }
}

