/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.network;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cbio.causality.network.HPRD;
import org.cbio.causality.network.InteractionProvider;

public class ShuffledHPRD
implements InteractionProvider {
    private Map<String, String> redirectFwd;
    private Map<String, String> redirectBkw;
    private Map<String, Set<String>> map;

    public ShuffledHPRD() {
        this.initShuffledPreserveDegrees();
    }

    private void initShuffledPlain() {
        ArrayList<String> list1 = new ArrayList<String>(HPRD.getAllSymbols());
        ArrayList<String> list2 = new ArrayList<String>(list1);
        Collections.shuffle(list2);
        this.initShuffledMapping(list1, list2);
    }

    private void initShuffledPreserveDegrees() {
        ArrayList<String> genes = new ArrayList<String>(HPRD.getAllSymbols());
        Collections.sort(genes, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.valueOf(HPRD.getInteractors(o2).size()).compareTo(HPRD.getInteractors(o1).size());
            }
        });
        int start = 0;
        int end = 0;
        int prevDegree = HPRD.getDegree((String)genes.get(0));
        ArrayList<String> shuffled = new ArrayList<String>();
        for (String gene : genes) {
            int degree = HPRD.getDegree(gene);
            if (degree == prevDegree) {
                ++end;
                continue;
            }
            if (degree < prevDegree) {
                ArrayList list = new ArrayList(genes.subList(start, end));
                Collections.shuffle(list);
                shuffled.addAll(list);
                start = end++;
                prevDegree = degree;
                continue;
            }
            throw new AssertionError((Object)"Should not reach here");
        }
        List list = genes.subList(start, end);
        Collections.shuffle(list);
        shuffled.addAll(list);
        assert (genes.size() == shuffled.size());
        this.initShuffledMapping(genes, shuffled);
    }

    private void initShuffledAlmostPreserveDegrees() {
        ArrayList<String> genes = new ArrayList<String>(HPRD.getAllSymbols());
        Collections.sort(genes, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.valueOf(HPRD.getInteractors(o2).size()).compareTo(HPRD.getInteractors(o1).size());
            }
        });
        int size = genes.size();
        int bins = 1000;
        ArrayList[] list = new ArrayList[bins];
        for (int i = 0; i < bins; ++i) {
            list[i] = new ArrayList(genes.subList((int)Math.floor((double)(i * size) / (double)bins), (int)Math.floor((double)((i + 1) * size) / (double)bins)));
            Collections.shuffle(list[i]);
        }
        ArrayList<String> shuffled = new ArrayList<String>();
        for (ArrayList aList : list) {
            shuffled.addAll(aList);
        }
        this.initShuffledMapping(genes, shuffled);
    }

    private void initShuffledMapping(List<String> genes, List<String> shuffled) {
        this.redirectFwd = new HashMap<String, String>(genes.size());
        this.redirectBkw = new HashMap<String, String>(genes.size());
        for (int i = 0; i < genes.size(); ++i) {
            this.redirectFwd.put(genes.get(i), shuffled.get(i));
            this.redirectBkw.put(shuffled.get(i), genes.get(i));
        }
        this.map = new HashMap<String, Set<String>>(genes.size());
    }

    private void writeDegrees(List<String> genes) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter("/home/ozgun/Desktop/degrees.txt"));
        for (String gene : genes) {
            writer.write(HPRD.getInteractors(gene).size() + "\t" + gene + "\n");
        }
        writer.close();
    }

    @Override
    public Set<String> getInteractions(String symbol) {
        if (this.map.containsKey(symbol)) {
            return new HashSet<String>((Collection)this.map.get(symbol));
        }
        String s = this.redirectBkw.get(symbol);
        Set<String> inter = HPRD.getInteractors(s);
        HashSet<String> redirInter = new HashSet<String>(inter.size());
        for (String s1 : inter) {
            redirInter.add(this.redirectFwd.get(s1));
        }
        this.map.put(symbol, redirInter);
        return new HashSet<String>((Collection)this.map.get(symbol));
    }
}

