/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.rppa;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.cbio.causality.network.PhosphoSitePlus;
import org.cbio.causality.rppa.RPPAData;
import org.cbio.causality.rppa.RPPAFileReader;
import org.cbio.causality.rppa.RPPANetworkMapper;
import org.cbio.causality.util.BaseDir;

public class RPPAFrontFace {
    public static void generateRPPAGraphs(String platformFile, String idColumn, String symbolsColumn, String sitesColumn, String effectColumn, String valuesFile, String valueColumn, double valueThreshold, String graphType, boolean siteMatchStrict, boolean geneCentric, String outputFilePrefix, String customNetworkDirectory) throws IOException {
        RPPANetworkMapper.GraphType type;
        if (customNetworkDirectory != null) {
            BaseDir.setDir(customNetworkDirectory);
        }
        List<RPPAData> datas = RPPAFileReader.readAnnotation(platformFile, idColumn, symbolsColumn, sitesColumn, effectColumn);
        List<String> vals0 = Arrays.asList(valueColumn);
        RPPAFileReader.addValues(datas, valuesFile, idColumn, vals0, null, 0.0);
        RPPAData.ChangeAdapter chDet = new RPPAData.ChangeAdapter(){};
        chDet.setThreshold(valueThreshold);
        for (RPPAData data : datas) {
            if (data.isActivity()) continue;
            data.setChDet(chDet);
        }
        PhosphoSitePlus.fillInMissingEffect(datas, 0);
        RPPANetworkMapper.GraphType graphType2 = graphType.toLowerCase().startsWith("conflict") ? (siteMatchStrict ? RPPANetworkMapper.GraphType.CONFLICTING_WITH_SITE_MATCH : RPPANetworkMapper.GraphType.CONFLICTING) : (type = siteMatchStrict ? RPPANetworkMapper.GraphType.COMPATIBLE_WITH_SITE_MATCH : RPPANetworkMapper.GraphType.COMPATIBLE);
        if (geneCentric) {
            RPPANetworkMapper.writeGraph(datas, valueThreshold, outputFilePrefix + ".sif", type, null);
        } else {
            RPPANetworkMapper.writeGraphAntibodyCentric(datas, valueThreshold, outputFilePrefix + ".sif", type, null);
        }
    }

    public static void main(String[] args) throws IOException {
        RPPAFrontFace.generateRPPAGraphs("/home/ozgun/Documents/JQ1/abdata-chibe.txt", "ID1", "Symbols", "Sites", "Effect", "/home/ozgun/Documents/JQ1/ovcar4_dif_drug_sig.txt", "change", 0.001, "compatible", true, false, "/home/ozgun/Temp/temp", null);
    }
}

