/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.internal.localstore.Bucket;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class BucketTree {
    public static final int DEPTH_INFINITE = Integer.MAX_VALUE;
    public static final int DEPTH_ONE = 1;
    public static final int DEPTH_ZERO = 0;
    private static final int SEGMENT_LENGTH = 2;
    private static final long SEGMENT_QUOTA = (long)Math.pow(2.0, 8.0);
    private static final String VERSION_FILE_EXT = ".version";
    protected Bucket current;
    private Workspace workspace;

    public BucketTree(Workspace workspace, Bucket bucket) {
        this.current = bucket;
        this.workspace = workspace;
    }

    public void accept(Bucket.Visitor visitor, IPath base, int depth) throws CoreException {
        if (Path.ROOT.equals(base)) {
            this.current.load(null, this.locationFor(Path.ROOT));
            if (this.current.accept(visitor, base, 0) != 0) {
                return;
            }
            if (depth == 0) {
                return;
            }
            boolean keepVisiting = true;
            --depth;
            IProject[] projects = this.workspace.getRoot().getProjects();
            int i = 0;
            while (keepVisiting && i < projects.length) {
                IPath projectPath = projects[i].getFullPath();
                keepVisiting = this.internalAccept(visitor, projectPath, this.locationFor(projectPath), depth, 1);
                ++i;
            }
        } else {
            this.internalAccept(visitor, base, this.locationFor(base), depth, 0);
        }
    }

    public void close() throws CoreException {
        this.current.save();
        this.saveVersion();
    }

    public Bucket getCurrent() {
        return this.current;
    }

    public File getVersionFile() {
        return new File(this.locationFor(Path.ROOT), String.valueOf(this.current.getFileName()) + VERSION_FILE_EXT);
    }

    private boolean internalAccept(Bucket.Visitor visitor, IPath base, File bucketDir, int depthRequested, int currentDepth) throws CoreException {
        this.current.load(base.segment(0), bucketDir);
        int outcome = this.current.accept(visitor, base, depthRequested);
        if (outcome != 0) {
            return outcome == 2;
        }
        if (depthRequested <= currentDepth) {
            return true;
        }
        File[] subDirs = bucketDir.listFiles();
        if (subDirs == null) {
            return true;
        }
        int i = 0;
        while (i < subDirs.length) {
            if (subDirs[i].isDirectory() && !this.internalAccept(visitor, base, subDirs[i], depthRequested, currentDepth + 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void loadBucketFor(IPath path) throws CoreException {
        this.current.load(Path.ROOT.equals(path) ? null : path.segment(0), this.locationFor(path));
    }

    private File locationFor(IPath resourcePath) {
        IPath baseLocation = this.workspace.getMetaArea().locationFor(resourcePath);
        int segmentCount = resourcePath.segmentCount();
        baseLocation = baseLocation.append(".indexes");
        if (segmentCount <= 1) {
            return baseLocation.toFile();
        }
        IPath location = baseLocation;
        int i = 1;
        while (i < segmentCount - 1) {
            location = location.append(this.translateSegment(resourcePath.segment(i)));
            ++i;
        }
        return location.toFile();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveVersion() throws CoreException {
        File versionFile = this.getVersionFile();
        if (!versionFile.getParentFile().exists()) {
            versionFile.getParentFile().mkdirs();
        }
        FileOutputStream stream = null;
        boolean failed = false;
        try {
            try {
                stream = new FileOutputStream(versionFile);
                stream.write(this.current.getVersion());
            }
            catch (IOException e) {
                failed = true;
                String message = NLS.bind(Messages.resources_writeWorkspaceMeta, versionFile.getAbsolutePath());
                throw new ResourceException(568, null, message, e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                if (failed) throw throwable;
                String message = NLS.bind(Messages.resources_writeWorkspaceMeta, versionFile.getAbsolutePath());
                throw new ResourceException(568, null, message, e);
            }
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (IOException e) {
            if (failed) return;
            String message = NLS.bind(Messages.resources_writeWorkspaceMeta, versionFile.getAbsolutePath());
            throw new ResourceException(568, null, message, e);
        }
        if (stream == null) return;
        stream.close();
    }

    private String translateSegment(String segment) {
        return Long.toHexString((long)Math.abs(segment.hashCode()) % SEGMENT_QUOTA);
    }
}

