/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class ScaledGraphics
extends Graphics {
    private static int[][] intArrayCache = new int[8][];
    private final Rectangle tempRECT = new Rectangle();
    private boolean allowText = true;
    private Map fontCache = new HashMap();
    private Map fontDataCache = new HashMap();
    private FontKey fontKey = new FontKey();
    private double fractionalX;
    private double fractionalY;
    private Graphics graphics;
    private FontHeightCache localCache = new FontHeightCache();
    private Font localFont;
    private int localLineWidth;
    private List stack = new ArrayList();
    private int stackPointer = 0;
    private FontHeightCache targetCache = new FontHeightCache();
    double zoom = 1.0;

    static {
        int i = 0;
        while (i < intArrayCache.length) {
            ScaledGraphics.intArrayCache[i] = new int[i + 1];
            ++i;
        }
    }

    public ScaledGraphics(Graphics g) {
        this.graphics = g;
        this.localFont = g.getFont();
        this.localLineWidth = g.getLineWidth();
    }

    public void clipRect(Rectangle r) {
        this.graphics.clipRect(this.zoomClipRect(r));
    }

    Font createFont(FontData data) {
        return new Font((Device)Display.getCurrent(), data);
    }

    private Path createScaledPath(Path path) {
        PathData p = path.getPathData();
        int i = 0;
        while (i < p.points.length) {
            p.points[i] = (float)((double)p.points[i] * this.zoom + this.fractionalX);
            p.points[i + 1] = (float)((double)p.points[i + 1] * this.zoom + this.fractionalY);
            i += 2;
        }
        Path scaledPath = new Path(path.getDevice());
        int index = 0;
        int i2 = 0;
        while (i2 < p.types.length) {
            byte type = p.types[i2];
            switch (type) {
                case 1: {
                    scaledPath.moveTo(p.points[index], p.points[index + 1]);
                    index += 2;
                    break;
                }
                case 2: {
                    scaledPath.lineTo(p.points[index], p.points[index + 1]);
                    index += 2;
                    break;
                }
                case 4: {
                    scaledPath.cubicTo(p.points[index], p.points[index + 1], p.points[index + 2], p.points[index + 3], p.points[index + 4], p.points[index + 5]);
                    index += 6;
                    break;
                }
                case 3: {
                    scaledPath.quadTo(p.points[index], p.points[index + 1], p.points[index + 2], p.points[index + 3]);
                    index += 4;
                    break;
                }
                case 5: {
                    scaledPath.close();
                }
            }
            ++i2;
        }
        return scaledPath;
    }

    public void dispose() {
        while (this.stackPointer > 0) {
            this.popState();
        }
        Iterator iter = this.fontCache.values().iterator();
        while (iter.hasNext()) {
            Font font = (Font)iter.next();
            font.dispose();
        }
    }

    public void drawArc(int x, int y, int w, int h, int offset, int sweep) {
        Rectangle z = this.zoomRect(x, y, w, h);
        if (z.isEmpty() || sweep == 0) {
            return;
        }
        this.graphics.drawArc(z, offset, sweep);
    }

    public void drawFocus(int x, int y, int w, int h) {
        this.graphics.drawFocus(this.zoomRect(x, y, w, h));
    }

    public void drawImage(Image srcImage, int x, int y) {
        org.eclipse.swt.graphics.Rectangle size = srcImage.getBounds();
        this.graphics.drawImage(srcImage, 0, 0, size.width, size.height, (int)Math.floor((double)x * this.zoom + this.fractionalX), (int)Math.floor((double)y * this.zoom + this.fractionalY), (int)Math.floor((double)size.width * this.zoom + this.fractionalX), (int)Math.floor((double)size.height * this.zoom + this.fractionalY));
    }

    public void drawImage(Image srcImage, int sx, int sy, int sw, int sh, int tx, int ty, int tw, int th) {
        Rectangle t = this.zoomRect(tx, ty, tw, th);
        if (!t.isEmpty()) {
            this.graphics.drawImage(srcImage, sx, sy, sw, sh, t.x, t.y, t.width, t.height);
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.graphics.drawLine((int)Math.floor((double)x1 * this.zoom + this.fractionalX), (int)Math.floor((double)y1 * this.zoom + this.fractionalY), (int)Math.floor((double)x2 * this.zoom + this.fractionalX), (int)Math.floor((double)y2 * this.zoom + this.fractionalY));
    }

    public void drawOval(int x, int y, int w, int h) {
        this.graphics.drawOval(this.zoomRect(x, y, w, h));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drawPath(Path path) {
        Path scaledPath = this.createScaledPath(path);
        try {
            this.graphics.drawPath(scaledPath);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            scaledPath.dispose();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        scaledPath.dispose();
    }

    public void drawPoint(int x, int y) {
        this.graphics.drawPoint((int)Math.floor((double)x * this.zoom + this.fractionalX), (int)Math.floor((double)y * this.zoom + this.fractionalY));
    }

    public void drawPolygon(int[] points) {
        this.graphics.drawPolygon(this.zoomPointList(points));
    }

    public void drawPolygon(PointList points) {
        this.graphics.drawPolygon(this.zoomPointList(points.toIntArray()));
    }

    public void drawPolyline(int[] points) {
        this.graphics.drawPolyline(this.zoomPointList(points));
    }

    public void drawPolyline(PointList points) {
        this.graphics.drawPolyline(this.zoomPointList(points.toIntArray()));
    }

    public void drawRectangle(int x, int y, int w, int h) {
        this.graphics.drawRectangle(this.zoomRect(x, y, w, h));
    }

    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.graphics.drawRoundRectangle(this.zoomRect(r.x, r.y, r.width, r.height), (int)((double)arcWidth * this.zoom), (int)((double)arcHeight * this.zoom));
    }

    public void drawString(String s, int x, int y) {
        if (this.allowText) {
            this.graphics.drawString(s, this.zoomTextPoint(x, y));
        }
    }

    public void drawText(String s, int x, int y) {
        if (this.allowText) {
            this.graphics.drawText(s, this.zoomTextPoint(x, y));
        }
    }

    public void drawText(String s, int x, int y, int style) {
        if (this.allowText) {
            this.graphics.drawText(s, this.zoomTextPoint(x, y), style);
        }
    }

    public void drawTextLayout(TextLayout layout, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        TextLayout scaled = this.zoomTextLayout(layout);
        this.graphics.drawTextLayout(scaled, (int)Math.floor((double)x * this.zoom + this.fractionalX), (int)Math.floor((double)y * this.zoom + this.fractionalY), selectionStart, selectionEnd, selectionBackground, selectionForeground);
        scaled.dispose();
    }

    public void fillArc(int x, int y, int w, int h, int offset, int sweep) {
        Rectangle z = this.zoomFillRect(x, y, w, h);
        if (z.isEmpty() || sweep == 0) {
            return;
        }
        this.graphics.fillArc(z, offset, sweep);
    }

    public void fillGradient(int x, int y, int w, int h, boolean vertical) {
        this.graphics.fillGradient(this.zoomFillRect(x, y, w, h), vertical);
    }

    public void fillOval(int x, int y, int w, int h) {
        this.graphics.fillOval(this.zoomFillRect(x, y, w, h));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fillPath(Path path) {
        Path scaledPath = this.createScaledPath(path);
        try {
            this.graphics.fillPath(scaledPath);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            scaledPath.dispose();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        scaledPath.dispose();
    }

    public void fillPolygon(int[] points) {
        this.graphics.fillPolygon(this.zoomPointList(points));
    }

    public void fillPolygon(PointList points) {
        this.graphics.fillPolygon(this.zoomPointList(points.toIntArray()));
    }

    public void fillRectangle(int x, int y, int w, int h) {
        this.graphics.fillRectangle(this.zoomFillRect(x, y, w, h));
    }

    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.graphics.fillRoundRectangle(this.zoomFillRect(r.x, r.y, r.width, r.height), (int)((double)arcWidth * this.zoom), (int)((double)arcHeight * this.zoom));
    }

    public void fillString(String s, int x, int y) {
        if (this.allowText) {
            this.graphics.fillString(s, this.zoomTextPoint(x, y));
        }
    }

    public void fillText(String s, int x, int y) {
        if (this.allowText) {
            this.graphics.fillText(s, this.zoomTextPoint(x, y));
        }
    }

    public double getAbsoluteScale() {
        return this.zoom * this.graphics.getAbsoluteScale();
    }

    public int getAlpha() {
        return this.graphics.getAlpha();
    }

    public int getAntialias() {
        return this.graphics.getAntialias();
    }

    public Color getBackgroundColor() {
        return this.graphics.getBackgroundColor();
    }

    Font getCachedFont(FontKey key) {
        Font font = (Font)this.fontCache.get(key);
        if (font != null) {
            return font;
        }
        key = new FontKey(key.font, key.height);
        FontData data = key.font.getFontData()[0];
        data.setHeight(key.height);
        Font zoomedFont = this.createFont(data);
        this.fontCache.put(key, zoomedFont);
        return zoomedFont;
    }

    FontData getCachedFontData(Font f) {
        FontData data = (FontData)this.fontDataCache.get(f);
        if (data != null) {
            return data;
        }
        data = this.getLocalFont().getFontData()[0];
        this.fontDataCache.put(f, data);
        return data;
    }

    public Rectangle getClip(Rectangle rect) {
        this.graphics.getClip(rect);
        int x = (int)((double)rect.x / this.zoom);
        int y = (int)((double)rect.y / this.zoom);
        rect.width = (int)Math.ceil((double)rect.right() / this.zoom) - x;
        rect.height = (int)Math.ceil((double)rect.bottom() / this.zoom) - y;
        rect.x = x;
        rect.y = y;
        return rect;
    }

    public int getFillRule() {
        return this.graphics.getFillRule();
    }

    public Font getFont() {
        return this.getLocalFont();
    }

    public FontMetrics getFontMetrics() {
        return FigureUtilities.getFontMetrics(this.localFont);
    }

    public Color getForegroundColor() {
        return this.graphics.getForegroundColor();
    }

    public int getInterpolation() {
        return this.graphics.getInterpolation();
    }

    public int getLineCap() {
        return this.graphics.getLineCap();
    }

    public int getLineJoin() {
        return this.graphics.getLineJoin();
    }

    public int getLineStyle() {
        return this.graphics.getLineStyle();
    }

    public int getLineWidth() {
        return this.getLocalLineWidth();
    }

    private Font getLocalFont() {
        return this.localFont;
    }

    private int getLocalLineWidth() {
        return this.localLineWidth;
    }

    public int getTextAntialias() {
        return this.graphics.getTextAntialias();
    }

    public boolean getXORMode() {
        return this.graphics.getXORMode();
    }

    public void popState() {
        this.graphics.popState();
        --this.stackPointer;
        this.restoreLocalState((State)this.stack.get(this.stackPointer));
    }

    public void pushState() {
        if (this.stack.size() > this.stackPointer) {
            State s = (State)this.stack.get(this.stackPointer);
            s.setValues(this.zoom, this.fractionalX, this.fractionalY, this.getLocalFont(), this.localLineWidth);
        } else {
            this.stack.add(new State(this.zoom, this.fractionalX, this.fractionalY, this.getLocalFont(), this.localLineWidth));
        }
        ++this.stackPointer;
        this.graphics.pushState();
    }

    private void restoreLocalState(State state) {
        this.fractionalX = state.appliedX;
        this.fractionalY = state.appliedY;
        this.setScale(state.zoom);
        this.setLocalFont(state.font);
        this.setLocalLineWidth(state.lineWidth);
    }

    public void restoreState() {
        this.graphics.restoreState();
        this.restoreLocalState((State)this.stack.get(this.stackPointer - 1));
    }

    public void scale(double amount) {
        this.setScale(this.zoom * amount);
    }

    public void setAlpha(int alpha) {
        this.graphics.setAlpha(alpha);
    }

    public void setAntialias(int value) {
        this.graphics.setAntialias(value);
    }

    public void setBackgroundColor(Color rgb) {
        this.graphics.setBackgroundColor(rgb);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setClip(Path path) {
        Path scaledPath = this.createScaledPath(path);
        try {
            this.graphics.setClip(scaledPath);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            scaledPath.dispose();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        scaledPath.dispose();
    }

    public void setClip(Rectangle r) {
        this.graphics.setClip(this.zoomClipRect(r));
    }

    public void setFillRule(int rule) {
        this.graphics.setFillRule(rule);
    }

    public void setFont(Font f) {
        this.setLocalFont(f);
    }

    public void setForegroundColor(Color rgb) {
        this.graphics.setForegroundColor(rgb);
    }

    public void setInterpolation(int interpolation) {
        this.graphics.setInterpolation(interpolation);
    }

    public void setLineCap(int cap) {
        this.graphics.setLineCap(cap);
    }

    public void setLineDash(int[] dash) {
        this.graphics.setLineDash(dash);
    }

    public void setLineJoin(int join) {
        this.graphics.setLineJoin(join);
    }

    public void setLineStyle(int style) {
        this.graphics.setLineStyle(style);
    }

    public void setLineWidth(int width) {
        this.setLocalLineWidth(width);
    }

    private void setLocalFont(Font f) {
        this.localFont = f;
        this.graphics.setFont(this.zoomFont(f));
    }

    private void setLocalLineWidth(int width) {
        this.localLineWidth = width;
        this.graphics.setLineWidth(this.zoomLineWidth(width));
    }

    void setScale(double value) {
        if (this.zoom == value) {
            return;
        }
        this.zoom = value;
        this.graphics.setFont(this.zoomFont(this.getLocalFont()));
        this.graphics.setLineWidth(this.zoomLineWidth(this.localLineWidth));
    }

    public void setTextAntialias(int value) {
        this.graphics.setTextAntialias(value);
    }

    public void setXORMode(boolean b) {
        this.graphics.setXORMode(b);
    }

    public void translate(int dx, int dy) {
        double dxFloat = (double)dx * this.zoom + this.fractionalX;
        double dyFloat = (double)dy * this.zoom + this.fractionalY;
        this.fractionalX = dxFloat - Math.floor(dxFloat);
        this.fractionalY = dyFloat - Math.floor(dyFloat);
        this.graphics.translate((int)Math.floor(dxFloat), (int)Math.floor(dyFloat));
    }

    public void translate(float dx, float dy) {
        double dxFloat = (double)dx * this.zoom + this.fractionalX;
        double dyFloat = (double)dy * this.zoom + this.fractionalY;
        this.fractionalX = dxFloat - Math.floor(dxFloat);
        this.fractionalY = dyFloat - Math.floor(dyFloat);
        this.graphics.translate((int)Math.floor(dxFloat), (int)Math.floor(dyFloat));
    }

    private Rectangle zoomClipRect(Rectangle r) {
        this.tempRECT.x = (int)Math.floor((double)r.x * this.zoom + this.fractionalX);
        this.tempRECT.y = (int)Math.floor((double)r.y * this.zoom + this.fractionalY);
        this.tempRECT.width = (int)Math.ceil((double)(r.x + r.width) * this.zoom + this.fractionalX) - this.tempRECT.x;
        this.tempRECT.height = (int)Math.ceil((double)(r.y + r.height) * this.zoom + this.fractionalY) - this.tempRECT.y;
        return this.tempRECT;
    }

    private Rectangle zoomFillRect(int x, int y, int w, int h) {
        this.tempRECT.x = (int)Math.floor((double)x * this.zoom + this.fractionalX);
        this.tempRECT.y = (int)Math.floor((double)y * this.zoom + this.fractionalY);
        this.tempRECT.width = (int)Math.floor((double)(x + w - 1) * this.zoom + this.fractionalX) - this.tempRECT.x + 1;
        this.tempRECT.height = (int)Math.floor((double)(y + h - 1) * this.zoom + this.fractionalY) - this.tempRECT.y + 1;
        return this.tempRECT;
    }

    Font zoomFont(Font f) {
        FontData data;
        int zoomedFontHeight;
        if (f == null) {
            f = Display.getCurrent().getSystemFont();
        }
        this.allowText = (zoomedFontHeight = this.zoomFontHeight((data = this.getCachedFontData(f)).getHeight())) > 0;
        this.fontKey.setValues(f, zoomedFontHeight);
        return this.getCachedFont(this.fontKey);
    }

    int zoomFontHeight(int height) {
        return (int)(this.zoom * (double)height);
    }

    int zoomLineWidth(int w) {
        return w;
    }

    private int[] zoomPointList(int[] points) {
        int[] scaled = null;
        int i = 0;
        while (i < intArrayCache.length) {
            if (intArrayCache[i].length == points.length) {
                scaled = intArrayCache[i];
                if (i != 0) {
                    int[] temp = intArrayCache[i - 1];
                    ScaledGraphics.intArrayCache[i - 1] = scaled;
                    ScaledGraphics.intArrayCache[i] = temp;
                }
            }
            ++i;
        }
        if (scaled == null) {
            ScaledGraphics.intArrayCache[ScaledGraphics.intArrayCache.length - 1] = new int[points.length];
            scaled = intArrayCache[intArrayCache.length - 1];
        }
        i = 0;
        while (i + 1 < points.length) {
            scaled[i] = (int)Math.floor((double)points[i] * this.zoom + this.fractionalX);
            scaled[i + 1] = (int)Math.floor((double)points[i + 1] * this.zoom + this.fractionalY);
            i += 2;
        }
        return scaled;
    }

    private Rectangle zoomRect(int x, int y, int w, int h) {
        this.tempRECT.x = (int)Math.floor((double)x * this.zoom + this.fractionalX);
        this.tempRECT.y = (int)Math.floor((double)y * this.zoom + this.fractionalY);
        this.tempRECT.width = (int)Math.floor((double)(x + w) * this.zoom + this.fractionalX) - this.tempRECT.x;
        this.tempRECT.height = (int)Math.floor((double)(y + h) * this.zoom + this.fractionalY) - this.tempRECT.y;
        return this.tempRECT;
    }

    private TextLayout zoomTextLayout(TextLayout layout) {
        TextLayout zoomed = new TextLayout(Display.getCurrent());
        zoomed.setText(layout.getText());
        int zoomWidth = -1;
        if (layout.getWidth() != -1) {
            zoomWidth = (int)((double)layout.getWidth() * this.zoom);
        }
        if (zoomWidth < -1 || zoomWidth == 0) {
            return null;
        }
        zoomed.setFont(this.zoomFont(layout.getFont()));
        zoomed.setAlignment(layout.getAlignment());
        zoomed.setAscent(layout.getAscent());
        zoomed.setDescent(layout.getDescent());
        zoomed.setOrientation(layout.getOrientation());
        zoomed.setSegments(layout.getSegments());
        zoomed.setSpacing(layout.getSpacing());
        zoomed.setTabs(layout.getTabs());
        zoomed.setWidth(zoomWidth);
        int length = layout.getText().length();
        if (length > 0) {
            int start = 0;
            int offset = 1;
            TextStyle style = null;
            TextStyle lastStyle = layout.getStyle(0);
            while (offset <= length) {
                if (offset == length || (style = layout.getStyle(offset)) != lastStyle) {
                    int end = offset - 1;
                    if (lastStyle != null) {
                        TextStyle zoomedStyle = new TextStyle(this.zoomFont(lastStyle.font), lastStyle.foreground, lastStyle.background);
                        zoomedStyle.metrics = lastStyle.metrics;
                        zoomedStyle.rise = lastStyle.rise;
                        zoomedStyle.strikeout = lastStyle.strikeout;
                        zoomedStyle.underline = lastStyle.underline;
                        zoomed.setStyle(zoomedStyle, start, end);
                    }
                    lastStyle = style;
                    start = offset;
                }
                ++offset;
            }
        }
        return zoomed;
    }

    private Point zoomTextPoint(int x, int y) {
        FontMetrics metric;
        if (this.localCache.font != this.localFont) {
            metric = FigureUtilities.getFontMetrics(this.localFont);
            this.localCache.height = metric.getHeight() - metric.getDescent();
            this.localCache.font = this.localFont;
        }
        if (this.targetCache.font != this.graphics.getFont()) {
            metric = this.graphics.getFontMetrics();
            this.targetCache.font = this.graphics.getFont();
            this.targetCache.height = metric.getHeight() - metric.getDescent();
        }
        return new Point((int)Math.floor((double)x * this.zoom + this.fractionalX), (int)Math.floor((double)(y + this.localCache.height - 1) * this.zoom - (double)this.targetCache.height + 1.0 + this.fractionalY));
    }

    private static class FontHeightCache {
        Font font;
        int height;

        private FontHeightCache() {
        }
    }

    static class FontKey {
        Font font;
        int height;

        protected FontKey() {
        }

        protected FontKey(Font font, int height) {
            this.font = font;
            this.height = height;
        }

        public boolean equals(Object obj) {
            return ((FontKey)obj).font.equals(this.font) && ((FontKey)obj).height == this.height;
        }

        public int hashCode() {
            return this.font.hashCode() ^ this.height;
        }

        protected void setValues(Font font, int height) {
            this.font = font;
            this.height = height;
        }
    }

    protected static class State {
        private double appliedX;
        private double appliedY;
        private Font font;
        private int lineWidth;
        private double zoom;

        protected State() {
        }

        protected State(double zoom, double x, double y, Font font, int lineWidth) {
            this.zoom = zoom;
            this.appliedX = x;
            this.appliedY = y;
            this.font = font;
            this.lineWidth = lineWidth;
        }

        protected void setValues(double zoom, double x, double y, Font font, int lineWidth) {
            this.zoom = zoom;
            this.appliedX = x;
            this.appliedY = y;
            this.font = font;
            this.lineWidth = lineWidth;
        }
    }
}

