/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editparts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.EventListenerList;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class AbstractEditPart
implements EditPart,
RequestConstants,
IAdaptable {
    protected static final int FLAG_ACTIVE = 1;
    protected static final int FLAG_FOCUS = 2;
    protected static final int MAX_FLAG = 2;
    private Object model;
    private int flags;
    private EditPart parent;
    private int selected;
    private List editPolicies = new ArrayList(2);
    private List editPolicyKeys = new ArrayList(2);
    protected List children;
    EventListenerList eventListeners = new EventListenerList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void activate() {
        this.setFlag(1, true);
        this.activateEditPolicies();
        List c = this.getChildren();
        int i = 0;
        while (i < c.size()) {
            ((EditPart)c.get(i)).activate();
            ++i;
        }
        this.fireActivated();
    }

    protected void activateEditPolicies() {
        EditPolicyIterator i = this.getEditPolicyIterator();
        while (i.hasNext()) {
            i.next().activate();
        }
    }

    protected void addChild(EditPart child, int index) {
        Assert.isNotNull(child);
        if (index == -1) {
            index = this.getChildren().size();
        }
        if (this.children == null) {
            this.children = new ArrayList(2);
        }
        this.children.add(index, child);
        child.setParent(this);
        this.addChildVisual(child, index);
        child.addNotify();
        if (this.isActive()) {
            child.activate();
        }
        this.fireChildAdded(child, index);
    }

    protected abstract void addChildVisual(EditPart var1, int var2);

    public void addEditPartListener(EditPartListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.EditPartListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventListeners.addListener(clazz, listener);
    }

    public void addNotify() {
        this.register();
        this.createEditPolicies();
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            ((EditPart)children.get(i)).addNotify();
            ++i;
        }
        this.refresh();
    }

    protected EditPart createChild(Object model) {
        return this.getViewer().getEditPartFactory().createEditPart(this, model);
    }

    protected abstract void createEditPolicies();

    public void deactivate() {
        List c = this.getChildren();
        int i = 0;
        while (i < c.size()) {
            ((EditPart)c.get(i)).deactivate();
            ++i;
        }
        this.deactivateEditPolicies();
        this.setFlag(1, false);
        this.fireDeactivated();
    }

    protected void deactivateEditPolicies() {
        EditPolicyIterator i = this.getEditPolicyIterator();
        while (i.hasNext()) {
            i.next().deactivate();
        }
    }

    protected final void debug(String message) {
    }

    protected final void debugFeedback(String message) {
    }

    public void eraseSourceFeedback(Request request) {
        if (this.isActive()) {
            EditPolicyIterator iter = this.getEditPolicyIterator();
            while (iter.hasNext()) {
                iter.next().eraseSourceFeedback(request);
            }
        }
    }

    public void eraseTargetFeedback(Request request) {
        if (this.isActive()) {
            EditPolicyIterator iter = this.getEditPolicyIterator();
            while (iter.hasNext()) {
                iter.next().eraseTargetFeedback(request);
            }
        }
    }

    protected void fireActivated() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.EditPartListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator listeners = this.getEventListeners(clazz);
        while (listeners.hasNext()) {
            ((EditPartListener)listeners.next()).partActivated(this);
        }
    }

    protected void fireChildAdded(EditPart child, int index) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.EditPartListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator listeners = this.getEventListeners(clazz);
        while (listeners.hasNext()) {
            ((EditPartListener)listeners.next()).childAdded(child, index);
        }
    }

    protected void fireDeactivated() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.EditPartListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator listeners = this.getEventListeners(clazz);
        while (listeners.hasNext()) {
            ((EditPartListener)listeners.next()).partDeactivated(this);
        }
    }

    protected void fireRemovingChild(EditPart child, int index) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.EditPartListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator listeners = this.getEventListeners(clazz);
        while (listeners.hasNext()) {
            ((EditPartListener)listeners.next()).removingChild(child, index);
        }
    }

    protected void fireSelectionChanged() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.EditPartListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator listeners = this.getEventListeners(clazz);
        while (listeners.hasNext()) {
            ((EditPartListener)listeners.next()).selectedStateChanged(this);
        }
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        return null;
    }

    public Object getAdapter(Class key) {
        Class<?> clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2 == key) {
            if (this.getModel() instanceof IPropertySource) {
                return this.getModel();
            }
            if (this.getModel() instanceof IAdaptable) {
                return ((IAdaptable)this.getModel()).getAdapter(key);
            }
        }
        if ((clazz = class$2) == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.gef.AccessibleEditPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == key) {
            return this.getAccessibleEditPart();
        }
        return null;
    }

    public List getChildren() {
        if (this.children == null) {
            return Collections.EMPTY_LIST;
        }
        return this.children;
    }

    public Command getCommand(Request request) {
        Command command = null;
        EditPolicyIterator i = this.getEditPolicyIterator();
        while (i.hasNext()) {
            command = command != null ? command.chain(i.next().getCommand(request)) : i.next().getCommand(request);
        }
        return command;
    }

    private List getEditPolicies() {
        return this.editPolicies;
    }

    private List getEditPolicyKeys() {
        return this.editPolicyKeys;
    }

    protected final Iterator getEventListeners(Class clazz) {
        if (this.eventListeners == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.eventListeners.getListeners(clazz);
    }

    public EditPolicy getEditPolicy(Object key) {
        int index = this.getEditPolicyKeys().indexOf(key);
        if (index == -1) {
            return null;
        }
        return (EditPolicy)this.getEditPolicies().get(index);
    }

    protected final EditPolicyIterator getEditPolicyIterator() {
        return new EditPolicyIterator(this.editPolicies);
    }

    protected final boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public Object getModel() {
        return this.model;
    }

    protected List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public EditPart getParent() {
        return this.parent;
    }

    public RootEditPart getRoot() {
        return this.getParent().getRoot();
    }

    public int getSelected() {
        return this.selected;
    }

    public EditPart getTargetEditPart(Request request) {
        EditPolicyIterator i = this.getEditPolicyIterator();
        while (i.hasNext()) {
            EditPart editPart = i.next().getTargetEditPart(request);
            if (editPart == null) continue;
            return editPart;
        }
        if ("selection" == request.getType() && this.isSelectable()) {
            return this;
        }
        return null;
    }

    public EditPartViewer getViewer() {
        return this.getRoot().getViewer();
    }

    public boolean hasFocus() {
        return this.getFlag(2);
    }

    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        Assert.isNotNull(key, "Edit Policies must be installed with keys");
        int index = this.editPolicyKeys.indexOf(key);
        if (index > -1) {
            EditPolicy old = (EditPolicy)this.editPolicies.get(index);
            if (old != null && this.isActive()) {
                old.deactivate();
            }
            this.editPolicies.set(index, editPolicy);
        } else {
            this.editPolicyKeys.add(key);
            this.editPolicies.add(editPolicy);
        }
        if (editPolicy != null) {
            editPolicy.setHost(this);
            if (this.isActive()) {
                editPolicy.activate();
            }
        }
    }

    public boolean isActive() {
        return this.getFlag(1);
    }

    public boolean isSelectable() {
        return true;
    }

    public void performRequest(Request req) {
    }

    public void refresh() {
        this.refreshVisuals();
        this.refreshChildren();
    }

    protected void refreshChildren() {
        EditPart editPart;
        HashMap<Object, EditPart> modelToEditPart = new HashMap<Object, EditPart>();
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            editPart = (EditPart)children.get(i);
            modelToEditPart.put(editPart.getModel(), editPart);
            ++i;
        }
        List modelObjects = this.getModelChildren();
        i = 0;
        while (i < modelObjects.size()) {
            Object model = modelObjects.get(i);
            if (i >= children.size() || ((EditPart)children.get(i)).getModel() != model) {
                editPart = (EditPart)modelToEditPart.get(model);
                if (editPart != null) {
                    this.reorderChild(editPart, i);
                } else {
                    editPart = this.createChild(model);
                    this.addChild(editPart, i);
                }
            }
            ++i;
        }
        ArrayList trash = new ArrayList();
        while (i < children.size()) {
            trash.add(children.get(i));
            ++i;
        }
        i = 0;
        while (i < trash.size()) {
            EditPart ep = (EditPart)trash.get(i);
            this.removeChild(ep);
            ++i;
        }
    }

    protected void refreshVisuals() {
    }

    protected void register() {
        this.registerModel();
        this.registerVisuals();
        this.registerAccessibility();
    }

    protected final void registerAccessibility() {
        if (this.getAccessibleEditPart() != null) {
            this.getViewer().registerAccessibleEditPart(this.getAccessibleEditPart());
        }
    }

    protected void registerModel() {
        this.getViewer().getEditPartRegistry().put(this.getModel(), this);
    }

    protected void registerVisuals() {
    }

    protected void removeChild(EditPart child) {
        Assert.isNotNull(child);
        int index = this.getChildren().indexOf(child);
        if (index < 0) {
            return;
        }
        this.fireRemovingChild(child, index);
        if (this.isActive()) {
            child.deactivate();
        }
        child.removeNotify();
        this.removeChildVisual(child);
        child.setParent(null);
        this.getChildren().remove(child);
    }

    protected abstract void removeChildVisual(EditPart var1);

    public void removeEditPartListener(EditPartListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.EditPartListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventListeners.removeListener(clazz, listener);
    }

    public void removeEditPolicy(Object key) {
        int i = this.editPolicyKeys.indexOf(key);
        if (i == -1) {
            return;
        }
        EditPolicy policy = (EditPolicy)this.editPolicies.get(i);
        if (this.isActive() && policy != null) {
            policy.deactivate();
        }
        this.editPolicies.set(i, null);
    }

    public void removeNotify() {
        if (this.getSelected() != 0) {
            this.getViewer().deselect(this);
        }
        if (this.hasFocus()) {
            this.getViewer().setFocus(null);
        }
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            ((EditPart)children.get(i)).removeNotify();
            ++i;
        }
        this.unregister();
    }

    protected void reorderChild(EditPart editpart, int index) {
        this.removeChildVisual(editpart);
        List children = this.getChildren();
        children.remove(editpart);
        children.add(index, editpart);
        this.addChildVisual(editpart, index);
    }

    protected final void setFlag(int flag, boolean value) {
        this.flags = value ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public void setFocus(boolean value) {
        if (this.hasFocus() == value) {
            return;
        }
        this.setFlag(2, value);
        this.fireSelectionChanged();
    }

    public void setModel(Object model) {
        if (this.getModel() == model) {
            return;
        }
        this.model = model;
    }

    public void setParent(EditPart parent) {
        if (this.parent == parent) {
            return;
        }
        this.parent = parent;
    }

    public void setSelected(int value) {
        if (this.selected == value) {
            return;
        }
        this.selected = value;
        this.fireSelectionChanged();
    }

    public void showSourceFeedback(Request request) {
        if (!this.isActive()) {
            return;
        }
        EditPolicyIterator i = this.getEditPolicyIterator();
        while (i.hasNext()) {
            i.next().showSourceFeedback(request);
        }
    }

    public void showTargetFeedback(Request request) {
        if (!this.isActive()) {
            return;
        }
        EditPolicyIterator i = this.getEditPolicyIterator();
        while (i.hasNext()) {
            i.next().showTargetFeedback(request);
        }
    }

    public String toString() {
        String c = this.getClass().getName();
        c = c.substring(c.lastIndexOf(46) + 1);
        return String.valueOf(c) + "( " + this.getModel() + " )";
    }

    public boolean understandsRequest(Request req) {
        EditPolicyIterator iter = this.getEditPolicyIterator();
        while (iter.hasNext()) {
            if (!iter.next().understandsRequest(req)) continue;
            return true;
        }
        return false;
    }

    protected void unregister() {
        this.unregisterAccessibility();
        this.unregisterVisuals();
        this.unregisterModel();
    }

    protected final void unregisterAccessibility() {
        if (this.getAccessibleEditPart() != null) {
            this.getViewer().unregisterAccessibleEditPart(this.getAccessibleEditPart());
        }
    }

    protected void unregisterModel() {
        Map registry = this.getViewer().getEditPartRegistry();
        if (registry.get(this.getModel()) == this) {
            registry.remove(this.getModel());
        }
    }

    protected void unregisterVisuals() {
    }

    protected static class EditPolicyIterator {
        private Iterator iter;
        private Object next;

        public EditPolicyIterator(List list) {
            this.iter = list.iterator();
        }

        public EditPolicy next() {
            Object temp = this.next;
            this.next = null;
            return (EditPolicy)temp;
        }

        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.iter.hasNext()) {
                do {
                    this.next = this.iter.next();
                } while (this.next == null && this.iter.hasNext());
            }
            return this.next != null;
        }
    }
}

