/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.handles;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.handles.SquareHandle;

public abstract class ConnectionHandle
extends SquareHandle
implements PropertyChangeListener {
    private boolean fixed = false;

    public ConnectionHandle() {
        this.setCursor(Cursors.CROSS);
    }

    public ConnectionHandle(boolean fixed) {
        this.setFixed(fixed);
        if (fixed) {
            this.setCursor(Cursors.NO);
        } else {
            this.setCursor(Cursors.CROSS);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.getConnection().addPropertyChangeListener("points", this);
    }

    public Connection getConnection() {
        return (Connection)this.getOwnerFigure();
    }

    protected boolean isFixed() {
        return this.fixed;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("points")) {
            this.revalidate();
        }
    }

    public void removeNotify() {
        this.getConnection().removePropertyChangeListener("points", this);
        super.removeNotify();
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
        if (fixed) {
            this.setCursor(Cursors.NO);
        } else {
            this.setCursor(Cursors.CROSS);
        }
    }
}

