/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import java.util.List;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ButtonBorder;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.Toggle;
import org.eclipse.draw2d.ToggleButton;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.internal.ui.palette.editparts.ColumnsLayout;
import org.eclipse.gef.internal.ui.palette.editparts.EditPartTipHelper;
import org.eclipse.gef.internal.ui.palette.editparts.OverlayScrollPaneLayout;
import org.eclipse.gef.internal.ui.palette.editparts.PaletteScrollBar;
import org.eclipse.gef.internal.ui.palette.editparts.PaletteToolbarLayout;
import org.eclipse.gef.internal.ui.palette.editparts.RaisedBorder;
import org.eclipse.gef.ui.palette.PaletteMessages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class DrawerFigure
extends Figure {
    protected static final Border BUTTON_BORDER = new ButtonBorder(ButtonBorder.SCHEMES.TOOLBAR);
    protected static final Color FG_COLOR = FigureUtilities.mixColors(ColorConstants.buttonDarker, ColorConstants.button);
    public static final Image PIN;
    protected static final Border SCROLL_PANE_BORDER;
    protected static final Border TITLE_MARGIN_BORDER;
    protected static final Border TOGGLE_BUTTON_BORDER;
    protected static final Border TOOLTIP_BORDER;
    private Toggle collapseToggle;
    private Label drawerLabel;
    private Label tipLabel;
    private boolean addedScrollpane = false;
    private int layoutMode = -1;
    private ToggleButton pinFigure;
    private ScrollPane scrollpane;
    private boolean showPin = true;
    private boolean skipNextEvent;
    private EditPartTipHelper tipHelper;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.internal.Internal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PIN = new Image(null, ImageDescriptor.createFromFile(clazz, "icons/pin_view.gif").getImageData());
        SCROLL_PANE_BORDER = new MarginBorder(2);
        TITLE_MARGIN_BORDER = new MarginBorder(1, 1, 1, 0);
        TOGGLE_BUTTON_BORDER = new RaisedBorder();
        TOOLTIP_BORDER = new CompoundBorder(new SchemeBorder(SchemeBorder.SCHEMES.RAISED), new MarginBorder(1));
    }

    public DrawerFigure(Control control2) {
        this.setLayoutManager(new PaletteToolbarLayout(null){

            protected boolean isChildGrowing(IFigure child) {
                int wHint = child.getBounds().width;
                return child.getPreferredSize((int)wHint, (int)-1).height != child.getMinimumSize((int)wHint, (int)-1).height;
            }
        });
        Figure title = new Figure();
        title.setBorder(TITLE_MARGIN_BORDER);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHorizontalSpacing(2);
        title.setLayoutManager(borderLayout);
        this.drawerLabel = new Label();
        this.drawerLabel.setLabelAlignment(1);
        this.pinFigure = new ToggleButton(new ImageFigure(PIN));
        this.pinFigure.setBorder(BUTTON_BORDER);
        this.pinFigure.setRolloverEnabled(true);
        this.pinFigure.setRequestFocusEnabled(false);
        this.pinFigure.setToolTip(new Label(PaletteMessages.TOOLTIP_PIN_FIGURE));
        title.add((IFigure)this.pinFigure, BorderLayout.RIGHT);
        title.add((IFigure)this.drawerLabel, BorderLayout.CENTER);
        this.collapseToggle = new Toggle(title){

            public IFigure getToolTip() {
                return DrawerFigure.this.buildTooltip();
            }

            protected void paintFigure(Graphics g) {
                super.paintFigure(g);
                Rectangle r = Rectangle.SINGLETON;
                r.setBounds(this.getBounds());
                r.width = Math.min(50, r.width);
                g.setForegroundColor(FG_COLOR);
                g.fillGradient(Rectangle.SINGLETON, false);
            }
        };
        this.collapseToggle.setSelected(true);
        this.collapseToggle.setBorder(TOGGLE_BUTTON_BORDER);
        this.collapseToggle.setRequestFocusEnabled(true);
        this.collapseToggle.addChangeListener(new ChangeListener(){

            public void handleStateChanged(ChangeEvent e) {
                if (e.getPropertyName().equals("selected")) {
                    DrawerFigure.this.handleExpandStateChanged();
                }
            }
        });
        this.add(this.collapseToggle);
        this.createScrollpane();
        this.createHoverHelp(control2);
    }

    private void createHoverHelp(final Control control2) {
        if (control2 == null) {
            return;
        }
        this.tipLabel = new Label(){

            public IFigure getToolTip() {
                return DrawerFigure.this.buildTooltip();
            }

            protected void paintFigure(Graphics graphics) {
                Rectangle r = Rectangle.SINGLETON;
                r.setBounds(this.getBounds());
                r.width = Math.min(50, r.width);
                graphics.pushState();
                graphics.setForegroundColor(FG_COLOR);
                graphics.fillGradient(Rectangle.SINGLETON, false);
                graphics.popState();
                super.paintFigure(graphics);
            }
        };
        this.tipLabel.setOpaque(false);
        this.tipLabel.setBorder(TOOLTIP_BORDER);
        this.collapseToggle.addMouseMotionListener(new MouseMotionListener.Stub(){

            public void mouseMoved(MouseEvent e) {
                if (!DrawerFigure.this.drawerLabel.getBounds().contains(e.getLocation())) {
                    return;
                }
                if (DrawerFigure.this.skipNextEvent) {
                    DrawerFigure.this.skipNextEvent = false;
                    return;
                }
                if (DrawerFigure.this.drawerLabel.isTextTruncated() && !EditPartTipHelper.isCurrent(DrawerFigure.this.tipHelper)) {
                    DrawerFigure.this.tipLabel.setText(DrawerFigure.this.drawerLabel.getText());
                    DrawerFigure.this.tipLabel.setIcon(DrawerFigure.this.drawerLabel.getIcon());
                    DrawerFigure.this.tipLabel.setFont(DrawerFigure.this.drawerLabel.getFont());
                    DrawerFigure.this.tipHelper = new EditPartTipHelper(control2);
                    Rectangle bounds = DrawerFigure.this.drawerLabel.getBounds().getExpanded(2, 2);
                    DrawerFigure.this.drawerLabel.translateToAbsolute(bounds);
                    org.eclipse.swt.graphics.Rectangle loc = new org.eclipse.swt.graphics.Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                    loc = Display.getCurrent().map(control2, null, loc);
                    DrawerFigure.this.tipHelper.displayToolTipAt(DrawerFigure.this.tipLabel, loc.x, loc.y);
                }
            }
        });
        this.tipLabel.addMouseListener(new MouseListener.Stub(){

            public void mousePressed(MouseEvent e) {
                if (e.button == 1) {
                    Rectangle original = DrawerFigure.this.getCollapseToggle().getBounds().getCopy();
                    DrawerFigure.this.getCollapseToggle().requestFocus();
                    DrawerFigure.this.setExpanded(!DrawerFigure.this.isExpanded());
                    if (!original.equals(DrawerFigure.this.getCollapseToggle().getBounds())) {
                        DrawerFigure.this.tipHelper.hide();
                    }
                } else {
                    DrawerFigure.this.tipHelper.hide();
                    if (e.button == 3) {
                        DrawerFigure.this.skipNextEvent = true;
                    }
                }
            }
        });
    }

    private void createScrollpane() {
        this.scrollpane = new ScrollPane();
        this.scrollpane.getViewport().setContentsTracksWidth(true);
        this.scrollpane.setMinimumSize(new Dimension(0, 0));
        this.scrollpane.setHorizontalScrollBarVisibility(0);
        this.scrollpane.setVerticalScrollBar(new PaletteScrollBar());
        this.scrollpane.getVerticalScrollBar().setStepIncrement(20);
        this.scrollpane.setLayoutManager(new OverlayScrollPaneLayout());
        this.scrollpane.setContents(new Figure());
        this.scrollpane.getContents().setOpaque(true);
        this.scrollpane.getContents().setBorder(SCROLL_PANE_BORDER);
    }

    IFigure buildTooltip() {
        return null;
    }

    public Clickable getCollapseToggle() {
        return this.collapseToggle;
    }

    public IFigure getContentPane() {
        return this.scrollpane.getContents();
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        List children;
        if (this.isExpanded() && !(children = this.getContentPane().getChildren()).isEmpty()) {
            Dimension result = this.collapseToggle.getPreferredSize(wHint, hHint).getCopy();
            result.height += this.getContentPane().getInsets().getHeight();
            IFigure child = (IFigure)children.get(0);
            result.height += Math.min(80, child.getPreferredSize((int)wHint, (int)-1).height + 9);
            return result.intersect(this.getPreferredSize(wHint, hHint));
        }
        return super.getMinimumSize(wHint, hHint);
    }

    public ScrollPane getScrollpane() {
        return this.scrollpane;
    }

    protected void handleExpandStateChanged() {
        if (this.isExpanded()) {
            if (this.scrollpane.getParent() != this) {
                this.add(this.scrollpane);
            }
        } else if (this.scrollpane.getParent() == this) {
            this.remove(this.scrollpane);
        }
        if (this.pinFigure == null) {
            return;
        }
        if (this.isExpanded() && this.showPin) {
            this.pinFigure.setVisible(true);
        } else {
            this.pinFigure.setVisible(false);
        }
    }

    public boolean isExpanded() {
        return this.collapseToggle.isSelected();
    }

    public boolean isPinnedOpen() {
        return this.isExpanded() && this.pinFigure.isVisible() && this.pinFigure.isSelected();
    }

    public boolean isPinShowing() {
        return this.isExpanded() && this.showPin;
    }

    public void setAnimating(boolean isAnimating) {
        if (isAnimating) {
            if (this.scrollpane.getParent() != this) {
                this.addedScrollpane = true;
                this.add(this.scrollpane);
            }
            this.scrollpane.setVerticalScrollBarVisibility(0);
        } else {
            this.scrollpane.setVerticalScrollBarVisibility(1);
            if (this.addedScrollpane) {
                this.remove(this.scrollpane);
                this.addedScrollpane = false;
            }
        }
    }

    public void setExpanded(boolean value) {
        this.collapseToggle.setSelected(value);
        this.handleExpandStateChanged();
    }

    public void setLayoutMode(int layoutMode) {
        AbstractHintLayout manager;
        if (this.layoutMode == layoutMode) {
            return;
        }
        this.layoutMode = layoutMode;
        if (layoutMode == 1) {
            manager = new ColumnsLayout();
        } else if (layoutMode == 2) {
            FlowLayout fl = new FlowLayout();
            fl.setMinorSpacing(0);
            fl.setMajorSpacing(0);
            manager = fl;
        } else {
            manager = new ToolbarLayout();
        }
        this.getContentPane().setLayoutManager(manager);
    }

    public void setPinned(boolean pinned) {
        if (!this.isExpanded() || !this.showPin) {
            return;
        }
        this.pinFigure.setSelected(pinned);
    }

    public void setTitle(String s) {
        this.drawerLabel.setText(s);
    }

    public void setTitleIcon(Image icon) {
        this.drawerLabel.setIcon(icon);
    }

    public void showPin(boolean show) {
        this.showPin = show;
        this.handleExpandStateChanged();
    }
}

