/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.internal.cocoa.Cocoa;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class Safari
extends WebBrowser {
    int delegate;
    int webViewHandle;
    int webView;
    int windowBoundsHandler;
    boolean changingLocation;
    boolean hasNewFocusElement;
    String lastHoveredLinkURL;
    String html;
    int identifier;
    int resourceCount;
    int lastMouseMoveX;
    int lastMouseMoveY;
    String url = "";
    org.eclipse.swt.graphics.Point location;
    org.eclipse.swt.graphics.Point size;
    boolean statusBar = true;
    boolean toolBar = true;
    boolean ignoreDispose;
    static boolean Initialized;
    static Callback Callback3;
    static Callback Callback7;
    static final int MIN_SIZE = 16;
    static final int MAX_PROGRESS = 100;
    static final String WebElementLinkURLKey = "WebElementLinkURL";
    static final String AGENT_STRING = "Safari/412.0";
    static final String URI_FROMMEMORY = "file:///";
    static final String PROTOCOL_FILE = "file://";
    static final String PROTOCOL_HTTP = "http://";
    static final String URI_APPLEWEBDATA = "applewebdata://";
    static final String ABOUT_BLANK = "about:blank";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static final String BROWSER_WINDOW = "org.eclipse.swt.browser.Browser.Window";
    static final String SAFARI_EVENTS_FIX_KEY = "org.eclipse.swt.internal.safariEventsFix";
    static final String DOMEVENT_KEYUP = "keyup";
    static final String DOMEVENT_KEYDOWN = "keydown";
    static final String DOMEVENT_MOUSEDOWN = "mousedown";
    static final String DOMEVENT_MOUSEUP = "mouseup";
    static final String DOMEVENT_MOUSEMOVE = "mousemove";
    static final String DOMEVENT_MOUSEWHEEL = "mousewheel";
    static final String DOMEVENT_FOCUSIN = "DOMFocusIn";
    static final String DOMEVENT_FOCUSOUT = "DOMFocusOut";

    static {
        NativeClearSessions = new Runnable(){

            public void run() {
                int n = Cocoa.objc_msgSend(Cocoa.C_NSHTTPCookieStorage, Cocoa.S_sharedHTTPCookieStorage);
                int n2 = Cocoa.objc_msgSend(n, Cocoa.S_cookies);
                int n3 = Cocoa.objc_msgSend(n2, Cocoa.S_count);
                int n4 = 0;
                while (n4 < n3) {
                    boolean bl;
                    int n5 = Cocoa.objc_msgSend(n2, Cocoa.S_objectAtIndex, n4);
                    boolean bl2 = bl = Cocoa.objc_msgSend(n5, Cocoa.S_isSessionOnly) != 0;
                    if (bl) {
                        Cocoa.objc_msgSend(n, Cocoa.S_deleteCookie, n5);
                    }
                    ++n4;
                }
            }
        };
    }

    Safari() {
    }

    public void create(Composite composite, int n) {
        int n2;
        int n3;
        int[] nArray;
        if (OS.VERSION < 4144) {
            this.browser.dispose();
            SWT.error(2);
        }
        int[] nArray2 = new int[1];
        if (OS.VERSION >= 4176) {
            this.webView = Cocoa.objc_msgSend(Cocoa.objc_msgSend(Cocoa.C_WebView, Cocoa.S_alloc), Cocoa.S_initWithFrame_frameName_groupName, new NSRect(), 0, 0);
            if (this.webView != 0) {
                Cocoa.HICocoaViewCreate(this.webView, 0, nArray2);
                this.webViewHandle = nArray2[0];
                Cocoa.objc_msgSend(this.webView, Cocoa.S_release);
            }
        } else {
            Cocoa.HIWebViewCreate(nArray2);
            this.webViewHandle = nArray2[0];
            if (this.webViewHandle != 0) {
                this.webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
            }
        }
        if (this.webViewHandle == 0) {
            this.browser.dispose();
            SWT.error(2);
        }
        Display display = this.browser.getDisplay();
        display.setData(ADD_WIDGET_KEY, new Object[]{new Integer(this.webViewHandle), this.browser});
        if (OS.VERSION >= 4160) {
            this.browser.setData(SAFARI_EVENTS_FIX_KEY);
        }
        if (display.getData(BROWSER_WINDOW) == null) {
            Rect rect = new Rect();
            OS.SetRect(rect, (short)0, (short)0, (short)1, (short)1);
            nArray = new int[1];
            OS.CreateNewWindow(14, 0, rect, nArray);
            OS.ShowWindow(nArray[0]);
            OS.HIObjectSetAccessibilityIgnored(nArray[0], true);
            display.disposeExec(new Runnable(){

                public void run() {
                    if (nArray[0] != 0) {
                        OS.DisposeWindow(nArray[0]);
                    }
                    nArray[0] = 0;
                }
            });
            display.setData(BROWSER_WINDOW, nArray);
        }
        int n4 = OS.GetControlOwner(this.browser.handle);
        nArray = new int[1];
        OS.HIViewFindByID(OS.HIViewGetRoot(n4), OS.kHIViewWindowContentID(), nArray);
        OS.HIViewAddSubview(nArray[0], this.webViewHandle);
        OS.HIViewChangeFeatures(this.webViewHandle, 0x2000000, 0);
        OS.HIViewSetVisible(this.webViewHandle, true);
        if (this.browser.getShell().isVisible()) {
            int[] nArray3 = new int[1];
            OS.CreateEvent(0, 2003398244, 24, 0.0, 1, nArray3);
            OS.SetEventParameter(nArray3[0], 0x2D2D2D2D, 2003398244, 4, new int[]{OS.GetControlOwner(this.browser.handle)});
            OS.SendEventToEventTarget(nArray3[0], OS.GetWindowEventTarget(n4));
            if (nArray3[0] != 0) {
                OS.ReleaseEvent(nArray3[0]);
            }
        }
        final int n5 = Cocoa.objc_msgSend(Cocoa.C_NSNotificationCenter, Cocoa.S_defaultCenter);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        if (Safari.this.ignoreDispose) {
                            Safari.this.ignoreDispose = false;
                            break;
                        }
                        Safari.this.ignoreDispose = true;
                        Safari.this.browser.notifyListeners(event.type, event);
                        event.type = 0;
                        OS.RemoveEventHandler(Safari.this.windowBoundsHandler);
                        Safari.this.windowBoundsHandler = 0;
                        Object[] objectArray = new Object[2];
                        objectArray[0] = new Integer(Safari.this.webViewHandle);
                        event.display.setData(Safari.ADD_WIDGET_KEY, objectArray);
                        Cocoa.objc_msgSend(Safari.this.webView, Cocoa.S_setFrameLoadDelegate, 0);
                        Cocoa.objc_msgSend(Safari.this.webView, Cocoa.S_setResourceLoadDelegate, 0);
                        Cocoa.objc_msgSend(Safari.this.webView, Cocoa.S_setUIDelegate, 0);
                        Cocoa.objc_msgSend(Safari.this.webView, Cocoa.S_setPolicyDelegate, 0);
                        Cocoa.objc_msgSend(Safari.this.webView, Cocoa.S_setDownloadDelegate, 0);
                        Cocoa.objc_msgSend(n5, Cocoa.S_removeObserver, Safari.this.delegate);
                        Cocoa.objc_msgSend(Safari.this.delegate, Cocoa.S_release);
                        OS.DisposeControl(Safari.this.webViewHandle);
                        Safari.this.webViewHandle = 0;
                        Safari.this.webView = 0;
                        Safari.this.html = null;
                        Safari.this.lastHoveredLinkURL = null;
                        break;
                    }
                    case 15: {
                        Safari.this.hasNewFocusElement = true;
                        OS.SetKeyboardFocus(OS.GetControlOwner(Safari.this.browser.handle), Safari.this.webViewHandle, (short)-1);
                    }
                }
            }
        };
        this.browser.addListener(12, listener);
        this.browser.addListener(15, listener);
        this.browser.addListener(1, listener);
        if (Callback3 == null) {
            Callback3 = new Callback(this.getClass(), "eventProc3", 3);
        }
        if ((n3 = Callback3.getAddress()) == 0) {
            SWT.error(3);
        }
        int[] nArray4 = new int[]{1801812322, 1, 1668183148, 4, 1668183148, 17, 1668183148, 11, 1952807028, 2};
        OS.InstallEventHandler(OS.GetControlEventTarget(this.webViewHandle), n3, nArray4.length / 2, nArray4, this.webViewHandle, null);
        int[] nArray5 = new int[]{1668183148, 154, 1668183148, 157, 1668183148, 159};
        OS.InstallEventHandler(OS.GetControlEventTarget(this.browser.handle), n3, nArray5.length / 2, nArray5, this.browser.handle, null);
        int[] nArray6 = new int[]{2003398244, 27};
        int[] nArray7 = new int[1];
        OS.InstallEventHandler(OS.GetWindowEventTarget(n4), n3, nArray6.length / 2, nArray6, this.browser.handle, nArray7);
        this.windowBoundsHandler = nArray7[0];
        if (Callback7 == null) {
            Callback7 = new Callback(this.getClass(), "eventProc7", 7);
        }
        if ((n2 = Callback7.getAddress()) == 0) {
            SWT.error(3);
        }
        this.delegate = Cocoa.objc_msgSend(Cocoa.C_WebKitDelegate, Cocoa.S_alloc);
        this.delegate = Cocoa.objc_msgSend(this.delegate, Cocoa.S_initWithProc, n2, this.webViewHandle);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setFrameLoadDelegate, this.delegate);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setResourceLoadDelegate, this.delegate);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setUIDelegate, this.delegate);
        Cocoa.objc_msgSend(n5, Cocoa.S_addObserver_selector_name_object, this.delegate, Cocoa.S_handleNotification, 0, this.webView);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setPolicyDelegate, this.delegate);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setDownloadDelegate, this.delegate);
        int n6 = AGENT_STRING.length();
        char[] cArray = new char[n6];
        AGENT_STRING.getChars(0, n6, cArray, 0);
        int n7 = OS.CFStringCreateWithCharacters(0, cArray, n6);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setApplicationNameForUserAgent, n7);
        OS.CFRelease(n7);
        if (OS.VERSION < 4176 && display.getActiveShell() == this.browser.getShell()) {
            Cocoa.objc_msgSend(Cocoa.objc_msgSend(this.webView, Cocoa.S_window), Cocoa.S_makeKeyWindow);
        }
        if (!Initialized) {
            Initialized = true;
            int n8 = Cocoa.objc_msgSend(Cocoa.C_WebPreferences, Cocoa.S_standardPreferences);
            Cocoa.objc_msgSend(n8, Cocoa.S_setJavaEnabled, 0);
        }
    }

    static int eventProc3(int n, int n2, int n3) {
        Widget widget = Display.getCurrent().findWidget(n3);
        if (widget instanceof Browser) {
            return ((Safari)((Browser)widget).webBrowser).handleCallback(n, n2);
        }
        return -9874;
    }

    static int eventProc7(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Widget widget = Display.getCurrent().findWidget(n2);
        if (widget instanceof Browser) {
            return ((Safari)((Browser)widget).webBrowser).handleCallback(n3, n4, n5, n6, n7);
        }
        return 0;
    }

    public boolean back() {
        this.html = null;
        return Cocoa.objc_msgSend(this.webView, Cocoa.S_goBack) != 0;
    }

    public boolean execute(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = OS.CFStringCreateWithCharacters(0, cArray, n);
        int n3 = Cocoa.objc_msgSend(this.webView, Cocoa.S_stringByEvaluatingJavaScriptFromString, n2);
        OS.CFRelease(n2);
        return n3 != 0;
    }

    public boolean forward() {
        this.html = null;
        return Cocoa.objc_msgSend(this.webView, Cocoa.S_goForward) != 0;
    }

    public String getText() {
        int n = Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
        int n2 = Cocoa.objc_msgSend(n, Cocoa.S_dataSource);
        if (n2 == 0) {
            return "";
        }
        int n3 = Cocoa.objc_msgSend(n2, Cocoa.S_representation);
        if (n3 == 0) {
            return "";
        }
        int n4 = Cocoa.objc_msgSend(n3, Cocoa.S_documentSource);
        if (n4 == 0) {
            return "";
        }
        int n5 = OS.CFStringGetLength(n4);
        char[] cArray = new char[n5];
        CFRange cFRange = new CFRange();
        cFRange.length = n5;
        OS.CFStringGetCharacters(n4, cFRange, cArray);
        return new String(cArray);
    }

    public String getUrl() {
        return this.url;
    }

    int handleCallback(int n, int n2) {
        int n3 = OS.GetEventKind(n2);
        switch (OS.GetEventClass(n2)) {
            case 1668183148: {
                Object[] objectArray;
                int[] nArray;
                Object object;
                switch (n3) {
                    case 17: {
                        OS.SetEventParameter(n2, 1668047203, 1668047203, 4, new int[]{3});
                        return 0;
                    }
                    case 11: {
                        return 0;
                    }
                    case 4: {
                        if (this.browser.isVisible()) break;
                        return 0;
                    }
                    case 159: {
                        int n4 = OS.GetControlOwner(this.browser.handle);
                        object = new int[1];
                        OS.HIViewFindByID(OS.HIViewGetRoot(n4), OS.kHIViewWindowContentID(), object);
                        OS.HIViewAddSubview(object[0], this.webViewHandle);
                        OS.RemoveEventHandler(this.windowBoundsHandler);
                        nArray = new int[]{2003398244, 27};
                        objectArray = new int[1];
                        OS.InstallEventHandler(OS.GetWindowEventTarget(n4), Callback3.getAddress(), nArray.length / 2, nArray, this.browser.handle, objectArray);
                        this.windowBoundsHandler = objectArray[0];
                        break;
                    }
                    case 154: 
                    case 157: {
                        CGRect cGRect = new CGRect();
                        if (!this.browser.isVisible()) {
                            cGRect.y = -16.0f;
                            cGRect.x = -16.0f;
                            cGRect.height = 16.0f;
                            cGRect.width = 16.0f;
                            OS.HIViewSetFrame(this.webViewHandle, cGRect);
                            break;
                        }
                        OS.HIViewGetBounds(this.browser.handle, cGRect);
                        object = new int[1];
                        OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.browser.handle)), OS.kHIViewWindowContentID(), object);
                        OS.HIViewConvertRect(cGRect, this.browser.handle, object[0]);
                        if (cGRect.width <= 16.0f) {
                            cGRect.width = 16.0f;
                        }
                        if (cGRect.height <= 16.0f) {
                            cGRect.height = 16.0f;
                        }
                        OS.HIViewSetFrame(this.webViewHandle, cGRect);
                    }
                }
            }
            case 2003398244: {
                int[] nArray;
                Object object;
                switch (n3) {
                    case 27: {
                        if (!this.browser.isVisible()) break;
                        CGRect cGRect = new CGRect();
                        OS.GetEventParameter(n2, 1869767540, 1751741027, null, 16, null, cGRect);
                        object = new CGRect();
                        OS.GetEventParameter(n2, 1668440948, 1751741027, null, 16, null, (CGRect)object);
                        if (cGRect.height == object.height) break;
                        OS.HIViewGetBounds(this.browser.handle, (CGRect)object);
                        nArray = new int[1];
                        OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.browser.handle)), OS.kHIViewWindowContentID(), nArray);
                        OS.HIViewConvertRect((CGRect)object, this.browser.handle, nArray[0]);
                        if (object.width <= 16.0f) {
                            object.width = 16.0f;
                        }
                        if (object.height <= 16.0f) {
                            object.height = 16.0f;
                        }
                        object.x += 1.0f;
                        OS.HIViewSetFrame(this.webViewHandle, (CGRect)object);
                        object.x -= 1.0f;
                        OS.HIViewSetFrame(this.webViewHandle, (CGRect)object);
                    }
                }
            }
            case 1801812322: {
                Object[] objectArray;
                int[] nArray;
                switch (n3) {
                    case 1: {
                        int[] nArray2 = new int[1];
                        int n5 = OS.GetEventParameter(n2, 1802858089, 1970567284, null, 4, nArray2, null);
                        if (n5 == 0 && nArray2[0] != 0) {
                            nArray = new int[1];
                            OS.GetEventParameter(n2, 1802334052, 1835100014, null, 4, null, nArray);
                            objectArray = new char[1];
                            OS.GetEventParameter(n2, 1802858089, 1970567284, null, 2, null, objectArray);
                            if ((nArray[0] & 0x100) != 0) {
                                switch (objectArray[0]) {
                                    case 'v': {
                                        Cocoa.objc_msgSend(this.webView, Cocoa.S_paste);
                                        return 0;
                                    }
                                    case 'c': {
                                        Cocoa.objc_msgSend(this.webView, Cocoa.S_copy);
                                        return 0;
                                    }
                                    case 'x': {
                                        Cocoa.objc_msgSend(this.webView, Cocoa.S_cut);
                                        return 0;
                                    }
                                }
                            }
                        }
                        int n6 = this.webViewHandle;
                        int n7 = OS.HIViewGetSuperview(this.webViewHandle);
                        OS.CFRetain(n6);
                        OS.CFRetain(n7);
                        int n8 = OS.CallNextEventHandler(n, n2);
                        OS.CFRelease(n6);
                        OS.CFRelease(n7);
                        return n8;
                    }
                }
            }
            case 1952807028: {
                switch (n3) {
                    default: 
                }
            }
        }
        return -9874;
    }

    int handleCallback(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        switch (n) {
            case 1: {
                this.didFailProvisionalLoadWithError(n2, n3);
                break;
            }
            case 2: {
                this.didFinishLoadForFrame(n2);
                break;
            }
            case 3: {
                this.didReceiveTitle(n2, n3);
                break;
            }
            case 4: {
                this.didStartProvisionalLoadForFrame(n2);
                break;
            }
            case 5: {
                this.didFinishLoadingFromDataSource(n2, n3);
                break;
            }
            case 6: {
                this.didFailLoadingWithError(n2, n3, n4);
                break;
            }
            case 7: {
                n6 = this.identifierForInitialRequest(n2, n3);
                break;
            }
            case 8: {
                n6 = this.willSendRequest(n2, n3, n4, n5);
                break;
            }
            case 9: {
                this.handleNotification(n2);
                break;
            }
            case 10: {
                this.didCommitLoadForFrame(n2);
                break;
            }
            case 11: {
                n6 = this.createWebViewWithRequest(n2);
                break;
            }
            case 12: {
                this.webViewShow(n2);
                break;
            }
            case 13: {
                this.setFrame(n2);
                break;
            }
            case 14: {
                this.webViewClose();
                break;
            }
            case 15: {
                n6 = this.contextMenuItemsForElement(n2, n3);
                break;
            }
            case 16: {
                this.setStatusBarVisible(n2);
                break;
            }
            case 17: {
                this.setResizable(n2);
                break;
            }
            case 18: {
                this.setToolbarsVisible(n2);
                break;
            }
            case 19: {
                this.decidePolicyForMIMEType(n2, n3, n4, n5);
                break;
            }
            case 20: {
                this.decidePolicyForNavigationAction(n2, n3, n4, n5);
                break;
            }
            case 21: {
                this.decidePolicyForNewWindowAction(n2, n3, n4, n5);
                break;
            }
            case 22: {
                this.unableToImplementPolicyWithError(n2, n3);
                break;
            }
            case 23: {
                this.setStatusText(n2);
                break;
            }
            case 24: {
                this.webViewFocus();
                break;
            }
            case 25: {
                this.webViewUnfocus();
                break;
            }
            case 26: {
                this.runJavaScriptAlertPanelWithMessage(n2);
                break;
            }
            case 27: {
                n6 = this.runJavaScriptConfirmPanelWithMessage(n2);
                break;
            }
            case 28: {
                this.runOpenPanelForFileButtonWithResultListener(n2);
                break;
            }
            case 29: {
                this.decideDestinationWithSuggestedFilename(n2, n3);
                break;
            }
            case 30: {
                this.mouseDidMoveOverElement(n2, n3);
                break;
            }
            case 31: {
                this.didChangeLocationWithinPageForFrame(n2);
                break;
            }
            case 32: {
                this.handleEvent(n2);
            }
        }
        return n6;
    }

    public boolean isBackEnabled() {
        return Cocoa.objc_msgSend(this.webView, Cocoa.S_canGoBack) != 0;
    }

    public boolean isForwardEnabled() {
        return Cocoa.objc_msgSend(this.webView, Cocoa.S_canGoForward) != 0;
    }

    public void refresh() {
        Cocoa.objc_msgSend(this.webView, Cocoa.S_reload, 0);
    }

    public boolean setText(String string) {
        if (this.changingLocation) {
            this.html = string;
        } else {
            this._setText(string);
        }
        return true;
    }

    void _setText(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = OS.CFStringCreateWithCharacters(0, cArray, n);
        n = URI_FROMMEMORY.length();
        cArray = new char[n];
        URI_FROMMEMORY.getChars(0, n, cArray, 0);
        int n3 = OS.CFStringCreateWithCharacters(0, cArray, n);
        int n4 = Cocoa.objc_msgSend(Cocoa.C_NSURL, Cocoa.S_URLWithString, n3);
        OS.CFRelease(n3);
        int n5 = Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
        Cocoa.objc_msgSend(n5, Cocoa.S_loadHTMLStringbaseURL, n2, n4);
        OS.CFRelease(n2);
    }

    public boolean setUrl(String string) {
        int n;
        this.html = null;
        if (string.indexOf(47) == 0) {
            string = PROTOCOL_FILE + string;
        } else if (string.indexOf(58) == -1) {
            string = PROTOCOL_HTTP + string;
        }
        int n2 = 0;
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n3 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        if (n3 != 0) {
            char[] cArray2 = new char[]{'%', '#'};
            n = OS.CFStringCreateWithCharacters(0, cArray2, cArray2.length);
            int n4 = OS.CFURLCreateStringByAddingPercentEscapes(0, n3, n, 0, 0x8000100);
            if (n4 != 0) {
                n2 = OS.CFURLCreateWithString(0, n4, 0);
                OS.CFRelease(n4);
            }
            if (n != 0) {
                OS.CFRelease(n);
            }
            OS.CFRelease(n3);
        }
        if (n2 == 0) {
            return false;
        }
        int n5 = Cocoa.objc_msgSend(Cocoa.C_NSURLRequest, Cocoa.S_requestWithURL, n2);
        OS.CFRelease(n2);
        n = Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
        Cocoa.objc_msgSend(n, Cocoa.S_loadRequest, n5);
        return true;
    }

    public void stop() {
        this.html = null;
        Cocoa.objc_msgSend(this.webView, Cocoa.S_stopLoading, 0);
    }

    void didChangeLocationWithinPageForFrame(int n) {
        int n2;
        TypedEvent typedEvent;
        boolean bl;
        int n3 = Cocoa.objc_msgSend(n, Cocoa.S_dataSource);
        int n4 = Cocoa.objc_msgSend(n3, Cocoa.S_request);
        int n5 = Cocoa.objc_msgSend(n4, Cocoa.S_URL);
        int n6 = Cocoa.objc_msgSend(n5, Cocoa.S_absoluteString);
        int n7 = OS.CFStringGetLength(n6);
        if (n7 == 0) {
            return;
        }
        char[] cArray = new char[n7];
        CFRange cFRange = new CFRange();
        cFRange.length = n7;
        OS.CFStringGetCharacters(n6, cFRange, cArray);
        String string = new String(cArray);
        if (string.equals(URI_FROMMEMORY)) {
            string = ABOUT_BLANK;
        }
        Display display = this.browser.getDisplay();
        boolean bl2 = bl = n == Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
        if (bl) {
            typedEvent = new StatusTextEvent(this.browser);
            typedEvent.display = display;
            typedEvent.widget = this.browser;
            typedEvent.text = string;
            n2 = 0;
            while (n2 < this.statusTextListeners.length) {
                this.statusTextListeners[n2].changed((StatusTextEvent)typedEvent);
                ++n2;
            }
        }
        typedEvent = new LocationEvent(this.browser);
        ((LocationEvent)typedEvent).display = display;
        ((LocationEvent)typedEvent).widget = this.browser;
        ((LocationEvent)typedEvent).location = string;
        ((LocationEvent)typedEvent).top = bl;
        n2 = 0;
        while (n2 < this.locationListeners.length) {
            this.locationListeners[n2].changed((LocationEvent)typedEvent);
            ++n2;
        }
    }

    void didFailProvisionalLoadWithError(int n, int n2) {
        if (n2 == Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame)) {
            this.identifier = 0;
        }
    }

    void didFinishLoadForFrame(int n) {
        this.hookDOMFocusListeners(n);
        this.hookDOMMouseListeners(n);
        if (n == Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame)) {
            int n2;
            this.hookDOMKeyListeners(n);
            final Display display = this.browser.getDisplay();
            int n3 = Cocoa.objc_msgSend(n, Cocoa.S_dataSource);
            if (n3 != 0 && (n2 = Cocoa.objc_msgSend(n3, Cocoa.S_pageTitle)) == 0) {
                final TitleEvent titleEvent = new TitleEvent(this.browser);
                titleEvent.display = display;
                titleEvent.widget = this.browser;
                titleEvent.title = this.url;
                int n4 = 0;
                while (n4 < this.titleListeners.length) {
                    final TitleListener titleListener = this.titleListeners[n4];
                    display.asyncExec(new Runnable(){

                        public void run() {
                            if (!display.isDisposed() && !Safari.this.browser.isDisposed()) {
                                titleListener.changed(titleEvent);
                            }
                        }
                    });
                    ++n4;
                }
            }
            final ProgressEvent progressEvent = new ProgressEvent(this.browser);
            progressEvent.display = display;
            progressEvent.widget = this.browser;
            progressEvent.current = 100;
            progressEvent.total = 100;
            int n5 = 0;
            while (n5 < this.progressListeners.length) {
                final ProgressListener progressListener = this.progressListeners[n5];
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (!display.isDisposed() && !Safari.this.browser.isDisposed()) {
                            progressListener.completed(progressEvent);
                        }
                    }
                });
                ++n5;
            }
            this.identifier = 0;
        }
    }

    void hookDOMFocusListeners(int n) {
        if (4160 > OS.VERSION || OS.VERSION >= 4176) {
            return;
        }
        int n2 = Cocoa.objc_msgSend(n, Cocoa.S_DOMDocument);
        String string = DOMEVENT_FOCUSIN;
        int n3 = string.length();
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        int n4 = OS.CFStringCreateWithCharacters(0, cArray, n3);
        Cocoa.objc_msgSend(n2, Cocoa.S_addEventListener, n4, this.delegate, 0);
        OS.CFRelease(n4);
        string = DOMEVENT_FOCUSOUT;
        n3 = string.length();
        cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        n4 = OS.CFStringCreateWithCharacters(0, cArray, n3);
        Cocoa.objc_msgSend(n2, Cocoa.S_addEventListener, n4, this.delegate, 0);
        OS.CFRelease(n4);
    }

    void hookDOMKeyListeners(int n) {
        if (OS.VERSION < 4160) {
            return;
        }
        int n2 = Cocoa.objc_msgSend(n, Cocoa.S_DOMDocument);
        String string = DOMEVENT_KEYDOWN;
        int n3 = string.length();
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        int n4 = OS.CFStringCreateWithCharacters(0, cArray, n3);
        Cocoa.objc_msgSend(n2, Cocoa.S_addEventListener, n4, this.delegate, 0);
        OS.CFRelease(n4);
        string = DOMEVENT_KEYUP;
        n3 = string.length();
        cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        n4 = OS.CFStringCreateWithCharacters(0, cArray, n3);
        Cocoa.objc_msgSend(n2, Cocoa.S_addEventListener, n4, this.delegate, 0);
        OS.CFRelease(n4);
    }

    void hookDOMMouseListeners(int n) {
        if (OS.VERSION < 4160) {
            return;
        }
        int n2 = Cocoa.objc_msgSend(n, Cocoa.S_DOMDocument);
        String string = DOMEVENT_MOUSEDOWN;
        int n3 = string.length();
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        int n4 = OS.CFStringCreateWithCharacters(0, cArray, n3);
        Cocoa.objc_msgSend(n2, Cocoa.S_addEventListener, n4, this.delegate, 0);
        OS.CFRelease(n4);
        string = DOMEVENT_MOUSEUP;
        n3 = string.length();
        cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        n4 = OS.CFStringCreateWithCharacters(0, cArray, n3);
        Cocoa.objc_msgSend(n2, Cocoa.S_addEventListener, n4, this.delegate, 0);
        OS.CFRelease(n4);
        string = DOMEVENT_MOUSEMOVE;
        n3 = string.length();
        cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        n4 = OS.CFStringCreateWithCharacters(0, cArray, n3);
        Cocoa.objc_msgSend(n2, Cocoa.S_addEventListener, n4, this.delegate, 0);
        OS.CFRelease(n4);
        string = DOMEVENT_MOUSEWHEEL;
        n3 = string.length();
        cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        n4 = OS.CFStringCreateWithCharacters(0, cArray, n3);
        Cocoa.objc_msgSend(n2, Cocoa.S_addEventListener, n4, this.delegate, 0);
        OS.CFRelease(n4);
    }

    void didReceiveTitle(int n, int n2) {
        if (n2 == Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame)) {
            int n3 = OS.CFStringGetLength(n);
            char[] cArray = new char[n3];
            CFRange cFRange = new CFRange();
            cFRange.length = n3;
            OS.CFStringGetCharacters(n, cFRange, cArray);
            String string = new String(cArray);
            TitleEvent titleEvent = new TitleEvent(this.browser);
            titleEvent.display = this.browser.getDisplay();
            titleEvent.widget = this.browser;
            titleEvent.title = string;
            int n4 = 0;
            while (n4 < this.titleListeners.length) {
                this.titleListeners[n4].changed(titleEvent);
                ++n4;
            }
        }
    }

    void didStartProvisionalLoadForFrame(int n) {
    }

    void didCommitLoadForFrame(int n) {
        TypedEvent typedEvent;
        boolean bl;
        int n2 = Cocoa.objc_msgSend(n, Cocoa.S_dataSource);
        int n3 = Cocoa.objc_msgSend(n2, Cocoa.S_request);
        int n4 = Cocoa.objc_msgSend(n3, Cocoa.S_URL);
        int n5 = Cocoa.objc_msgSend(n4, Cocoa.S_absoluteString);
        int n6 = OS.CFStringGetLength(n5);
        if (n6 == 0) {
            return;
        }
        char[] cArray = new char[n6];
        CFRange cFRange = new CFRange();
        cFRange.length = n6;
        OS.CFStringGetCharacters(n5, cFRange, cArray);
        String string = new String(cArray);
        if (string.equals(URI_FROMMEMORY)) {
            string = ABOUT_BLANK;
        }
        final Display display = this.browser.getDisplay();
        boolean bl2 = bl = n == Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
        if (bl) {
            this.resourceCount = 0;
            this.url = string;
            typedEvent = new ProgressEvent(this.browser);
            ((ProgressEvent)typedEvent).display = display;
            ((ProgressEvent)typedEvent).widget = this.browser;
            ((ProgressEvent)typedEvent).current = 1;
            ((ProgressEvent)typedEvent).total = 100;
            int n7 = 0;
            while (n7 < this.progressListeners.length) {
                final ProgressListener progressListener = this.progressListeners[n7];
                display.asyncExec(new Runnable((ProgressEvent)typedEvent){
                    private final /* synthetic */ ProgressEvent val$progress;
                    {
                        this.val$progress = progressEvent;
                    }

                    public void run() {
                        if (!display.isDisposed() && !Safari.this.browser.isDisposed()) {
                            progressListener.changed(this.val$progress);
                        }
                    }
                });
                ++n7;
            }
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = display;
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = string;
            int n8 = 0;
            while (n8 < this.statusTextListeners.length) {
                this.statusTextListeners[n8].changed(statusTextEvent);
                ++n8;
            }
        }
        typedEvent = new LocationEvent(this.browser);
        typedEvent.display = display;
        typedEvent.widget = this.browser;
        typedEvent.location = string;
        typedEvent.top = bl;
        int n9 = 0;
        while (n9 < this.locationListeners.length) {
            this.locationListeners[n9].changed((LocationEvent)typedEvent);
            ++n9;
        }
    }

    void didFinishLoadingFromDataSource(int n, int n2) {
    }

    void didFailLoadingWithError(int n, int n2, int n3) {
    }

    int identifierForInitialRequest(int n, int n2) {
        int n3;
        final Display display = this.browser.getDisplay();
        final ProgressEvent progressEvent = new ProgressEvent(this.browser);
        progressEvent.display = display;
        progressEvent.widget = this.browser;
        progressEvent.current = this.resourceCount;
        progressEvent.total = Math.max(this.resourceCount, 100);
        int n4 = 0;
        while (n4 < this.progressListeners.length) {
            final ProgressListener progressListener = this.progressListeners[n4];
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!display.isDisposed() && !Safari.this.browser.isDisposed()) {
                        progressListener.changed(progressEvent);
                    }
                }
            });
            ++n4;
        }
        n4 = Cocoa.objc_msgSend(Cocoa.C_NSNumber, Cocoa.S_numberWithInt, this.resourceCount++);
        if (this.identifier == 0 && (n3 = Cocoa.objc_msgSend(n2, Cocoa.S_webFrame)) == Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame)) {
            this.identifier = n4;
        }
        return n4;
    }

    int willSendRequest(int n, int n2, int n3, int n4) {
        return n2;
    }

    void handleNotification(int n) {
    }

    int createWebViewWithRequest(int n) {
        int n2;
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        windowEvent.required = true;
        if (this.openWindowListeners != null) {
            n2 = 0;
            while (n2 < this.openWindowListeners.length) {
                this.openWindowListeners[n2].open(windowEvent);
                ++n2;
            }
        }
        n2 = 0;
        Widget widget = null;
        if (windowEvent.browser != null && windowEvent.browser.webBrowser instanceof Safari) {
            widget = windowEvent.browser;
        }
        if (widget != null && !widget.isDisposed()) {
            n2 = ((Safari)((Browser)widget).webBrowser).webView;
            if (n != 0) {
                int n3 = Cocoa.objc_msgSend(n2, Cocoa.S_mainFrame);
                Cocoa.objc_msgSend(n3, Cocoa.S_loadRequest, n);
            }
        }
        return n2;
    }

    void webViewShow(int n) {
        Shell shell = this.browser.getShell();
        org.eclipse.swt.graphics.Point point = shell.getSize();
        shell.setSize(point.x + 1, point.y);
        shell.setSize(point.x, point.y);
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        if (this.location != null) {
            windowEvent.location = this.location;
        }
        if (this.size != null) {
            windowEvent.size = this.size;
        }
        windowEvent.addressBar = this.toolBar;
        windowEvent.menuBar = true;
        windowEvent.statusBar = this.statusBar;
        windowEvent.toolBar = this.toolBar;
        int n2 = 0;
        while (n2 < this.visibilityWindowListeners.length) {
            this.visibilityWindowListeners[n2].show(windowEvent);
            ++n2;
        }
        this.location = null;
        this.size = null;
    }

    void setFrame(int n) {
        float[] fArray = new float[4];
        OS.memmove(fArray, n, 16);
        Rectangle rectangle = this.browser.getDisplay().getBounds();
        this.location = new org.eclipse.swt.graphics.Point((int)fArray[0], rectangle.height - (int)fArray[1] - (int)fArray[3]);
        this.size = new org.eclipse.swt.graphics.Point((int)fArray[2], (int)fArray[3]);
    }

    void webViewFocus() {
    }

    void webViewUnfocus() {
    }

    void runJavaScriptAlertPanelWithMessage(int n) {
        int n2 = OS.CFStringGetLength(n);
        char[] cArray = new char[n2];
        CFRange cFRange = new CFRange();
        cFRange.length = n2;
        OS.CFStringGetCharacters(n, cFRange, cArray);
        String string = new String(cArray);
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 40);
        messageBox.setText("Javascript");
        messageBox.setMessage(string);
        messageBox.open();
    }

    int runJavaScriptConfirmPanelWithMessage(int n) {
        int n2 = OS.CFStringGetLength(n);
        char[] cArray = new char[n2];
        CFRange cFRange = new CFRange();
        cFRange.length = n2;
        OS.CFStringGetCharacters(n, cFRange, cArray);
        String string = new String(cArray);
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 292);
        messageBox.setText("Javascript");
        messageBox.setMessage(string);
        return messageBox.open() == 32 ? 1 : 0;
    }

    void runOpenPanelForFileButtonWithResultListener(int n) {
        FileDialog fileDialog = new FileDialog(this.browser.getShell(), 0);
        String string = fileDialog.open();
        if (string == null) {
            Cocoa.objc_msgSend(n, Cocoa.S_cancel);
            return;
        }
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        int n3 = OS.CFStringCreateWithCharacters(0, cArray, n2);
        Cocoa.objc_msgSend(n, Cocoa.S_chooseFilename, n3);
        OS.CFRelease(n3);
    }

    void webViewClose() {
        Shell shell = this.browser.getShell();
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        int n = 0;
        while (n < this.closeWindowListeners.length) {
            this.closeWindowListeners[n].close(windowEvent);
            ++n;
        }
        this.browser.dispose();
        if (shell.isDisposed()) {
            return;
        }
        org.eclipse.swt.graphics.Point point = shell.getSize();
        shell.setSize(point.x + 1, point.y);
        shell.setSize(point.x, point.y);
    }

    int contextMenuItemsForElement(int n, int n2) {
        Point point = new Point();
        OS.GetGlobalMouse(point);
        Event event = new Event();
        event.x = point.h;
        event.y = point.v;
        this.browser.notifyListeners(35, event);
        if (!event.doit || this.browser.isDisposed()) {
            return 0;
        }
        Menu menu = this.browser.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (event.x != point.h || event.y != point.v) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return 0;
        }
        return n2;
    }

    void setStatusBarVisible(int n) {
        this.statusBar = n != 0;
    }

    void setStatusText(int n) {
        int n2 = OS.CFStringGetLength(n);
        if (n2 == 0) {
            return;
        }
        char[] cArray = new char[n2];
        CFRange cFRange = new CFRange();
        cFRange.length = n2;
        OS.CFStringGetCharacters(n, cFRange, cArray);
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = new String(cArray);
        int n3 = 0;
        while (n3 < this.statusTextListeners.length) {
            this.statusTextListeners[n3].changed(statusTextEvent);
            ++n3;
        }
    }

    void setResizable(int n) {
    }

    void setToolbarsVisible(int n) {
        this.toolBar = n != 0;
    }

    void mouseDidMoveOverElement(int n, int n2) {
        Object object;
        String string;
        if (n == 0) {
            return;
        }
        int n3 = WebElementLinkURLKey.length();
        char[] cArray = new char[n3];
        WebElementLinkURLKey.getChars(0, n3, cArray, 0);
        int n4 = OS.CFStringCreateWithCharacters(0, cArray, n3);
        int n5 = Cocoa.objc_msgSend(n, Cocoa.S_valueForKey, n4);
        OS.CFRelease(n4);
        if (n5 == 0) {
            if (this.lastHoveredLinkURL == null) {
                return;
            }
            this.lastHoveredLinkURL = null;
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = this.browser.getDisplay();
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = "";
            int n6 = 0;
            while (n6 < this.statusTextListeners.length) {
                this.statusTextListeners[n6].changed(statusTextEvent);
                ++n6;
            }
            return;
        }
        int n7 = Cocoa.objc_msgSend(n5, Cocoa.S_absoluteString);
        n3 = OS.CFStringGetLength(n7);
        if (n3 == 0) {
            string = "";
        } else {
            cArray = new char[n3];
            object = new CFRange();
            ((CFRange)object).length = n3;
            OS.CFStringGetCharacters(n7, (CFRange)object, cArray);
            string = new String(cArray);
        }
        if (string.equals(this.lastHoveredLinkURL)) {
            return;
        }
        this.lastHoveredLinkURL = string;
        object = new StatusTextEvent(this.browser);
        ((StatusTextEvent)object).display = this.browser.getDisplay();
        ((StatusTextEvent)object).widget = this.browser;
        ((StatusTextEvent)object).text = string;
        int n8 = 0;
        while (n8 < this.statusTextListeners.length) {
            this.statusTextListeners[n8].changed((StatusTextEvent)object);
            ++n8;
        }
    }

    void decidePolicyForMIMEType(int n, int n2, int n3, int n4) {
        boolean bl = Cocoa.objc_msgSend(Cocoa.C_WebView, Cocoa.S_canShowMIMEType, n) != 0;
        Cocoa.objc_msgSend(n4, bl ? Cocoa.S_use : Cocoa.S_download);
    }

    void decidePolicyForNavigationAction(int n, int n2, int n3, int n4) {
        Object object;
        int n5 = Cocoa.objc_msgSend(n2, Cocoa.S_URL);
        if (n5 == 0) {
            Cocoa.objc_msgSend(n4, Cocoa.S_ignore);
            return;
        }
        int n6 = Cocoa.objc_msgSend(n5, Cocoa.S_absoluteString);
        int n7 = OS.CFStringGetLength(n6);
        char[] cArray = new char[n7];
        CFRange cFRange = new CFRange();
        cFRange.length = n7;
        OS.CFStringGetCharacters(n6, cFRange, cArray);
        String string = new String(cArray);
        if (string.equals(URI_FROMMEMORY)) {
            string = ABOUT_BLANK;
        }
        if (string.startsWith(URI_APPLEWEBDATA)) {
            Cocoa.objc_msgSend(n4, Cocoa.S_use);
        } else {
            object = new LocationEvent(this.browser);
            ((LocationEvent)object).display = this.browser.getDisplay();
            ((LocationEvent)object).widget = this.browser;
            ((LocationEvent)object).location = string;
            ((LocationEvent)object).doit = true;
            if (this.locationListeners != null) {
                this.changingLocation = true;
                int n8 = 0;
                while (n8 < this.locationListeners.length) {
                    this.locationListeners[n8].changing((LocationEvent)object);
                    ++n8;
                }
                this.changingLocation = false;
            }
            Cocoa.objc_msgSend(n4, ((LocationEvent)object).doit ? Cocoa.S_use : Cocoa.S_ignore);
        }
        if (this.html != null && !this.browser.isDisposed()) {
            object = this.html;
            this.html = null;
            this._setText((String)object);
        }
    }

    void decidePolicyForNewWindowAction(int n, int n2, int n3, int n4) {
        Cocoa.objc_msgSend(n4, Cocoa.S_use);
    }

    void unableToImplementPolicyWithError(int n, int n2) {
    }

    void decideDestinationWithSuggestedFilename(int n, int n2) {
        int n3 = OS.CFStringGetLength(n2);
        char[] cArray = new char[n3];
        CFRange cFRange = new CFRange();
        cFRange.length = n3;
        OS.CFStringGetCharacters(n2, cFRange, cArray);
        String string = new String(cArray);
        FileDialog fileDialog = new FileDialog(this.browser.getShell(), 8192);
        fileDialog.setText(SWT.getMessage("SWT_FileDownload"));
        fileDialog.setFileName(string);
        String string2 = fileDialog.open();
        if (string2 == null) {
            Cocoa.objc_msgSend(n, Cocoa.S_cancel);
            return;
        }
        n3 = string2.length();
        char[] cArray2 = new char[n3];
        string2.getChars(0, n3, cArray2, 0);
        int n4 = OS.CFStringCreateWithCharacters(0, cArray2, n3);
        Cocoa.objc_msgSend(n, Cocoa.S_setDestinationAllowOverwrite, n4, 1);
        OS.CFRelease(n4);
    }

    void handleEvent(int n) {
        int n2;
        boolean bl;
        int n3 = Cocoa.objc_msgSend(n, Cocoa.S_type);
        int n4 = OS.CFStringGetLength(n3);
        char[] cArray = new char[n4];
        CFRange cFRange = new CFRange();
        cFRange.length = n4;
        OS.CFStringGetCharacters(n3, cFRange, cArray);
        String string = new String(cArray);
        if (string.equals(DOMEVENT_FOCUSIN)) {
            this.hasNewFocusElement = true;
            return;
        }
        if (string.equals(DOMEVENT_FOCUSOUT)) {
            this.hasNewFocusElement = false;
            return;
        }
        boolean bl2 = Cocoa.objc_msgSend(n, Cocoa.S_ctrlKey) != 0;
        boolean bl3 = Cocoa.objc_msgSend(n, Cocoa.S_shiftKey) != 0;
        boolean bl4 = Cocoa.objc_msgSend(n, Cocoa.S_altKey) != 0;
        boolean bl5 = bl = Cocoa.objc_msgSend(n, Cocoa.S_metaKey) != 0;
        if (DOMEVENT_KEYDOWN.equals(string) || DOMEVENT_KEYUP.equals(string)) {
            int n5 = Cocoa.objc_msgSend(n, Cocoa.S_keyCode);
            int n6 = Cocoa.objc_msgSend(n, Cocoa.S_charCode);
            Event event = new Event();
            event.widget = this.browser;
            event.type = DOMEVENT_KEYDOWN.equals(string) ? 1 : 2;
            event.keyCode = this.translateKey(n5);
            event.character = event.keyCode == 127 ? (char)127 : (char)n6;
            event.stateMask = (bl4 ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl ? 0x400000 : 0);
            this.browser.notifyListeners(event.type, event);
            if (this.browser.isDisposed()) {
                Cocoa.objc_msgSend(n, Cocoa.S_preventDefault);
                return;
            }
            boolean bl6 = event.doit;
            if (bl6 && OS.VERSION < 4176 && event.keyCode == 9 && (event.stateMask & 0x20000) != 0) {
                bl6 = false;
            }
            if (!bl6) {
                Cocoa.objc_msgSend(n, Cocoa.S_preventDefault);
            } else if (!this.hasNewFocusElement && event.keyCode == 9 && DOMEVENT_KEYUP.equals(string)) {
                this.browser.traverse(16);
                this.hasNewFocusElement = false;
            }
            return;
        }
        int n7 = Cocoa.objc_msgSend(n, Cocoa.S_clientX);
        int n8 = Cocoa.objc_msgSend(n, Cocoa.S_clientY);
        int n9 = Cocoa.objc_msgSend(n, Cocoa.S_detail);
        Event event = new Event();
        event.widget = this.browser;
        event.x = n7;
        event.y = n8;
        event.stateMask = (bl4 ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl ? 0x400000 : 0);
        if (DOMEVENT_MOUSEDOWN.equals(string)) {
            event.type = 3;
            n2 = Cocoa.objc_msgSend(n, Cocoa.S_button);
            event.button = n2 + 1;
            event.count = n9;
        } else if (DOMEVENT_MOUSEUP.equals(string)) {
            event.type = 4;
            n2 = Cocoa.objc_msgSend(n, Cocoa.S_button);
            event.button = n2 + 1;
            event.count = n9;
            switch (event.button) {
                case 1: {
                    event.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    event.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    event.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    event.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    event.stateMask |= 0x2000000;
                }
            }
        } else if (DOMEVENT_MOUSEMOVE.equals(string)) {
            if (event.x == this.lastMouseMoveX && event.y == this.lastMouseMoveY) {
                return;
            }
            event.type = 5;
            this.lastMouseMoveX = event.x;
            this.lastMouseMoveY = event.y;
        } else if (DOMEVENT_MOUSEWHEEL.equals(string)) {
            event.type = 37;
            n2 = Cocoa.objc_msgSend(n, Cocoa.S_wheelDelta);
            event.count = n2 / 120;
        }
        this.browser.notifyListeners(event.type, event);
        if (this.browser.isDisposed()) {
            return;
        }
        if (n9 == 2 && DOMEVENT_MOUSEDOWN.equals(string)) {
            n2 = Cocoa.objc_msgSend(n, Cocoa.S_button);
            event = new Event();
            event.widget = this.browser;
            event.x = n7;
            event.y = n8;
            event.stateMask = (bl4 ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl ? 0x400000 : 0);
            event.type = 8;
            event.button = n2 + 1;
            event.count = n9;
            this.browser.notifyListeners(event.type, event);
        }
    }
}

