/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.DataBrowserCallbacks;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_HYSTERESIS = 150;
    TableItem scrollItem;
    long scrollBeginTime;
    DataBrowserCallbacks callbacks = null;
    static Callback AcceptDragProc;
    static /* synthetic */ Class class$0;

    static {
        int n;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.TableDropTargetEffect");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((n = (AcceptDragProc = new Callback(clazz, "AcceptDragProc", 5)).getAddress()) == 0) {
            SWT.error(3);
        }
    }

    static int AcceptDragProc(int n, int n2, int n3, int n4, int n5) {
        DropTarget dropTarget = TableDropTargetEffect.FindDropTarget(n, n5);
        if (dropTarget == null) {
            return 0;
        }
        return (dropTarget.feedback & 1) != 0 ? 1 : 0;
    }

    static DropTarget FindDropTarget(int n, int n2) {
        if (n == 0) {
            return null;
        }
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(n);
        if (widget == null) {
            return null;
        }
        return (DropTarget)widget.getData("DropTarget");
    }

    public TableDropTargetEffect(Table table) {
        super(table);
    }

    int checkEffect(int n) {
        if ((n & 1) != 0) {
            n = n & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((n & 2) != 0) {
            n &= 0xFFFFFFFB;
        }
        return n;
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        if (this.callbacks == null) {
            Table table = (Table)this.control;
            DataBrowserCallbacks dataBrowserCallbacks = new DataBrowserCallbacks();
            OS.GetDataBrowserCallbacks(table.handle, dataBrowserCallbacks);
            dataBrowserCallbacks.v1_acceptDragCallback = AcceptDragProc.getAddress();
            OS.SetDataBrowserCallbacks(table.handle, dataBrowserCallbacks);
        }
        this.scrollBeginTime = 0L;
        this.scrollItem = null;
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        this.scrollBeginTime = 0L;
        this.scrollItem = null;
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        Table table = (Table)this.control;
        int n = this.checkEffect(dropTargetEvent.feedback);
        TableItem tableItem = (TableItem)this.getItem(table, dropTargetEvent.x, dropTargetEvent.y);
        if ((n & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollItem = null;
        } else if (tableItem != null && tableItem.equals(this.scrollItem) && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                int n2;
                Rectangle rectangle = table.getClientArea();
                int n3 = table.getHeaderHeight();
                int n4 = table.getItemHeight();
                Point point = new Point(dropTargetEvent.x, dropTargetEvent.y);
                point = table.getDisplay().map(null, (Control)table, point);
                TableItem tableItem2 = null;
                if (point.y < rectangle.y + n3 + 2 * n4) {
                    n2 = Math.max(0, table.indexOf(tableItem) - 1);
                    tableItem2 = table.getItem(n2);
                }
                if (point.y > rectangle.y + rectangle.height - 2 * n4) {
                    n2 = Math.min(table.getItemCount() - 1, table.indexOf(tableItem) + 1);
                    tableItem2 = table.getItem(n2);
                }
                if (tableItem2 != null) {
                    table.showItem(tableItem2);
                }
                this.scrollBeginTime = 0L;
                this.scrollItem = null;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollItem = tableItem;
        }
        ((DropTarget)dropTargetEvent.widget).feedback = n;
    }
}

