/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class CoolBar
extends Composite {
    CoolItem[][] items = new CoolItem[0][0];
    CoolItem[] originalItems = new CoolItem[0];
    Cursor hoverCursor;
    Cursor dragCursor;
    Cursor cursor;
    CoolItem dragging = null;
    int mouseXOffset;
    int itemXOffset;
    boolean isLocked = false;
    boolean inDispose = false;
    static final int ROW_SPACING = 2;
    static final int CLICK_DISTANCE = 3;
    static final int DEFAULT_COOLBAR_WIDTH = 0;
    static final int DEFAULT_COOLBAR_HEIGHT = 0;

    public CoolBar(Composite composite, int n) {
        super(composite, CoolBar.checkStyle(n));
        if ((n & 0x200) != 0) {
            this.style |= 0x200;
            this.hoverCursor = new Cursor(this.display, 7);
        } else {
            this.style |= 0x100;
            this.hoverCursor = new Cursor(this.display, 9);
        }
        this.dragCursor = new Cursor(this.display, 5);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        CoolBar.this.onDispose(event);
                        break;
                    }
                    case 3: {
                        CoolBar.this.onMouseDown(event);
                        break;
                    }
                    case 7: {
                        CoolBar.this.onMouseExit();
                        break;
                    }
                    case 5: {
                        CoolBar.this.onMouseMove(event);
                        break;
                    }
                    case 4: {
                        CoolBar.this.onMouseUp(event);
                        break;
                    }
                    case 8: {
                        CoolBar.this.onMouseDoubleClick(event);
                        break;
                    }
                    case 9: {
                        CoolBar.this.onPaint(event);
                        break;
                    }
                    case 11: {
                        CoolBar.this.onResize();
                    }
                }
            }
        };
        int[] nArray = new int[]{12, 3, 7, 5, 4, 8, 9, 11};
        int n2 = 0;
        while (n2 < nArray.length) {
            this.addListener(nArray[n2], listener);
            ++n2;
        }
    }

    static int checkStyle(int n) {
        return ((n |= 0x80000) | 0x100000) & 0xFFFFFCFF;
    }

    void _setCursor(Cursor cursor) {
        if (this.cursor != null) {
            return;
        }
        super.setCursor(cursor);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        this.wrapItems((this.style & 0x200) != 0 ? n2 : n);
        boolean bl2 = (this.style & 0x800000) != 0;
        int n5 = 0;
        while (n5 < this.items.length) {
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (n8 < this.items[n5].length) {
                CoolItem coolItem = this.items[n5][n8];
                n6 += coolItem.preferredWidth;
                n7 = Math.max(n7, coolItem.preferredHeight);
                ++n8;
            }
            n4 += n7;
            if (!bl2 && n5 > 0) {
                n4 += 2;
            }
            n3 = Math.max(n3, n6);
            ++n5;
        }
        this.wrapItems(this.getWidth());
        if (n3 == 0) {
            n3 = 0;
        }
        if (n4 == 0) {
            n4 = 0;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n3, n4);
        return this.fixPoint(rectangle.width, rectangle.height);
    }

    CoolItem getGrabbedItem(int n, int n2) {
        int n3 = 0;
        while (n3 < this.items.length) {
            int n4 = 0;
            while (n4 < this.items[n3].length) {
                CoolItem coolItem = this.items[n3][n4];
                Rectangle rectangle = coolItem.internalGetBounds();
                rectangle.width = 10;
                if (rectangle.x > n) break;
                if (rectangle.y > n2) {
                    return null;
                }
                if (rectangle.contains(n, n2)) {
                    return coolItem;
                }
                ++n4;
            }
            ++n3;
        }
        return null;
    }

    public CoolItem getItem(int n) {
        this.checkWidget();
        if (n < 0) {
            this.error(6);
        }
        int n2 = 0;
        while (n2 < this.items.length) {
            if (this.items[n2].length > n) {
                return this.items[n2][n];
            }
            n -= this.items[n2].length;
            ++n2;
        }
        this.error(6);
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.originalItems.length;
    }

    public CoolItem[] getItems() {
        this.checkWidget();
        CoolItem[] coolItemArray = new CoolItem[this.getItemCount()];
        int n = 0;
        int n2 = 0;
        while (n2 < this.items.length) {
            System.arraycopy(this.items[n2], 0, coolItemArray, n, this.items[n2].length);
            n += this.items[n2].length;
            ++n2;
        }
        return coolItemArray;
    }

    Point findItem(CoolItem coolItem) {
        int n = 0;
        while (n < this.items.length) {
            int n2 = 0;
            while (n2 < this.items[n].length) {
                if (this.items[n][n2].equals(coolItem)) {
                    return new Point(n2, n);
                }
                ++n2;
            }
            ++n;
        }
        return new Point(-1, -1);
    }

    void fixEvent(Event event) {
        if ((this.style & 0x200) != 0) {
            int n = event.x;
            event.x = event.y;
            event.y = n;
        }
    }

    Rectangle fixRectangle(int n, int n2, int n3, int n4) {
        if ((this.style & 0x200) != 0) {
            return new Rectangle(n2, n, n4, n3);
        }
        return new Rectangle(n, n2, n3, n4);
    }

    Point fixPoint(int n, int n2) {
        if ((this.style & 0x200) != 0) {
            return new Point(n2, n);
        }
        return new Point(n, n2);
    }

    public int indexOf(CoolItem coolItem) {
        this.checkWidget();
        if (coolItem == null) {
            this.error(4);
        }
        if (coolItem.isDisposed()) {
            this.error(5);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.items.length) {
            int n3 = 0;
            while (n3 < this.items[n2].length) {
                if (this.items[n2][n3].equals(coolItem)) {
                    return n;
                }
                ++n;
                ++n3;
            }
            ++n2;
        }
        return -1;
    }

    void insertItemIntoRow(CoolItem coolItem, int n, int n2) {
        int n3 = this.getWidth();
        int n4 = this.items[n][0].internalGetBounds().y;
        int n5 = Math.max(0, Math.abs(n2 - this.toDisplay((Point)new Point((int)0, (int)0)).x));
        int n6 = 0;
        while (n6 < this.items[n].length) {
            if (n5 < this.items[n][n6].internalGetBounds().x) break;
            ++n6;
        }
        if (n6 == 0) {
            coolItem.wrap = true;
            this.items[n][0].wrap = false;
        }
        int n7 = this.items[n].length;
        CoolItem[] coolItemArray = new CoolItem[n7 + 1];
        System.arraycopy(this.items[n], 0, coolItemArray, 0, n6);
        coolItemArray[n6] = coolItem;
        System.arraycopy(this.items[n], n6, coolItemArray, n6 + 1, n7 - n6);
        this.items[n] = coolItemArray;
        if (n6 > 0) {
            CoolItem coolItem2 = this.items[n][n6 - 1];
            Rectangle rectangle = coolItem2.internalGetBounds();
            int n8 = n5 - rectangle.x;
            if (n8 < coolItem2.internalGetMinimumWidth()) {
                n5 += coolItem2.internalGetMinimumWidth() - n8;
                n8 = coolItem2.internalGetMinimumWidth();
            }
            coolItem2.setBounds(rectangle.x, rectangle.y, n8, rectangle.height);
            coolItem2.requestedWidth = n8;
        }
        int n9 = 0;
        int n10 = coolItem.internalGetBounds().height;
        if (n6 < this.items[n].length - 1) {
            CoolItem coolItem3;
            n9 = coolItem3.internalGetBounds().x - n5;
            coolItem3 = this.items[n][n6 + 1];
            if (n9 < coolItem3.internalGetMinimumWidth()) {
                this.moveRight(coolItem3, coolItem3.internalGetMinimumWidth() - n9);
                n9 = coolItem3.internalGetBounds().x - n5;
            }
            coolItem.setBounds(n5, n4, n9, n10);
            if (n9 < coolItem.internalGetMinimumWidth()) {
                this.moveLeft(coolItem, coolItem.internalGetMinimumWidth() - n9);
            }
        } else {
            n9 = Math.max(coolItem.internalGetMinimumWidth(), n3 - n5);
            coolItem.setBounds(n5, n4, n9, n10);
            if (n5 + n9 > n3) {
                this.moveLeft(coolItem, n5 + n9 - n3);
            }
        }
        Rectangle rectangle = coolItem.internalGetBounds();
        coolItem.requestedWidth = rectangle.width;
        this.internalRedraw(rectangle.x, rectangle.y, coolItem.internalGetMinimumWidth(), rectangle.height);
    }

    void internalRedraw(int n, int n2, int n3, int n4) {
        if ((this.style & 0x200) != 0) {
            this.redraw(n2, n, n4, n3, false);
        } else {
            this.redraw(n, n2, n3, n4, false);
        }
    }

    void createItem(CoolItem coolItem, int n) {
        int n2;
        int n3 = this.getItemCount();
        int n4 = 0;
        if (n < 0 || n > n3) {
            this.error(6);
        }
        if (this.items.length == 0) {
            this.items = new CoolItem[1][1];
            this.items[0][0] = coolItem;
        } else {
            n2 = n;
            if (n < n3) {
                while (n2 > this.items[n4].length) {
                    n2 -= this.items[n4].length;
                    ++n4;
                }
            } else {
                n4 = this.items.length - 1;
                n2 = this.items[n4].length;
            }
            int n5 = this.items[n4].length - 1;
            CoolItem coolItem2 = this.items[n4][n5];
            if (coolItem2.ideal) {
                Rectangle rectangle = coolItem2.internalGetBounds();
                rectangle.width = coolItem2.preferredWidth;
                rectangle.height = coolItem2.preferredHeight;
                coolItem2.requestedWidth = coolItem2.preferredWidth;
                coolItem2.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (n2 == 0) {
                coolItem.wrap = true;
                this.items[n4][0].wrap = false;
            }
            int n6 = this.items[n4].length;
            CoolItem[] coolItemArray = new CoolItem[n6 + 1];
            System.arraycopy(this.items[n4], 0, coolItemArray, 0, n2);
            coolItemArray[n2] = coolItem;
            System.arraycopy(this.items[n4], n2, coolItemArray, n2 + 1, n6 - n2);
            this.items[n4] = coolItemArray;
        }
        coolItem.requestedWidth = 10;
        n2 = this.originalItems.length;
        CoolItem[] coolItemArray = new CoolItem[n2 + 1];
        System.arraycopy(this.originalItems, 0, coolItemArray, 0, n);
        System.arraycopy(this.originalItems, n, coolItemArray, n + 1, n2 - n);
        coolItemArray[n] = coolItem;
        this.originalItems = coolItemArray;
        this.layoutItems();
    }

    void destroyItem(CoolItem coolItem) {
        if (this.inDispose) {
            return;
        }
        int n = this.findItem((CoolItem)coolItem).y;
        if (n == -1) {
            return;
        }
        Rectangle rectangle = coolItem.internalGetBounds();
        this.removeItemFromRow(coolItem, n, true);
        int n2 = 0;
        while (n2 < this.originalItems.length) {
            if (this.originalItems[n2] == coolItem) break;
            ++n2;
        }
        int n3 = this.originalItems.length - 1;
        CoolItem[] coolItemArray = new CoolItem[n3];
        System.arraycopy(this.originalItems, 0, coolItemArray, 0, n2);
        System.arraycopy(this.originalItems, n2 + 1, coolItemArray, n2, n3 - n2);
        this.originalItems = coolItemArray;
        this.internalRedraw(rectangle.x, rectangle.y, 10, rectangle.height);
        this.relayout();
    }

    void moveDown(CoolItem coolItem, int n) {
        int n2 = this.findItem((CoolItem)coolItem).y;
        boolean bl = false;
        if (this.items[n2].length == 1) {
            bl = true;
            if (n2 == this.items.length - 1) {
                return;
            }
        }
        int n3 = this.items[n2].length == 1 ? n2 : n2 + 1;
        this.removeItemFromRow(coolItem, n2, false);
        Rectangle rectangle = coolItem.internalGetBounds();
        this.internalRedraw(rectangle.x, rectangle.y, 10, rectangle.height);
        if (n3 == this.items.length) {
            CoolItem[][] coolItemArrayArray = new CoolItem[this.items.length + 1][];
            System.arraycopy(this.items, 0, coolItemArrayArray, 0, this.items.length);
            int n4 = this.items.length;
            coolItemArrayArray[n4] = new CoolItem[1];
            coolItemArrayArray[n4][0] = coolItem;
            this.items = coolItemArrayArray;
            bl = true;
            coolItem.wrap = true;
        } else {
            this.insertItemIntoRow(coolItem, n3, n);
        }
        if (bl) {
            this.relayout();
        } else {
            this.layoutItems();
        }
    }

    void moveLeft(CoolItem coolItem, int n) {
        int n2;
        Point point = this.findItem(coolItem);
        int n3 = point.y;
        int n4 = point.x;
        if (n4 == 0) {
            return;
        }
        Rectangle rectangle = coolItem.internalGetBounds();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            n5 += this.items[n3][n6].internalGetMinimumWidth();
            ++n6;
        }
        n6 = Math.max(n5, rectangle.x - n);
        CoolItem coolItem2 = this.items[n3][n4 - 1];
        Rectangle rectangle2 = coolItem2.internalGetBounds();
        if (rectangle2.x + coolItem2.internalGetMinimumWidth() > n6) {
            n2 = rectangle2.x + coolItem2.internalGetMinimumWidth() - n6;
            this.moveLeft(coolItem2, n2);
            rectangle2 = coolItem2.internalGetBounds();
        }
        n2 = Math.max(coolItem2.internalGetMinimumWidth(), rectangle2.width - n);
        coolItem2.setBounds(rectangle2.x, rectangle2.y, n2, rectangle2.height);
        coolItem2.requestedWidth = n2;
        int n7 = rectangle.width + (rectangle.x - n6);
        coolItem.setBounds(n6, rectangle.y, n7, rectangle.height);
        coolItem.requestedWidth = n7;
        int n8 = rectangle.x - n6 + 10;
        if (n8 > 10) {
            this.internalRedraw(n6, rectangle.y, n8, rectangle.height);
        }
    }

    void moveRight(CoolItem coolItem, int n) {
        int n2;
        Rectangle rectangle;
        CoolItem coolItem2;
        Point point = this.findItem(coolItem);
        int n3 = point.y;
        int n4 = point.x;
        if (n4 == 0) {
            return;
        }
        Rectangle rectangle2 = coolItem.internalGetBounds();
        int n5 = 0;
        int n6 = n4;
        while (n6 < this.items[n3].length) {
            n5 += this.items[n3][n6].internalGetMinimumWidth();
            ++n6;
        }
        n6 = this.getWidth() - n5;
        int n7 = Math.min(n6, rectangle2.x + n);
        int n8 = 0;
        if (n4 + 1 == this.items[n3].length) {
            n8 = this.getWidth() - n7;
        } else {
            coolItem2 = this.items[n3][n4 + 1];
            rectangle = coolItem2.internalGetBounds();
            if (n7 + coolItem.internalGetMinimumWidth() > rectangle.x) {
                n2 = n7 + coolItem.internalGetMinimumWidth() - rectangle.x;
                this.moveRight(coolItem2, n2);
                rectangle = coolItem2.internalGetBounds();
            }
            n8 = rectangle.x - n7;
        }
        coolItem.setBounds(n7, rectangle2.y, n8, rectangle2.height);
        coolItem.requestedWidth = n8;
        coolItem2 = this.items[n3][n4 - 1];
        rectangle = coolItem2.internalGetBounds();
        n2 = n7 - rectangle.x;
        coolItem2.setBounds(rectangle.x, rectangle.y, n2, rectangle.height);
        coolItem2.requestedWidth = n2;
        int n9 = n7 - rectangle2.x + 10 + 4;
        if (n7 - rectangle2.x > 0) {
            this.internalRedraw(rectangle2.x - 4, rectangle2.y, n9, rectangle2.height);
        }
    }

    void moveUp(CoolItem coolItem, int n) {
        Point point = this.findItem(coolItem);
        int n2 = point.y;
        boolean bl = false;
        if (this.items[n2].length == 1) {
            bl = true;
            if (n2 == 0) {
                return;
            }
        }
        this.removeItemFromRow(coolItem, n2, false);
        Rectangle rectangle = coolItem.internalGetBounds();
        this.internalRedraw(rectangle.x, rectangle.y, 10, rectangle.height);
        int n3 = Math.max(0, n2 - 1);
        if (n2 == 0) {
            CoolItem[][] coolItemArrayArray = new CoolItem[this.items.length + 1][];
            System.arraycopy(this.items, 0, coolItemArrayArray, 1, this.items.length);
            coolItemArrayArray[0] = new CoolItem[1];
            coolItemArrayArray[0][0] = coolItem;
            this.items = coolItemArrayArray;
            bl = true;
            coolItem.wrap = true;
        } else {
            this.insertItemIntoRow(coolItem, n3, n);
        }
        if (bl) {
            this.relayout();
        } else {
            this.layoutItems();
        }
    }

    void onDispose(Event event) {
        if (this.inDispose) {
            return;
        }
        this.inDispose = true;
        this.notifyListeners(12, event);
        event.type = 0;
        int n = 0;
        while (n < this.items.length) {
            int n2 = 0;
            while (n2 < this.items[n].length) {
                this.items[n][n2].dispose();
                ++n2;
            }
            ++n;
        }
        this.hoverCursor.dispose();
        this.dragCursor.dispose();
        this.cursor = null;
    }

    void onMouseDown(Event event) {
        if (this.isLocked || event.button != 1) {
            return;
        }
        this.fixEvent(event);
        this.dragging = this.getGrabbedItem(event.x, event.y);
        if (this.dragging != null) {
            this.mouseXOffset = event.x;
            this.itemXOffset = this.mouseXOffset - this.dragging.internalGetBounds().x;
            this._setCursor(this.dragCursor);
        }
        this.fixEvent(event);
    }

    void onMouseExit() {
        if (this.dragging == null) {
            this._setCursor(null);
        }
    }

    void onMouseMove(Event event) {
        if (this.isLocked) {
            return;
        }
        this.fixEvent(event);
        CoolItem coolItem = this.getGrabbedItem(event.x, event.y);
        if (this.dragging != null) {
            int n;
            int n2 = this.toDisplay((Point)new Point((int)(event.x - this.itemXOffset), (int)event.y)).x;
            Rectangle rectangle = this.dragging.internalGetBounds();
            if (event.y < rectangle.y) {
                this.moveUp(this.dragging, n2);
            } else if (event.y > rectangle.y + rectangle.height) {
                this.moveDown(this.dragging, n2);
            } else if (event.x < this.mouseXOffset) {
                int n3 = Math.min(this.mouseXOffset, rectangle.x + this.itemXOffset) - event.x;
                if (n3 > 0) {
                    this.moveLeft(this.dragging, n3);
                }
            } else if (event.x > this.mouseXOffset && (n = event.x - Math.max(this.mouseXOffset, rectangle.x + this.itemXOffset)) > 0) {
                this.moveRight(this.dragging, n);
            }
            this.mouseXOffset = event.x;
        } else if (coolItem != null) {
            this._setCursor(this.hoverCursor);
        } else {
            this._setCursor(null);
        }
        this.fixEvent(event);
    }

    void onMouseUp(Event event) {
        this._setCursor(null);
        this.dragging = null;
    }

    void onMouseDoubleClick(Event event) {
        if (this.isLocked) {
            return;
        }
        this.dragging = null;
        this.fixEvent(event);
        CoolItem coolItem = this.getGrabbedItem(event.x, event.y);
        if (coolItem == null) {
            this._setCursor(null);
        } else {
            Point point = this.findItem(coolItem);
            int n = point.y;
            int n2 = point.x;
            if (this.items[n].length > 1) {
                Rectangle rectangle = coolItem.internalGetBounds();
                int n3 = this.getWidth();
                int n4 = 0;
                while (n4 < this.items[n].length) {
                    if (n4 != n2) {
                        n3 -= this.items[n][n4].internalGetMinimumWidth();
                    }
                    ++n4;
                }
                if (rectangle.width == n3) {
                    n4 = rectangle.width - coolItem.internalGetMinimumWidth();
                    if (n2 + 1 < this.items[n].length) {
                        CoolItem coolItem2 = this.items[n][n2 + 1];
                        this.moveLeft(coolItem2, n4);
                    } else {
                        this.moveRight(coolItem, n4);
                    }
                } else if (rectangle.width < coolItem.preferredWidth) {
                    n4 = coolItem.preferredWidth - rectangle.width;
                    if (n2 + 1 < this.items[n].length) {
                        CoolItem coolItem3 = this.items[n][n2 + 1];
                        this.moveRight(coolItem3, n4);
                        n4 = coolItem.preferredWidth - coolItem.internalGetBounds().width;
                    }
                    if (n4 > 0) {
                        this.moveLeft(coolItem, n4);
                    }
                } else {
                    n4 = 0;
                    while (n4 < this.items[n].length) {
                        if (n4 != n2) {
                            CoolItem coolItem4 = this.items[n][n4];
                            coolItem4.requestedWidth = Math.max(coolItem4.internalGetMinimumWidth(), 10);
                        }
                        ++n4;
                    }
                    coolItem.requestedWidth = n3;
                    this.layoutItems();
                }
                this._setCursor(this.hoverCursor);
            }
        }
        this.fixEvent(event);
    }

    void onPaint(Event event) {
        GC gC = event.gc;
        if (this.items.length == 0) {
            return;
        }
        Color color = this.display.getSystemColor(18);
        Color color2 = this.display.getSystemColor(20);
        boolean bl = (this.style & 0x200) != 0;
        boolean bl2 = (this.style & 0x800000) != 0;
        int n = this.getWidth();
        Rectangle rectangle = gC.getClipping();
        int n2 = 0;
        while (n2 < this.items.length) {
            Rectangle rectangle2;
            Rectangle rectangle3 = new Rectangle(0, 0, 0, 0);
            int n3 = 0;
            while (n3 < this.items[n2].length) {
                rectangle3 = this.items[n2][n3].internalGetBounds();
                rectangle2 = this.fixRectangle(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                if (rectangle.intersects(rectangle2)) {
                    boolean bl3 = false;
                    if (!this.isLocked) {
                        rectangle2 = this.fixRectangle(rectangle3.x, rectangle3.y, 10, rectangle3.height);
                        if (!bl2) {
                            bl3 = this.drawGripper(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, bl);
                        }
                        if (!bl3) {
                            int n4 = 2;
                            int n5 = rectangle3.height - 2 * n4 - 1;
                            gC.setForeground(color);
                            rectangle2 = this.fixRectangle(rectangle3.x + 4, rectangle3.y + n4, 2, n5);
                            gC.drawRectangle(rectangle2);
                            gC.setForeground(color2);
                            rectangle2 = this.fixRectangle(rectangle3.x + 4, rectangle3.y + n4 + 1, rectangle3.x + 4, rectangle3.y + n4 + n5 - 1);
                            gC.drawLine(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                            rectangle2 = this.fixRectangle(rectangle3.x + 4, rectangle3.y + n4, rectangle3.x + 4 + 1, rectangle3.y + n4);
                            gC.drawLine(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        }
                    }
                    if (!bl2 && !bl3 && n3 != 0) {
                        gC.setForeground(color);
                        rectangle2 = this.fixRectangle(rectangle3.x, rectangle3.y, rectangle3.x, rectangle3.y + rectangle3.height - 1);
                        gC.drawLine(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        gC.setForeground(color2);
                        rectangle2 = this.fixRectangle(rectangle3.x + 1, rectangle3.y, rectangle3.x + 1, rectangle3.y + rectangle3.height - 1);
                        gC.drawLine(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    }
                }
                ++n3;
            }
            if (!bl2 && n2 + 1 < this.items.length) {
                n3 = rectangle3.y + rectangle3.height;
                gC.setForeground(color);
                rectangle2 = this.fixRectangle(0, n3, n, n3);
                gC.drawLine(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                gC.setForeground(color2);
                rectangle2 = this.fixRectangle(0, n3 + 1, n, n3 + 1);
                gC.drawLine(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            ++n2;
        }
    }

    void onResize() {
        this.layoutItems();
    }

    void removeControl(Control control2) {
        super.removeControl(control2);
        CoolItem[] coolItemArray = this.getItems();
        int n = 0;
        while (n < coolItemArray.length) {
            CoolItem coolItem = coolItemArray[n];
            if (coolItem.control == control2) {
                coolItem.setControl(null);
            }
            ++n;
        }
    }

    void removeItemFromRow(CoolItem coolItem, int n, boolean bl) {
        int n2 = this.findItem((CoolItem)coolItem).x;
        int n3 = this.items[n].length - 1;
        Rectangle rectangle = coolItem.internalGetBounds();
        coolItem.wrap = false;
        if (n3 <= 0) {
            CoolItem[][] coolItemArrayArray = new CoolItem[this.items.length - 1][];
            System.arraycopy(this.items, 0, coolItemArrayArray, 0, n);
            System.arraycopy(this.items, n + 1, coolItemArrayArray, n, coolItemArrayArray.length - n);
            this.items = coolItemArrayArray;
            return;
        }
        Object object = new CoolItem[n3];
        System.arraycopy(this.items[n], 0, object, 0, n2);
        System.arraycopy(this.items[n], n2 + 1, object, n2, ((CoolItem[])object).length - n2);
        this.items[n] = object;
        this.items[n][0].wrap = true;
        if (!bl) {
            if (n2 == 0) {
                object = this.items[n][0];
                Rectangle rectangle2 = ((CoolItem)object).internalGetBounds();
                int n4 = rectangle2.x + rectangle2.width;
                ((CoolItem)object).setBounds(0, rectangle2.y, n4, rectangle2.height);
                ((CoolItem)object).requestedWidth = n4;
                this.internalRedraw(rectangle2.x, rectangle2.y, 10, rectangle2.height);
            } else {
                object = this.items[n][n2 - 1];
                Rectangle rectangle3 = ((CoolItem)object).internalGetBounds();
                int n5 = rectangle3.width + rectangle.width;
                ((CoolItem)object).setBounds(rectangle3.x, rectangle3.y, n5, rectangle3.height);
                ((CoolItem)object).requestedWidth = n5;
            }
        }
    }

    int layoutItems() {
        int n = 0;
        int n2 = (this.style & 0x200) != 0 ? this.getClientArea().height : this.getClientArea().width;
        this.wrapItems(n2);
        int n3 = (this.style & 0x800000) != 0 ? 0 : 2;
        int n4 = 0;
        while (n4 < this.items.length) {
            CoolItem coolItem;
            int n5 = this.items[n4].length;
            int n6 = 0;
            int n7 = 0;
            int n8 = n2;
            int n9 = 0;
            while (n9 < n5) {
                coolItem = this.items[n4][n9];
                n7 = Math.max(n7, coolItem.internalGetBounds().height);
                n8 -= coolItem.internalGetMinimumWidth();
                ++n9;
            }
            if (n4 > 0) {
                n += n3;
            }
            n9 = 0;
            while (n9 < n5) {
                Rectangle rectangle;
                Rectangle rectangle2;
                coolItem = this.items[n4][n9];
                int n10 = n8 + coolItem.internalGetMinimumWidth();
                if (n9 + 1 < n5) {
                    n10 = Math.min(n10, coolItem.requestedWidth);
                    n8 -= n10 - coolItem.internalGetMinimumWidth();
                }
                if (!(rectangle2 = coolItem.internalGetBounds()).equals(rectangle = new Rectangle(n6, n, n10, n7))) {
                    coolItem.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    Rectangle rectangle3 = new Rectangle(0, 0, 0, 0);
                    if (rectangle2.y != rectangle.y) {
                        rectangle3 = rectangle;
                        rectangle3.add(rectangle2);
                        rectangle3.y -= n3;
                        rectangle3.height += 2 * n3;
                    } else if (rectangle2.height != rectangle.height) {
                        rectangle3.y = rectangle.y + Math.min(rectangle2.height, rectangle.height) - 3;
                        rectangle3.height = rectangle.y + rectangle.height + n3;
                        rectangle3.x = rectangle2.x - 4;
                        rectangle3.width = rectangle2.width + 4;
                    } else if (rectangle2.x != rectangle.x) {
                        rectangle3.x = Math.min(rectangle2.x, rectangle.x);
                        rectangle3.width = Math.abs(rectangle2.x - rectangle.x) + 10;
                        rectangle3.y = rectangle2.y;
                        rectangle3.height = rectangle2.height;
                    }
                    this.internalRedraw(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                }
                n6 += n10;
                ++n9;
            }
            n += n7;
            ++n4;
        }
        return n;
    }

    void relayout() {
        Point point = this.getSize();
        int n = this.layoutItems();
        if ((this.style & 0x200) != 0) {
            Rectangle rectangle = this.computeTrim(0, 0, n, 0);
            if (n != point.x) {
                super.setSize(rectangle.width, point.y);
            }
        } else {
            Rectangle rectangle = this.computeTrim(0, 0, 0, n);
            if (n != point.y) {
                super.setSize(point.x, rectangle.height);
            }
        }
    }

    public int[] getItemOrder() {
        this.checkWidget();
        int n = this.getItemCount();
        int[] nArray = new int[n];
        n = 0;
        int n2 = 0;
        while (n2 < this.items.length) {
            int n3 = 0;
            while (n3 < this.items[n2].length) {
                CoolItem coolItem = this.items[n2][n3];
                int n4 = 0;
                while (n4 < this.originalItems.length) {
                    if (this.originalItems[n4] == coolItem) break;
                    ++n4;
                }
                if (n4 == this.originalItems.length) {
                    this.error(8);
                }
                nArray[n++] = n4;
                ++n3;
            }
            ++n2;
        }
        return nArray;
    }

    void setItemOrder(int[] nArray) {
        int n;
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length != (n = this.originalItems.length)) {
            this.error(5);
        }
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < blArray.length) {
            blArray[n2] = false;
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] < 0 || nArray[n2] >= n) {
                this.error(5);
            }
            if (blArray[nArray[n2]]) {
                this.error(5);
            }
            blArray[nArray[n2]] = true;
            ++n2;
        }
        CoolItem[] coolItemArray = new CoolItem[n];
        int n3 = 0;
        while (n3 < n) {
            coolItemArray[n3] = this.originalItems[nArray[n3]];
            ++n3;
        }
        this.items = new CoolItem[1][n];
        this.items[0] = coolItemArray;
    }

    public Point[] getItemSizes() {
        this.checkWidget();
        CoolItem[] coolItemArray = this.getItems();
        Point[] pointArray = new Point[coolItemArray.length];
        int n = 0;
        while (n < coolItemArray.length) {
            pointArray[n] = coolItemArray[n].getSize();
            ++n;
        }
        return pointArray;
    }

    void setItemSizes(Point[] pointArray) {
        CoolItem[] coolItemArray;
        if (pointArray == null) {
            this.error(4);
        }
        if (pointArray.length != (coolItemArray = this.getItems()).length) {
            this.error(5);
        }
        int n = 0;
        while (n < coolItemArray.length) {
            coolItemArray[n].setSize(pointArray[n]);
            ++n;
        }
    }

    public boolean getLocked() {
        this.checkWidget();
        return this.isLocked;
    }

    int getWidth() {
        if ((this.style & 0x200) != 0) {
            return this.getSize().y;
        }
        return this.getSize().x;
    }

    public int[] getWrapIndices() {
        this.checkWidget();
        if (this.items.length <= 1) {
            return new int[0];
        }
        int[] nArray = new int[this.items.length - 1];
        int n = 0;
        int n2 = this.items[0].length;
        int n3 = 1;
        while (n3 < this.items.length) {
            if (this.items[n3][0].wrap) {
                nArray[n++] = n2;
            }
            n2 += this.items[n3].length;
            ++n3;
        }
        if (n != nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            return nArray2;
        }
        return nArray;
    }

    public void setLocked(boolean bl) {
        this.checkWidget();
        if (this.isLocked != bl) {
            this.redraw();
        }
        this.isLocked = bl;
    }

    public void setWrapIndices(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            nArray = new int[]{};
        }
        int n = this.originalItems.length;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] < 0 || nArray[n2] >= n) {
                this.error(5);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.originalItems.length) {
            this.originalItems[n2].wrap = false;
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            int n4 = 0;
            while (n4 < this.items.length) {
                if (this.items[n4].length > n3) {
                    this.items[n4][n3].wrap = true;
                    break;
                }
                n3 -= this.items[n4].length;
                ++n4;
            }
            ++n2;
        }
        this.relayout();
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        this.cursor = cursor;
        super.setCursor(this.cursor);
    }

    public void setItemLayout(int[] nArray, int[] nArray2, Point[] pointArray) {
        this.checkWidget();
        this.setItemOrder(nArray);
        this.setWrapIndices(nArray2);
        this.setItemSizes(pointArray);
        this.relayout();
    }

    void wrapItems(int n) {
        int n2 = this.originalItems.length;
        if (n2 < 2) {
            return;
        }
        CoolItem[] coolItemArray = new CoolItem[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.items.length) {
            System.arraycopy(this.items[n4], 0, coolItemArray, n3, this.items[n4].length);
            n3 += this.items[n4].length;
            ++n4;
        }
        CoolItem[][] coolItemArrayArray = new CoolItem[n2][];
        int n5 = 0;
        int n6 = 0;
        n3 = 0;
        int n7 = 0;
        while (n7 < n2) {
            CoolItem coolItem = coolItemArray[n7];
            int n8 = coolItem.internalGetMinimumWidth();
            if (n7 > 0 && coolItem.wrap || n != -1 && n6 + n8 > n) {
                if (n7 == n3) {
                    coolItemArrayArray[n5] = new CoolItem[1];
                    coolItemArrayArray[n5][0] = coolItem;
                    n3 = n7 + 1;
                    n6 = 0;
                } else {
                    int n9 = n7 - n3;
                    coolItemArrayArray[n5] = new CoolItem[n9];
                    System.arraycopy(coolItemArray, n3, coolItemArrayArray[n5], 0, n9);
                    n3 = n7;
                    n6 = n8;
                }
                ++n5;
            } else {
                n6 += n8;
            }
            ++n7;
        }
        if (n3 < n2) {
            n7 = n2 - n3;
            coolItemArrayArray[n5] = new CoolItem[n7];
            System.arraycopy(coolItemArray, n3, coolItemArrayArray[n5], 0, n7);
            ++n5;
        }
        if (coolItemArrayArray.length != n5) {
            CoolItem[][] coolItemArrayArray2 = new CoolItem[n5][];
            System.arraycopy(coolItemArrayArray, 0, coolItemArrayArray2, 0, n5);
            this.items = coolItemArrayArray2;
        } else {
            this.items = coolItemArrayArray;
        }
    }
}

