/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Item;

public class ExpandItem
extends Item {
    ExpandBar parent;
    Control control;
    boolean expanded;
    int x;
    int y;
    int width;
    int height;
    int imageHeight;
    int imageWidth;
    static final int TEXT_INSET = 6;
    static final int BORDER = 1;
    static final int CHEVRON_SIZE = 24;

    public ExpandItem(ExpandBar expandBar, int n) {
        this(expandBar, n, ExpandItem.checkNull(expandBar).getItemCount());
    }

    public ExpandItem(ExpandBar expandBar, int n, int n2) {
        super(expandBar, n);
        this.parent = expandBar;
        expandBar.createItem(this, n, n2);
    }

    static ExpandBar checkNull(ExpandBar expandBar) {
        if (expandBar == null) {
            SWT.error(4);
        }
        return expandBar;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.parent.destroyItem(this);
        super.dispose();
        this.parent = null;
        this.control = null;
    }

    void drawChevron(GC gC, int n, int n2) {
        int[] nArray;
        int[] nArray2;
        if (this.expanded) {
            int n3 = n + 4 + 5;
            int n4 = n2 + 4 + 7;
            nArray2 = new int[]{n3, n4, n3 + 1, n4, n3 + 1, n4 - 1, n3 + 2, n4 - 1, n3 + 2, n4 - 2, n3 + 3, n4 - 2, n3 + 3, n4 - 3, n3 + 3, n4 - 2, n3 + 4, n4 - 2, n3 + 4, n4 - 1, n3 + 5, n4 - 1, n3 + 5, n4, n3 + 6, n4};
            nArray = new int[]{n3, n4 += 4, n3 + 1, n4, n3 + 1, n4 - 1, n3 + 2, n4 - 1, n3 + 2, n4 - 2, n3 + 3, n4 - 2, n3 + 3, n4 - 3, n3 + 3, n4 - 2, n3 + 4, n4 - 2, n3 + 4, n4 - 1, n3 + 5, n4 - 1, n3 + 5, n4, n3 + 6, n4};
        } else {
            int n5 = n + 4 + 5;
            int n6 = n2 + 4 + 4;
            nArray2 = new int[]{n5, n6, n5 + 1, n6, n5 + 1, n6 + 1, n5 + 2, n6 + 1, n5 + 2, n6 + 2, n5 + 3, n6 + 2, n5 + 3, n6 + 3, n5 + 3, n6 + 2, n5 + 4, n6 + 2, n5 + 4, n6 + 1, n5 + 5, n6 + 1, n5 + 5, n6, n5 + 6, n6};
            nArray = new int[]{n5, n6 += 4, n5 + 1, n6, n5 + 1, n6 + 1, n5 + 2, n6 + 1, n5 + 2, n6 + 2, n5 + 3, n6 + 2, n5 + 3, n6 + 3, n5 + 3, n6 + 2, n5 + 4, n6 + 2, n5 + 4, n6 + 1, n5 + 5, n6 + 1, n5 + 5, n6, n5 + 6, n6};
        }
        gC.setForeground(this.display.getSystemColor(30));
        gC.drawPolyline(nArray2);
        gC.drawPolyline(nArray);
    }

    void drawItem(GC gC, boolean bl) {
        int n = this.parent.getBandHeight();
        Display display = this.getDisplay();
        gC.setForeground(display.getSystemColor(31));
        gC.setBackground(display.getSystemColor(32));
        gC.fillGradientRectangle(this.x, this.y, this.width, n, true);
        if (this.expanded) {
            gC.setForeground(display.getSystemColor(32));
            gC.drawLine(this.x, this.y + n, this.x, this.y + n + this.height - 1);
            gC.drawLine(this.x, this.y + n + this.height - 1, this.x + this.width - 1, this.y + n + this.height - 1);
            gC.drawLine(this.x + this.width - 1, this.y + n + this.height - 1, this.x + this.width - 1, this.y + n);
        }
        int n2 = this.x;
        if (this.image != null) {
            n2 += 6;
            if (this.imageHeight > n) {
                gC.drawImage(this.image, n2, this.y + n - this.imageHeight);
            } else {
                gC.drawImage(this.image, n2, this.y + (n - this.imageHeight) / 2);
            }
            n2 += this.imageWidth;
        }
        if (this.text.length() > 0) {
            Point point = gC.stringExtent(this.text);
            gC.setForeground(this.parent.getForeground());
            gC.drawString(this.text, n2 += 6, this.y + (n - point.y) / 2, true);
        }
        int n3 = 24;
        this.drawChevron(gC, this.x + this.width - n3, this.y + (n - n3) / 2);
        if (bl) {
            gC.drawFocus(this.x + 1, this.y + 1, this.width - 2, n - 2);
        }
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return Math.max(this.parent.getBandHeight(), this.imageHeight);
    }

    public int getHeight() {
        this.checkWidget();
        return this.height;
    }

    public ExpandBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getPreferredWidth(GC gC) {
        int n = 36;
        if (this.image != null) {
            n += 6 + this.imageWidth;
        }
        if (this.text.length() > 0) {
            n += gC.stringExtent((String)this.text).x;
        }
        return n;
    }

    void redraw() {
        int n = this.parent.getBandHeight();
        if (this.imageHeight > n) {
            this.parent.redraw(this.x + 6, this.y + n - this.imageHeight, this.imageWidth, this.imageHeight, false);
        }
        this.parent.redraw(this.x, this.y, this.width, n + this.height, false);
    }

    void setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.redraw();
        int n5 = this.parent.getBandHeight();
        if (bl) {
            if (this.imageHeight > n5) {
                n2 += this.imageHeight - n5;
            }
            this.x = n;
            this.y = n2;
            this.redraw();
        }
        if (bl2) {
            this.width = n3;
            this.height = n4;
            this.redraw();
        }
        if (this.control != null && !this.control.isDisposed()) {
            if (bl) {
                this.control.setLocation(n + 1, n2 + n5);
            }
            if (bl2) {
                this.control.setSize(Math.max(0, n3 - 2), Math.max(0, n4 - 1));
            }
        }
    }

    public void setControl(Control control2) {
        this.checkWidget();
        if (control2 != null) {
            if (control2.isDisposed()) {
                this.error(5);
            }
            if (control2.parent != this.parent) {
                this.error(32);
            }
        }
        this.control = control2;
        if (control2 != null) {
            control2.setVisible(this.expanded);
            int n = this.parent.getBandHeight();
            control2.setBounds(this.x + 1, this.y + n, Math.max(0, this.width - 2), Math.max(0, this.height - 1));
        }
    }

    public void setExpanded(boolean bl) {
        this.checkWidget();
        this.expanded = bl;
        this.parent.showItem(this);
    }

    public void setImage(Image image) {
        super.setImage(image);
        int n = this.imageHeight;
        if (image != null) {
            Rectangle rectangle = image.getBounds();
            this.imageHeight = rectangle.height;
            this.imageWidth = rectangle.width;
        } else {
            this.imageWidth = 0;
            this.imageHeight = 0;
        }
        if (n != this.imageHeight) {
            this.parent.layoutItems(this.parent.indexOf(this), true);
        } else {
            this.redraw();
        }
    }

    public void setHeight(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.setBounds(0, 0, this.width, n, false, true);
        if (this.expanded) {
            this.parent.layoutItems(this.parent.indexOf(this) + 1, true);
        }
    }

    public void setText(String string) {
        super.setText(string);
        this.redraw();
    }
}

