/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.internal.DefaultStackPresentationSite;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.presentations.SystemMenuFastView;
import org.eclipse.ui.internal.presentations.SystemMenuFastViewOrientation;
import org.eclipse.ui.internal.presentations.SystemMenuSizeFastView;
import org.eclipse.ui.internal.presentations.UpdatingActionContributionItem;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.StackPresentation;

public class FastViewPane {
    private int side = 16384;
    private ViewPane currentPane;
    private Composite clientComposite;
    private static final int SASH_SIZE = 3;
    private int minSize = 10;
    private int size;
    private Sash sash;
    private Listener escapeListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.character == '\u001b' && FastViewPane.this.currentPane != null) {
                FastViewPane.this.currentPane.getPage().hideFastView();
            }
        }
    };
    private DefaultStackPresentationSite site = new DefaultStackPresentationSite(){

        public void setState(int newState) {
            super.setState(newState);
            ViewPane pane = FastViewPane.this.currentPane;
            switch (newState) {
                case 0: {
                    FastViewPane.this.currentPane.getPage().hideFastView();
                    break;
                }
                case 1: {
                    pane.setZoomed(true);
                    FastViewPane.this.sash.setVisible(false);
                    this.getPresentation().setBounds(FastViewPane.this.getBounds());
                    break;
                }
                case 2: {
                    pane.setZoomed(false);
                    FastViewPane.this.sash.setVisible(true);
                    this.getPresentation().setBounds(FastViewPane.this.getBounds());
                }
            }
        }

        public void flushLayout() {
        }

        public void close(IPresentablePart part) {
            if (!this.isCloseable(part)) {
                return;
            }
            FastViewPane.this.currentPane.getPage().hideView(FastViewPane.this.currentPane.getViewReference());
        }

        public void close(IPresentablePart[] parts) {
            int idx = 0;
            while (idx < parts.length) {
                this.close(parts[idx]);
                ++idx;
            }
        }

        public void dragStart(IPresentablePart beingDragged, Point initialPosition, boolean keyboard) {
            this.dragStart(initialPosition, keyboard);
        }

        public void dragStart(Point initialPosition, boolean keyboard) {
            if (!this.isPartMoveable()) {
                return;
            }
            ViewPane pane = FastViewPane.this.currentPane;
            Control control2 = this.getPresentation().getControl();
            Rectangle bounds = Geometry.toDisplay(FastViewPane.this.clientComposite, control2.getBounds());
            WorkbenchPage page = FastViewPane.this.currentPane.getPage();
            page.getActivePerspective();
            page.hideFastView();
            if (page.isZoomed()) {
                page.zoomOut();
            }
            DragUtil.performDrag(pane, bounds, initialPosition, !keyboard);
        }

        public IPresentablePart getSelectedPart() {
            if (FastViewPane.this.currentPane == null) {
                return null;
            }
            return FastViewPane.this.currentPane.getPresentablePart();
        }

        public void addSystemActions(IMenuManager menuManager) {
            FastViewPane.appendToGroupIfPossible(menuManager, "misc", new SystemMenuFastViewOrientation(FastViewPane.this.currentPane));
            FastViewPane.appendToGroupIfPossible(menuManager, "misc", new UpdatingActionContributionItem(FastViewPane.this.fastViewAction));
            FastViewPane.appendToGroupIfPossible(menuManager, "size", new SystemMenuSizeFastView(FastViewPane.this));
        }

        public boolean isPartMoveable(IPresentablePart toMove) {
            return this.isPartMoveable();
        }

        public boolean isStackMoveable() {
            return this.isPartMoveable();
        }

        private boolean isPartMoveable() {
            if (FastViewPane.this.currentPane == null) {
                return false;
            }
            Perspective perspective = FastViewPane.this.currentPane.getPage().getActivePerspective();
            if (perspective == null) {
                return false;
            }
            return perspective.isMoveable(FastViewPane.this.currentPane.getViewReference());
        }

        public boolean supportsState(int newState) {
            if (FastViewPane.this.currentPane == null) {
                return false;
            }
            return !FastViewPane.this.currentPane.getPage().isFixedLayout();
        }

        public IPresentablePart[] getPartList() {
            return new IPresentablePart[]{this.getSelectedPart()};
        }
    };
    private SystemMenuFastView fastViewAction = new SystemMenuFastView(this.site);
    private Listener mouseDownListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.widget instanceof Control) {
                Point pt;
                ToolBar toolBar;
                Control control2 = (Control)event.widget;
                if (control2.getShell() != FastViewPane.this.clientComposite.getShell()) {
                    return;
                }
                if (event.widget instanceof ToolBar && (toolBar = (ToolBar)event.widget).getItem(pt = new Point(event.x, event.y)) != null) {
                    return;
                }
                Point loc = DragUtil.getEventLoc(event);
                Rectangle bounds = DragUtil.getDisplayBounds(FastViewPane.this.clientComposite);
                if (FastViewPane.this.site.getState() != 1) {
                    bounds = Geometry.getExtrudedEdge(bounds, FastViewPane.this.size + 3, FastViewPane.this.side);
                }
                if (!bounds.contains(loc)) {
                    FastViewPane.this.site.setState(0);
                }
            }
        }
    };
    private IContributionItem systemMenuContribution;
    private Listener resizeListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 11 && FastViewPane.this.currentPane != null) {
                FastViewPane.this.setSize(FastViewPane.this.size);
            }
        }
    };
    private SelectionAdapter selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (FastViewPane.this.currentPane != null) {
                Rectangle bounds = FastViewPane.this.clientComposite.getClientArea();
                Point location = new Point(e.x, e.y);
                int distanceFromEdge = Geometry.getDistanceFromEdge(bounds, location, FastViewPane.this.side);
                if (FastViewPane.this.side != 128 && FastViewPane.this.side != 16384) {
                    distanceFromEdge -= 3;
                }
                FastViewPane.this.setSize(distanceFromEdge);
                if (e.detail != 1) {
                    FastViewPane.this.updateFastViewSashBounds();
                    FastViewPane.this.sash.redraw();
                }
            }
        }
    };

    private static void appendToGroupIfPossible(IMenuManager m, String groupId, ContributionItem item) {
        try {
            m.appendToGroup(groupId, item);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            m.add(item);
        }
    }

    public void moveSash() {
        final KeyAdapter listener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b' || e.character == '\r') {
                    FastViewPane.this.currentPane.setFocus();
                }
            }
        };
        this.sash.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                FastViewPane.this.sash.setBackground(FastViewPane.this.sash.getDisplay().getSystemColor(26));
                FastViewPane.this.sash.addKeyListener(listener);
            }

            public void focusLost(FocusEvent e) {
                FastViewPane.this.sash.setBackground((Color)null);
                FastViewPane.this.sash.removeKeyListener(listener);
            }
        });
        this.sash.setFocus();
    }

    private void setSize(int size) {
        if (size < this.minSize) {
            size = this.minSize;
        }
        this.size = size;
        StackPresentation presentation = this.getPresentation();
        if (presentation == null || presentation.getControl().isDisposed()) {
            return;
        }
        this.getPresentation().setBounds(this.getBounds());
        this.updateFastViewSashBounds();
    }

    public float getCurrentRatio() {
        if (this.currentPane == null) {
            return 0.0f;
        }
        boolean isVertical = !Geometry.isHorizontal(this.side);
        Rectangle clientArea = this.clientComposite.getClientArea();
        int clientSize = Geometry.getDimension(clientArea, isVertical);
        return (float)this.size / (float)clientSize;
    }

    private Rectangle getClientArea() {
        return this.clientComposite.getClientArea();
    }

    private Rectangle getBounds() {
        Rectangle bounds = this.getClientArea();
        if (this.site.getState() == 1) {
            return bounds;
        }
        boolean horizontal = Geometry.isHorizontal(this.side);
        int available = Geometry.getDimension(bounds, !horizontal);
        return Geometry.getExtrudedEdge(bounds, Math.min(this.size, available), this.side);
    }

    public void showView(Composite newClientComposite, ViewPane pane, int newSide, float sizeRatio) {
        this.side = newSide;
        if (this.currentPane != null) {
            this.hideView();
        }
        this.currentPane = pane;
        this.fastViewAction.setPane(this.currentPane);
        this.clientComposite = newClientComposite;
        this.clientComposite.addListener(11, this.resizeListener);
        Control ctrl = pane.getControl();
        if (ctrl == null) {
            pane.createControl(this.clientComposite);
            ctrl = pane.getControl();
        }
        ctrl.addListener(31, this.escapeListener);
        AbstractPresentationFactory factory = ((WorkbenchWindow)pane.getWorkbenchWindow()).getWindowConfigurer().getPresentationFactory();
        StackPresentation presentation = factory.createViewPresentation(newClientComposite, this.site);
        this.site.setPresentation(presentation);
        this.site.setPresentationState(2);
        presentation.addPart(pane.getPresentablePart(), null);
        presentation.selectPart(pane.getPresentablePart());
        presentation.setActive(1);
        presentation.setVisible(true);
        boolean horizontalResize = Geometry.isHorizontal(this.side);
        this.minSize = presentation.computePreferredSize(horizontalResize, Integer.MAX_VALUE, Geometry.getDimension(this.getClientArea(), horizontalResize), 0);
        ctrl.setEnabled(true);
        Composite parent = ctrl.getParent();
        pane.setFocus();
        boolean horizontal = Geometry.isHorizontal(this.side);
        this.sash = new Sash(parent, Geometry.getSwtHorizontalOrVerticalConstant(horizontal));
        this.sash.addSelectionListener(this.selectionListener);
        Rectangle clientArea = newClientComposite.getClientArea();
        this.getPresentation().getControl().moveAbove(null);
        this.currentPane.moveAbove(null);
        this.sash.moveAbove(null);
        this.setSize((int)((float)Geometry.getDimension(clientArea, !horizontal) * sizeRatio));
        Display display = this.sash.getDisplay();
        display.addFilter(3, this.mouseDownListener);
    }

    private void updateFastViewSashBounds() {
        Rectangle oldBounds;
        int oppositeSide;
        Rectangle bounds = this.getBounds();
        Rectangle newBounds = Geometry.getExtrudedEdge(bounds, -3, oppositeSide = Geometry.getOppositeSide(this.side));
        if (!newBounds.equals(oldBounds = this.sash.getBounds())) {
            this.sash.setBounds(newBounds);
        }
    }

    public void dispose() {
        this.hideView();
    }

    private Rectangle getFastViewBounds() {
        Rectangle clientArea = this.clientComposite.getClientArea();
        boolean isVertical = !Geometry.isHorizontal(this.side);
        int clientSize = Geometry.getDimension(clientArea, isVertical);
        int viewSize = Math.min(Geometry.getDimension(this.getBounds(), isVertical), clientSize - this.minSize);
        return Geometry.getExtrudedEdge(clientArea, viewSize, this.side);
    }

    private StackPresentation getPresentation() {
        return this.site.getPresentation();
    }

    public void hideFastViewSash() {
        if (this.sash != null) {
            this.sash.setVisible(false);
        }
    }

    public void hideView() {
        if (this.clientComposite != null) {
            Display display = this.clientComposite.getDisplay();
            display.removeFilter(3, this.mouseDownListener);
        }
        if (this.currentPane == null) {
            return;
        }
        this.fastViewAction.setPane(null);
        this.currentPane.setZoomed(false);
        if (this.sash != null) {
            this.sash.dispose();
            this.sash = null;
        }
        this.clientComposite.removeListener(11, this.resizeListener);
        Control ctrl = this.currentPane.getControl();
        ctrl.removeListener(31, this.escapeListener);
        this.getPresentation().setVisible(false);
        this.site.dispose();
        ctrl.setEnabled(false);
        this.currentPane = null;
    }

    public ViewPane getCurrentPane() {
        return this.currentPane;
    }

    public void setState(int newState) {
        this.site.setState(newState);
    }

    public int getState() {
        return this.site.getState();
    }

    public void showSystemMenu() {
        this.getPresentation().showSystemMenu();
    }
}

