/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.dnd.SwtUtil;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.part.MultiEditor;
import org.eclipse.ui.presentations.IPresentablePart;

public abstract class PartPane
extends LayoutPart
implements Listener {
    protected PresentablePart presentableAdapter = new PresentablePart(this);
    public static final String PROP_ZOOMED = "zoomed";
    private boolean isZoomed = false;
    private MenuManager paneMenuManager;
    protected IWorkbenchPartReference partReference;
    protected WorkbenchPage page;
    protected Composite control;
    private boolean inLayout = true;
    private TraverseListener traverseListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent e) {
            LayoutPart parent;
            Control parentControl;
            ILayoutContainer container;
            if ((e.detail == 512 || e.detail == 256) && (container = PartPane.this.getContainer()) != null && container instanceof LayoutPart && (parentControl = (parent = (LayoutPart)((Object)container)).getControl()) != null && !parentControl.isDisposed()) {
                e.doit = parentControl.traverse(e.detail);
                if (e.doit) {
                    e.detail = 0;
                }
            }
        }
    };

    public PartPane(IWorkbenchPartReference partReference, WorkbenchPage workbenchPage) {
        super(partReference.getId());
        this.partReference = partReference;
        this.page = workbenchPage;
    }

    public void addSizeMenuItem(Menu menu, int index) {
        MenuItem item = new MenuItem(menu, 64, index);
        item.setText(WorkbenchMessages.PartPane_size);
        Menu sizeMenu = new Menu(menu);
        item.setMenu(sizeMenu);
        this.addSizeItems(sizeMenu);
    }

    public void createControl(Composite parent) {
        if (this.getControl() != null) {
            return;
        }
        this.control = new Composite(parent, 0);
        this.control.setLayout(new FillLayout());
        this.control.setVisible(false);
        this.createTitleBar();
        this.control.addListener(26, this);
        this.control.addTraverseListener(this.traverseListener);
    }

    protected abstract void createTitleBar();

    public void dispose() {
        super.dispose();
        if (this.control != null && !this.control.isDisposed()) {
            this.control.removeListener(26, this);
            this.control.removeTraverseListener(this.traverseListener);
            this.control.dispose();
            this.control = null;
        }
        if (this.paneMenuManager != null) {
            this.paneMenuManager.dispose();
            this.paneMenuManager = null;
        }
    }

    public abstract void doHide();

    protected void doZoom() {
        if (this.isDocked()) {
            this.page.toggleZoom(this.partReference);
        }
    }

    public Rectangle getBounds() {
        return this.getControl().getBounds();
    }

    public Control getControl() {
        return this.control;
    }

    public IWorkbenchPartReference getPartReference() {
        return this.partReference;
    }

    public void handleEvent(Event event) {
        if (event.type == 26 && this.inLayout) {
            this.requestActivation();
        }
    }

    public boolean isZoomed() {
        return this.isZoomed;
    }

    public void moveAbove(Control refControl) {
        if (this.getControl() != null) {
            this.getControl().moveAbove(refControl);
        }
    }

    public void requestActivation() {
        IWorkbenchPart part = this.partReference.getPart(true);
        if (part instanceof MultiEditor) {
            return;
        }
        this.page.requestActivation(part);
    }

    public void setContainer(ILayoutContainer container) {
        LayoutPart part;
        Control containerControl;
        if (container instanceof LayoutPart && (containerControl = (part = (LayoutPart)((Object)container)).getControl()) != null) {
            Control control2 = this.getControl();
            Composite newParent = containerControl.getParent();
            if (control2 != null && newParent != control2.getParent()) {
                this.reparent(newParent);
            }
        }
        super.setContainer(container);
    }

    public void setVisible(boolean makeVisible) {
        if (makeVisible == this.getVisible()) {
            return;
        }
        if (makeVisible) {
            this.partReference.getPart(true);
        }
        super.setVisible(makeVisible);
        ((WorkbenchPartReference)this.partReference).fireVisibilityChange();
    }

    public void setFocus() {
        Control control2;
        this.requestActivation();
        IWorkbenchPart part = this.partReference.getPart(true);
        if (part != null && !SwtUtil.isFocusAncestor(control2 = this.getControl())) {
            part.setFocus();
        }
    }

    public void setWorkbenchPage(WorkbenchPage workbenchPage) {
        this.page = workbenchPage;
    }

    public void setZoomed(boolean isZoomed) {
        if (this.isZoomed == isZoomed) {
            return;
        }
        super.setZoomed(isZoomed);
        this.isZoomed = isZoomed;
        ((WorkbenchPartReference)this.partReference).fireZoomChange();
    }

    abstract void shellActivated();

    abstract void shellDeactivated();

    public abstract void showFocus(boolean var1);

    public LayoutPart targetPartFor(LayoutPart dragSource) {
        return this;
    }

    public PartStack getStack() {
        ILayoutContainer container = this.getContainer();
        if (container instanceof PartStack) {
            return (PartStack)container;
        }
        return null;
    }

    public void showPaneMenu() {
        PartStack folder = this.getStack();
        if (folder != null) {
            folder.showSystemMenu();
        }
    }

    public void showViewMenu() {
        PartStack folder = this.getStack();
        if (folder != null) {
            folder.showPaneMenu();
        }
    }

    protected Sashes findSashes() {
        Sashes result = new Sashes();
        ILayoutContainer container = this.getContainer();
        if (container == null) {
            return result;
        }
        container.findSashes(this, result);
        return result;
    }

    protected void moveSash(Sash sash) {
        PartPane.moveSash(sash, this);
    }

    public static void moveSash(final Sash sash, final LayoutPart toGetFocusWhenDone) {
        final KeyAdapter listener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.character == '\u001b' || e.character == '\r') && toGetFocusWhenDone != null) {
                    toGetFocusWhenDone.setFocus();
                }
            }
        };
        sash.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                sash.setBackground(sash.getDisplay().getSystemColor(26));
                sash.addKeyListener(listener);
            }

            public void focusLost(FocusEvent e) {
                sash.setBackground((Color)null);
                sash.removeKeyListener(listener);
            }
        });
        sash.setFocus();
    }

    protected void addSizeItem(Menu sizeMenu, String labelMessage, final Sash sash) {
        MenuItem item = new MenuItem(sizeMenu, 0);
        item.setText(labelMessage);
        item.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartPane.this.moveSash(sash);
            }
        });
        item.setEnabled(!this.isZoomed() && sash != null);
    }

    public WorkbenchPage getPage() {
        return this.page;
    }

    protected void addSizeItems(Menu sizeMenu) {
        Sashes sashes = this.findSashes();
        this.addSizeItem(sizeMenu, WorkbenchMessages.PartPane_sizeLeft, sashes.left);
        this.addSizeItem(sizeMenu, WorkbenchMessages.PartPane_sizeRight, sashes.right);
        this.addSizeItem(sizeMenu, WorkbenchMessages.PartPane_sizeTop, sashes.top);
        this.addSizeItem(sizeMenu, WorkbenchMessages.PartPane_sizeBottom, sashes.bottom);
    }

    protected void doDock() {
    }

    public void setBusy(boolean isBusy) {
    }

    public void showHighlight() {
    }

    public void reparent(Composite newParent) {
        super.reparent(newParent);
    }

    public abstract Control getToolBar();

    public boolean hasViewMenu() {
        return false;
    }

    public void showViewMenu(Point location) {
    }

    public boolean isBusy() {
        return false;
    }

    public IPresentablePart getPresentablePart() {
        return this.presentableAdapter;
    }

    public abstract boolean isCloseable();

    public void setInLayout(boolean inLayout) {
        this.inLayout = inLayout;
    }

    public boolean getInLayout() {
        return this.inLayout;
    }

    public boolean allowsAutoFocus() {
        if (!this.inLayout) {
            return false;
        }
        return super.allowsAutoFocus();
    }

    public void removeContributions() {
    }

    public static class Sashes {
        public Sash left;
        public Sash right;
        public Sash top;
        public Sash bottom;
    }
}

