/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.WorkbenchPlugin;

public final class ContextActivation
implements IContextActivation {
    private final String contextId;
    private final IContextService contextService;
    private EvaluationResult evaluationResult = null;
    private final Expression expression;
    private final int sourcePriority;

    public ContextActivation(String contextId, Expression expression, int sourcePriority, IContextService contextService) {
        if (contextId == null) {
            throw new NullPointerException("The context identifier for a context activation cannot be null");
        }
        if (contextService == null) {
            throw new NullPointerException("The context service for an activation cannot be null");
        }
        this.contextId = contextId;
        this.expression = expression;
        this.sourcePriority = sourcePriority;
        this.contextService = contextService;
    }

    public final void clearActive() {
        this.evaluationResult = null;
    }

    public final String getContextId() {
        return this.contextId;
    }

    public final IContextService getContextService() {
        return this.contextService;
    }

    public final int getSourcePriority() {
        return this.sourcePriority;
    }

    public final boolean isActive(IEvaluationContext context) {
        if (this.expression == null) {
            return true;
        }
        if (this.evaluationResult == null) {
            try {
                this.evaluationResult = this.expression.evaluate(context);
            }
            catch (CoreException e) {
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, e.getMessage(), e);
                WorkbenchPlugin.log("Could not evaluate an expression", status);
                return false;
            }
        }
        return this.evaluationResult == EvaluationResult.TRUE;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ContextActivation(contextId=");
        buffer.append(this.contextId);
        buffer.append(",expression=");
        buffer.append(this.expression);
        buffer.append(",sourcePriority=");
        buffer.append(this.sourcePriority);
        buffer.append(",evaluationResult=");
        buffer.append(this.evaluationResult);
        buffer.append(')');
        return buffer.toString();
    }
}

