/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.progress.AbstractProgressViewer;

public class ProgressViewer
extends AbstractProgressViewer {
    Canvas canvas;
    Object[] displayedItems = new Object[0];
    private static final List EMPTY_LIST = new ArrayList();
    private FontMetrics fontMetrics;
    private int numShowItems = 1;
    private int maxCharacterWidth;

    ProgressViewer(Composite parent, int style, int itemsToShow, int numChars) {
        this.numShowItems = itemsToShow;
        this.maxCharacterWidth = numChars;
        this.canvas = new Canvas(parent, style);
        this.hookControl(this.canvas);
        GC gc = new GC(this.canvas);
        gc.setFont(JFaceResources.getDefaultFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        this.initializeListeners();
    }

    protected void hookControl(Control control2) {
        control2.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ProgressViewer.this.handleDispose(event);
            }
        });
    }

    protected Widget doFindInputItem(Object element) {
        return null;
    }

    protected Widget doFindItem(Object element) {
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        this.canvas.redraw();
    }

    protected List getSelectionFromWidget() {
        return EMPTY_LIST;
    }

    protected void internalRefresh(Object element) {
        this.displayedItems = this.getSortedChildren(this.getRoot());
        this.canvas.redraw();
    }

    public void reveal(Object element) {
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
    }

    public Control getControl() {
        return this.canvas;
    }

    private void initializeListeners() {
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                GC gc = event.gc;
                ILabelProvider labelProvider = (ILabelProvider)ProgressViewer.this.getLabelProvider();
                int itemCount = Math.min(ProgressViewer.this.displayedItems.length, ProgressViewer.this.numShowItems);
                int yOffset = 0;
                if (ProgressViewer.this.numShowItems == 1) {
                    Rectangle clientArea = ProgressViewer.this.canvas.getParent().getClientArea();
                    int size = clientArea.height;
                    yOffset = size - ProgressViewer.this.fontMetrics.getHeight();
                    yOffset /= 2;
                }
                int i = 0;
                while (i < itemCount) {
                    String string = labelProvider.getText(ProgressViewer.this.displayedItems[i]);
                    if (string == null) {
                        string = "";
                    }
                    gc.drawString(string, 2, yOffset + i * ProgressViewer.this.fontMetrics.getHeight(), true);
                    ++i;
                }
            }
        });
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue(labelProvider instanceof ILabelProvider);
        super.setLabelProvider(labelProvider);
    }

    public Point getSizeHints() {
        Display display = this.canvas.getDisplay();
        GC gc = new GC((Drawable)display);
        FontMetrics fm = gc.getFontMetrics();
        int charWidth = fm.getAverageCharWidth();
        int charHeight = fm.getHeight();
        int maxWidth = display.getBounds().width / 2;
        int maxHeight = display.getBounds().height / 6;
        int fontWidth = charWidth * this.maxCharacterWidth;
        int fontHeight = charHeight * this.numShowItems;
        if (maxWidth < fontWidth) {
            fontWidth = maxWidth;
        }
        if (maxHeight < fontHeight) {
            fontHeight = maxHeight;
        }
        gc.dispose();
        return new Point(fontWidth, fontHeight);
    }
}

