/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.part.IWorkbenchPartOrientation;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class WorkbenchPart
implements IWorkbenchPart2,
IExecutableExtension,
IWorkbenchPartOrientation {
    private String title = "";
    private ImageDescriptor imageDescriptor;
    private Image titleImage;
    private String toolTip = "";
    private IConfigurationElement configElement;
    private IWorkbenchPartSite partSite;
    private ListenerList propChangeListeners = new ListenerList(2);
    private String partName = "";
    private String contentDescription = "";

    protected WorkbenchPart() {
    }

    public void addPropertyListener(IPropertyListener l) {
        this.propChangeListeners.add(l);
    }

    public abstract void createPartControl(Composite var1);

    public void dispose() {
        if (this.imageDescriptor != null) {
            JFaceResources.getResources().destroyImage(this.imageDescriptor);
        }
        if (!this.propChangeListeners.isEmpty()) {
            this.propChangeListeners = new ListenerList(1);
        }
    }

    protected void firePropertyChange(int propertyId) {
        Object[] array = this.propChangeListeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            IPropertyListener l = (IPropertyListener)array[nX];
            try {
                l.propertyChanged(this, propertyId);
            }
            catch (RuntimeException e) {
                WorkbenchPlugin.log(e);
            }
            ++nX;
        }
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    protected Image getDefaultImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW");
    }

    public IWorkbenchPartSite getSite() {
        return this.partSite;
    }

    public String getTitle() {
        return this.title;
    }

    public Image getTitleImage() {
        if (this.titleImage != null) {
            return this.titleImage;
        }
        return this.getDefaultImage();
    }

    public String getTitleToolTip() {
        return this.toolTip;
    }

    public void removePropertyListener(IPropertyListener l) {
        this.propChangeListeners.remove(l);
    }

    public abstract void setFocus();

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
        this.title = this.partName = Util.safeString(cfig.getAttribute("name"));
        String strIcon = cfig.getAttribute("icon");
        if (strIcon == null) {
            return;
        }
        this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(this.configElement.getNamespace(), strIcon);
        if (this.imageDescriptor == null) {
            return;
        }
        this.titleImage = JFaceResources.getResources().createImageWithDefault(this.imageDescriptor);
    }

    protected void setSite(IWorkbenchPartSite site) {
        this.checkSite(site);
        this.partSite = site;
    }

    protected void checkSite(IWorkbenchPartSite site) {
    }

    protected void setTitle(String title) {
        if (Util.equals(this.title, title = Util.safeString(title))) {
            return;
        }
        this.title = title;
        this.firePropertyChange(1);
    }

    protected void setTitleImage(Image titleImage) {
        Assert.isTrue(titleImage == null || !titleImage.isDisposed());
        if (this.titleImage == titleImage) {
            return;
        }
        this.titleImage = titleImage;
        this.firePropertyChange(1);
        if (this.imageDescriptor != null) {
            JFaceResources.getResources().destroyImage(this.imageDescriptor);
            this.imageDescriptor = null;
        }
    }

    protected void setTitleToolTip(String toolTip) {
        if (Util.equals(this.toolTip, toolTip = Util.safeString(toolTip))) {
            return;
        }
        this.toolTip = toolTip;
        this.firePropertyChange(1);
    }

    public void showBusy(boolean busy) {
    }

    public String getPartName() {
        return this.partName;
    }

    protected void setPartName(String partName) {
        this.internalSetPartName(partName);
        this.setDefaultTitle();
    }

    void setDefaultTitle() {
        String name;
        String description = this.getContentDescription();
        String newTitle = name = this.getPartName();
        if (!Util.equals(description, "")) {
            newTitle = MessageFormat.format(WorkbenchMessages.WorkbenchPart_AutoTitleFormat, name, description);
        }
        this.setTitle(newTitle);
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    protected void setContentDescription(String description) {
        this.internalSetContentDescription(description);
        this.setDefaultTitle();
    }

    void internalSetContentDescription(String description) {
        Assert.isNotNull(description);
        if (Util.equals(this.contentDescription, description)) {
            return;
        }
        this.contentDescription = description;
        this.firePropertyChange(261);
    }

    void internalSetPartName(String partName) {
        partName = Util.safeString(partName);
        Assert.isNotNull(partName);
        if (Util.equals(this.partName, partName)) {
            return;
        }
        this.partName = partName;
        this.firePropertyChange(260);
    }

    public int getOrientation() {
        return Window.getDefaultOrientation();
    }
}

