/*
 * Decompiled with CFR 0.152.
 */
package org.gvt;

import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScalableLayeredPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.gvt.ChisioMain;
import org.gvt.ChsViewport;

public class ChsZoomManager
extends ZoomManager
implements ZoomListener {
    ScalableLayeredPane pane;
    ChsViewport viewport;
    Rectangle newZoomArea;

    public ChsZoomManager(ScalableLayeredPane pane, ChsViewport viewport) {
        super(pane, (Viewport)viewport);
        this.pane = pane;
        this.viewport = viewport;
        double[] zoomLevels = new double[]{0.01, 0.05, 0.1, 0.5, 0.75, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0, 6.0, 8.0, 10.0, 15.0, 20.0, 40.0};
        this.setZoomLevels(zoomLevels);
        this.addZoomListener(this);
    }

    @Override
    public void zoomTo(Rectangle rect) {
        Point p = this.primSetZoom(rect);
        p.x -= (this.viewport.getSize().width - this.newZoomArea.getSize().width) / 2;
        p.y -= (this.viewport.getSize().height - this.newZoomArea.getSize().height) / 2;
        this.viewport.setViewLocation(p.x, p.y);
    }

    protected Point primSetZoom(Rectangle rect) {
        double zoom = this.getFitXZoomLevel(rect);
        double prevZoom = this.getZoom();
        Point l = this.viewport.getViewLocation();
        this.setZoom(zoom);
        this.newZoomArea = rect.getCopy().translate(l);
        this.newZoomArea.scale(zoom / prevZoom);
        return this.newZoomArea.getLocation();
    }

    private double getFitXZoomLevel(Rectangle bound) {
        IFigure fig;
        Dimension available = this.getViewport().getClientArea().getSize();
        Dimension desired = fig instanceof FreeformFigure ? ((FreeformFigure)fig).getFreeformExtent().getCopy().union(0, 0).getSize() : bound.getSize().getCopy();
        desired.width -= fig.getInsets().getWidth();
        desired.height -= fig.getInsets().getHeight();
        for (fig = this.getScalableFigure(); fig != this.getViewport(); fig = fig.getParent()) {
            available.width -= fig.getInsets().getWidth();
            available.height -= fig.getInsets().getHeight();
        }
        double scaleX = (double)available.width * this.getZoom() / (double)desired.width;
        double scaleY = (double)available.height * this.getZoom() / (double)desired.height;
        return Math.min(scaleX, scaleY);
    }

    @Override
    public void zoomChanged(double zoom) {
        ChisioMain.updateCombo(this.getZoomAsText());
    }
}

