/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.ArrayList;
import java.util.Random;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.gvt.ChisioMain;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.CompoundModel;
import org.gvt.model.ECluster;
import org.gvt.model.EdgeModel;
import org.gvt.model.NodeModel;

public class ColorWithClusterIDAction
extends Action {
    ChisioMain main;

    public ColorWithClusterIDAction(ChisioMain main) {
        super("Color using Cluster IDs");
        this.setToolTipText("Color using Cluster IDs");
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/color-cluster.png"));
        this.main = main;
    }

    @Override
    public void run() {
        ArrayList<Integer> clusterIDs = this.main.getPathwayGraph().getClusterManager().getClusterIDs();
        for (int i = 0; i < clusterIDs.size(); ++i) {
            Random rnd = new Random();
            Color c = new Color(null, rnd.nextInt(256), rnd.nextInt(256), rnd.nextInt(256));
            for (NodeModel nodeModel : this.main.getPathwayGraph().getClusterManager().getClusterByID((Integer)clusterIDs.get(i)).getNodes()) {
                nodeModel.setColor(c);
                int clusterID = nodeModel.getClusters().get(0).getClusterID();
                ECluster cluster = (ECluster)nodeModel.getParentModel().getClusterManager().getClusterByID(clusterID);
                cluster.setHighlightColor(c);
            }
        }
        BioPAXGraph root = this.main.getPathwayGraph();
        for (NodeModel node : ((CompoundModel)root).getNodes()) {
            if (!node.getClusters().isEmpty()) continue;
            if (node instanceof CompoundModel) {
                node.setColor(CompoundModel.DEFAULT_COLOR);
                continue;
            }
            node.setColor(NodeModel.DEFAULT_COLOR);
        }
        for (Object edgeObject : ((CompoundModel)root).getEdges()) {
            NodeModel trgt;
            EdgeModel edgeModel = (EdgeModel)edgeObject;
            NodeModel src = edgeModel.getSource();
            if (src.hasCommonCluster(trgt = edgeModel.getTarget())) {
                edgeModel.setColor(ColorConstants.gray);
                continue;
            }
            edgeModel.setColor(EdgeModel.DEFAULT_COLOR);
        }
    }
}

