/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.gvt.ChisioMain;
import org.gvt.action.RemoveExperimentColorAction;
import org.gvt.gui.ItemSelectionDialog;
import org.gvt.gui.ItemSelectionRunnable;
import org.gvt.model.BioPAXGraph;

public class ColorWithExperimentAction
extends Action {
    private ChisioMain main;
    private String type;
    private BioPAXGraph graph;

    public ColorWithExperimentAction(ChisioMain main) {
        super("Use Data Colors");
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/color-experiment.png"));
        this.setToolTipText(this.getText());
        this.main = main;
    }

    public ColorWithExperimentAction(ChisioMain main, BioPAXGraph graph, String type) {
        this(main);
        this.type = type;
        this.graph = graph;
    }

    @Override
    public void run() {
        if (this.graph == null) {
            this.graph = this.main.getPathwayGraph();
            if (this.graph == null) {
                return;
            }
        }
        if (this.type == null) {
            Set<String> types = this.main.getLoadedExperimentTypes();
            if (types.isEmpty()) {
                MessageDialog.openError(this.main.getShell(), "Error!", "Load experiment data first.");
                return;
            }
            if (types.size() == 1) {
                this.type = types.iterator().next();
            } else {
                ArrayList<String> selectedItems = new ArrayList<String>();
                if (this.graph.getLastAppliedColoring() != null) {
                    selectedItems.add(this.graph.getLastAppliedColoring());
                }
                ItemSelectionDialog dialog = new ItemSelectionDialog(this.main.getShell(), 200, "Experiment Type Selection Dialog", "Select experiment type", new ArrayList<String>(types), selectedItems, false, false, new ColoringSelectionRunnable());
                dialog.setUpdateUponSelection(true);
                dialog.open();
            }
        }
        if (this.type != null) {
            ArrayList<String> typeInList = new ArrayList<String>();
            typeInList.add(this.type);
            new ColoringSelectionRunnable().run(typeInList);
            this.graph.setLastAppliedColoring(this.type);
        }
        this.type = null;
        this.graph = null;
    }

    private class ColoringSelectionRunnable
    implements ItemSelectionRunnable {
        private ColoringSelectionRunnable() {
        }

        @Override
        public void run(Collection selectedTerms) {
            assert (selectedTerms.size() == 1);
            String type = selectedTerms.iterator().next().toString();
            if (type.equals("None") && ColorWithExperimentAction.this.graph.getLastAppliedColoring() != null) {
                new RemoveExperimentColorAction(ColorWithExperimentAction.this.main, ColorWithExperimentAction.this.graph).run();
                return;
            }
            ColorWithExperimentAction.this.graph.representDataOnActors(type);
            ColorWithExperimentAction.this.graph.setLastAppliedColoring(type);
        }
    }
}

