/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.gvt.ChisioMain;
import org.gvt.gui.ConnectToDAVIDDialog;
import org.gvt.util.SystemBrowserDisplay;
import org.patika.mada.graph.Node;
import org.patika.mada.util.XRef;

public class ConnectToDAVIDAction
extends Action {
    private ChisioMain main;
    private String toolName;
    private String idType;
    private String resultURL;
    private Map<String, List<String>> mappingResult;
    private static Map<String, String> refMatching;

    public ConnectToDAVIDAction(ChisioMain main) {
        super("Connect To DAVID ...");
        this.main = main;
        this.toolName = null;
        this.idType = null;
        this.resultURL = null;
    }

    @Override
    public void run() {
        if (this.main.getBioPAXModel() == null) {
            MessageDialog.openError(this.main.getShell(), "Error!", "Load or query a BioPAX model first!");
            return;
        }
        Set<Node> selected = this.getSelectedNodes();
        if (selected.isEmpty()) {
            MessageDialog.openError(this.main.getShell(), "No Selection!", "Select node(s) first!");
            return;
        }
        ConnectToDAVIDDialog dialog = new ConnectToDAVIDDialog(this.main);
        if (dialog.open()) {
            this.toolName = dialog.getToolName();
            Map<String, String> knownReferences = ConnectToDAVIDAction.getReferenceMatching();
            this.mappingResult = new HashMap<String, List<String>>();
            this.mappingResult.put("ENTREZ_GENE_ID", new ArrayList());
            this.mappingResult.put("REFSEQ_PROTEIN", new ArrayList());
            this.mappingResult.put("GENE_SYMBOL", new ArrayList());
            this.mappingResult.put("UNIPROT_ACCESSION", new ArrayList());
            for (Node node : selected) {
                HashMap references = new HashMap();
                for (XRef ref : node.getReferences()) {
                    references.put(ref.getDb(), ref.getRef());
                }
                for (XRef ref2 : node.getSecondaryReferences()) {
                    references.put(ref2.getDb(), ref2.getRef());
                }
                for (String reference : references.keySet()) {
                    if (!knownReferences.containsKey(reference)) continue;
                    this.mappingResult.get(knownReferences.get(reference)).add((String)references.get(reference));
                }
            }
            int maxResult = 0;
            String maxEntry = null;
            for (String key : this.mappingResult.keySet()) {
                if (this.mappingResult.get(key).size() <= maxResult) continue;
                maxResult = this.mappingResult.get(key).size();
                maxEntry = key;
                if (maxResult != selected.size()) continue;
                break;
            }
            if (maxEntry != null) {
                boolean isOk;
                if (maxResult < selected.size() && !(isOk = MessageDialog.openQuestion(this.main.getShell(), "Incomplete Set!", "Only " + maxResult + " of the selected " + selected.size() + " nodes share a common reference type." + "\nDo you wish to continue with this subset?"))) {
                    return;
                }
                this.idType = maxEntry;
                this.resultURL = "http://david.abcc.ncifcrf.gov/api.jsp?type=" + this.idType + "&ids=";
                for (String id : this.mappingResult.get(this.idType)) {
                    this.resultURL = this.resultURL + id + ",";
                }
                this.resultURL = this.resultURL.substring(0, this.resultURL.length() - 1) + "&tool=" + this.toolName;
                System.out.println(this.resultURL);
                SystemBrowserDisplay.openURL(this.resultURL);
            } else {
                MessageDialog.openWarning(this.main.getShell(), "No Type Matching!", "The selected nodes do not have references in types recognized by DAVID.");
            }
        }
    }

    private Set<Node> getSelectedNodes() {
        HashSet<Node> selected = new HashSet<Node>();
        ScrollingGraphicalViewer viewer = this.main.getViewer();
        Iterator selectedObjects = ((IStructuredSelection)viewer.getSelection()).iterator();
        while (selectedObjects.hasNext()) {
            Object o = ((EditPart)selectedObjects.next()).getModel();
            if (!(o instanceof Node)) continue;
            selected.add((Node)o);
        }
        return selected;
    }

    private static Map<String, String> getReferenceMatching() {
        if (refMatching != null) {
            return refMatching;
        }
        refMatching = new HashMap<String, String>();
        refMatching.put("Entrez Gene", "ENTREZ_GENE_ID");
        refMatching.put("ENTREZ_GENE", "ENTREZ_GENE_ID");
        refMatching.put("Refseq", "REFSEQ_PROTEIN");
        refMatching.put("RefSeq", "REFSEQ_PROTEIN");
        refMatching.put("REF_SEQ", "REFSEQ_PROTEIN");
        refMatching.put("GENE_SYMBOL", "HGNC SYMBOL");
        refMatching.put("uniprot", "UNIPROT_ACCESSION");
        refMatching.put("UNIPROT", "UNIPROT_ACCESSION");
        refMatching.put("UniProt", "UNIPROT_ACCESSION");
        return refMatching;
    }
}

