/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.gvt.ChisioMain;
import org.gvt.action.CoSELayoutAction;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.EdgeModel;
import org.gvt.model.NodeModel;
import org.gvt.util.PathwayHolder;
import org.patika.mada.graph.GraphObject;

public class CropAction
extends Action {
    ChisioMain main;
    CropTo type;

    public CropAction(ChisioMain main, CropTo type) {
        super("Crop To " + type.toString().substring(0, 1) + type.toString().substring(1).toLowerCase());
        this.setToolTipText(this.getText());
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/pathway-create-crop.png"));
        this.main = main;
        this.type = type;
    }

    @Override
    public void run() {
        ScrollingGraphicalViewer viewer;
        BioPAXGraph graph = this.main.getPathwayGraph();
        if (graph == null) {
            MessageDialog.openError(this.main.getShell(), "Error!", "No BioPAX pathway.");
            return;
        }
        if (!graph.isMechanistic()) {
            MessageDialog.openError(this.main.getShell(), "Not Supported!", "Cropping is supported only for mechanistic views.");
            return;
        }
        HashSet<GraphObject> cropto = new HashSet<GraphObject>();
        if (this.type == CropTo.HIGHLIGHTED) {
            for (Object o : graph.getNodes()) {
                NodeModel node = (NodeModel)o;
                if (!node.isHighlight()) continue;
                cropto.add((GraphObject)((Object)node));
            }
            for (Object o : graph.getEdges()) {
                EdgeModel edge = (EdgeModel)o;
                if (!edge.isHighlight()) continue;
                cropto.add((GraphObject)((Object)edge));
            }
        } else if (this.type == CropTo.SELECTED && (viewer = this.main.getViewer()) != null) {
            Iterator selectedObjects = ((IStructuredSelection)viewer.getSelection()).iterator();
            while (selectedObjects.hasNext()) {
                Object model = ((EditPart)selectedObjects.next()).getModel();
                if (model instanceof NodeModel) {
                    cropto.add((GraphObject)model);
                    continue;
                }
                if (!(model instanceof EdgeModel)) continue;
                cropto.add((GraphObject)model);
            }
        }
        if (cropto.isEmpty()) {
            MessageDialog.openError(this.main.getShell(), "Error!", "Nothing is highlighted.");
            return;
        }
        BioPAXGraph excised = graph.excise(cropto, true);
        excised.setName(graph.getName() + " cropped");
        PathwayHolder h = new PathwayHolder(graph.getBiopaxModel(), excised.getName());
        excised.setPathway(h);
        excised.registerContentsToPathway();
        this.main.createNewTab(excised);
        new CoSELayoutAction(this.main).run();
        excised.recordLayout();
    }

    public static enum CropTo {
        HIGHLIGHTED,
        SELECTED;

    }
}

