/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.ArrayList;
import java.util.List;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.gvt.ChisioMain;
import org.gvt.action.CoSELayoutAction;
import org.gvt.gui.ExportToSIFL3Dialog;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.biopaxl3.BioPAXL3Graph;
import org.gvt.model.sifl3.SIFGraph;
import org.gvt.util.BioPAXUtil;

public class ExportToSIFAction
extends Action {
    private ChisioMain main;
    List<SIFType> ruleTypesL3;
    private boolean entireModel;

    public ExportToSIFAction(ChisioMain main, boolean entireModel) {
        super("Convert " + (entireModel ? "model" : "view") + " to SIF ...");
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/sif.png"));
        this.setToolTipText(this.getText());
        this.main = main;
        this.ruleTypesL3 = new ArrayList<SIFType>();
        this.entireModel = entireModel;
    }

    @Override
    public void run() {
        ExportToSIFL3Dialog dialog;
        boolean okPressed;
        Model model = this.main.getBioPAXModel();
        if (model == null) {
            MessageDialog.openError(this.main.getShell(), "Error!", "Load or query a BioPAX model first.");
            return;
        }
        if (model.getLevel() == BioPAXLevel.L2) {
            MessageDialog.openError(this.main.getShell(), "Error!", "This action is not supported at Level 2 BioPAX models. Please use level 3.");
            return;
        }
        if (!this.entireModel) {
            BioPAXL3Graph graph;
            BioPAXGraph root = this.main.getPathwayGraph();
            boolean stop = true;
            if (root instanceof BioPAXL3Graph && (graph = (BioPAXL3Graph)root).isMechanistic()) {
                model = BioPAXUtil.excise(model, graph.getPathway());
                stop = false;
            }
            if (stop) {
                MessageDialog.openError(this.main.getShell(), "Error!", "This feature works only for Level 3 mechanistic views.");
                return;
            }
        }
        if ((okPressed = (dialog = new ExportToSIFL3Dialog(this.main.getShell(), SIFGraph.getPossibleRuleTypes(), this.ruleTypesL3)).open()) && !this.ruleTypesL3.isEmpty()) {
            SIFGraph sif = new SIFGraph(model, this.ruleTypesL3, this.main.collectUbiqueIDs());
            int nodenum = sif.getNodes().size();
            int edgenum = sif.getEdges().size();
            System.out.println("created nodenum = " + nodenum + " edgenum = " + edgenum);
            if (nodenum > 0) {
                String name = this.main.getOwlFileName();
                if (name == null) {
                    name = "SIF View";
                } else if (name.contains("/")) {
                    name = name.substring(name.lastIndexOf("/") + 1, name.lastIndexOf("."));
                } else if (name.contains("\\")) {
                    name = name.substring(name.lastIndexOf("\\") + 1, name.lastIndexOf("."));
                }
                ((BioPAXGraph)sif).setName(name);
                this.main.createNewTab(sif);
                this.main.associateGraphWithExperimentData(sif);
                new CoSELayoutAction(this.main).run();
            } else {
                MessageDialog.openInformation(this.main.getShell(), "Empty graph!", "Could not create any graph using specified rules.");
            }
        }
    }
}

