/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level3.EntityReference;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.gvt.ChisioMain;
import org.gvt.action.OpenPathwaysAction;
import org.gvt.gui.ItemSelectionDialog;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.EntityAssociated;
import org.gvt.model.NodeModel;
import org.gvt.util.BioPAXUtil;
import org.gvt.util.EntityHolder;
import org.gvt.util.PathwayHolder;

public class GetNeighborhoodOfSelectedEntityAction
extends Action {
    private ChisioMain main;
    private Set<EntityHolder> entities;

    public GetNeighborhoodOfSelectedEntityAction(ChisioMain main) {
        super("Create Pathway With Neighbors Of Selected");
        this.main = main;
    }

    public GetNeighborhoodOfSelectedEntityAction(ChisioMain main, Collection<EntityHolder> entities) {
        this(main);
        this.entities = new HashSet<EntityHolder>(entities);
    }

    @Override
    public void run() {
        if (this.main.getBioPAXModel() == null) {
            MessageDialog.openError(this.main.getShell(), "Error!", "No BioPAX model.");
            return;
        }
        if (this.entities == null) {
            this.entities = new HashSet<EntityHolder>();
            ScrollingGraphicalViewer viewer = this.main.getViewer();
            if (viewer != null) {
                Iterator selectedObjects = ((IStructuredSelection)viewer.getSelection()).iterator();
                while (selectedObjects.hasNext()) {
                    Object model;
                    Object o = ((EditPart)selectedObjects.next()).getModel();
                    if (!(o instanceof NodeModel) || !((model = (NodeModel)o) instanceof EntityAssociated)) continue;
                    EntityAssociated ea = (EntityAssociated)model;
                    this.entities.add(ea.getEntity());
                }
            }
        }
        Model model = this.main.getBioPAXModel();
        if (this.entities.isEmpty()) {
            Object eh;
            ArrayList allEntityNames = new ArrayList();
            HashMap<String, EntityHolder> nametoEntityMap = new HashMap<String, EntityHolder>();
            if (model.getLevel() == BioPAXLevel.L3) {
                for (EntityReference er : model.getObjects(EntityReference.class)) {
                    eh = new EntityHolder(er);
                    nametoEntityMap.put(((EntityHolder)eh).getName(), (EntityHolder)eh);
                }
            } else if (model.getLevel() == BioPAXLevel.L2) {
                for (physicalEntity pe : model.getObjects(physicalEntity.class)) {
                    eh = new EntityHolder(pe);
                    nametoEntityMap.put(((EntityHolder)eh).getName(), (EntityHolder)eh);
                }
            }
            allEntityNames.addAll(nametoEntityMap.keySet());
            ArrayList userSelection = new ArrayList();
            ItemSelectionDialog dialog = new ItemSelectionDialog(this.main.getShell(), 350, "Entity Selection Dialog", "Select entities whose neighborhood is to be found", allEntityNames, userSelection, true, true, null);
            dialog.setMinValidSelect(1);
            dialog.setDoSort(true);
            dialog.open();
            if (!dialog.isCancelled()) {
                eh = userSelection.iterator();
                while (eh.hasNext()) {
                    String s = (String)eh.next();
                    this.entities.add((EntityHolder)nametoEntityMap.get(s));
                }
            }
        }
        if (!this.entities.isEmpty()) {
            String name = "Neighborhood of";
            int i = 0;
            for (EntityHolder entity2 : this.entities) {
                name = name + (i == 0 ? " " : ", ") + entity2.getName();
                if (++i != 3) continue;
                break;
            }
            if (this.entities.size() > i) {
                name = name + ", et al.";
            }
            PathwayHolder ph = BioPAXUtil.getPathwayOfNeighbors(this.entities, model, name);
            ArrayList<String> list = new ArrayList<String>(this.main.getOpenTabNames());
            list.add(ph.getName());
            new OpenPathwaysAction(this.main, list).run();
            BioPAXGraph graph = this.main.getPathwayGraph();
            graph.hihglightRelatedNodes(this.entities);
        }
        this.entities = null;
    }
}

