/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cbio.causality.model.Alteration;
import org.cbio.causality.model.AlterationPack;
import org.eclipse.swt.custom.CTabItem;
import org.gvt.ChisioMain;
import org.gvt.action.TCGASIFAction;
import org.gvt.gui.ItemSelectionDialog;
import org.gvt.gui.ItemSelectionRunnable;
import org.gvt.model.CompoundModel;
import org.gvt.model.basicsif.BasicSIFGroup;
import org.patika.mada.graph.Graph;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;

public class HighlightTCGACaseAction
extends TCGASIFAction {
    public HighlightTCGACaseAction(ChisioMain main) {
        super("Highlight a TCGA Case ...", main);
    }

    @Override
    public void run() {
        if (!HighlightTCGACaseAction.okToRun(this.main)) {
            return;
        }
        CTabItem tab = this.main.getSelectedTab();
        CompoundModel root = (CompoundModel)this.main.getTabToViewerMap().get(tab).getContents().getModel();
        final Graph graph = (Graph)((Object)root);
        final ArrayList<String> cases = new ArrayList<String>(Arrays.asList(ChisioMain.cBioPortalAccessor.getCurrentCaseList().getCases()));
        Set<GraphObject> gos = this.getHighlighted(graph);
        graph.removeHighlights();
        ItemSelectionDialog dialog = new ItemSelectionDialog(this.main.getShell(), 150, "TCGA Cases", "Please select a TCGA case to highlight", cases, null, false, false, new ItemSelectionRunnable(){
            Set<GraphObject> gos = new HashSet<GraphObject>();

            @Override
            public void run(Collection selectedTerms) {
                for (GraphObject go : this.gos) {
                    go.setHighlight(false);
                }
                this.gos.clear();
                if (selectedTerms.isEmpty()) {
                    return;
                }
                Object o = selectedTerms.iterator().next();
                if (o.equals("None")) {
                    return;
                }
                String aCase = o.toString();
                int index = cases.indexOf(aCase) - 1;
                for (Node node : graph.getNodes()) {
                    String sym;
                    AlterationPack altPack;
                    if (node instanceof BasicSIFGroup || (altPack = ChisioMain.cBioPortalAccessor.getAlterations(sym = node.getName())) == null || !altPack.get(Alteration.ANY)[index].isAltered()) continue;
                    node.setHighlight(true);
                    this.gos.add(node);
                }
            }
        });
        dialog.setUpdateUponSelection(true);
        dialog.setDoSort(false);
        dialog.open();
        graph.removeHighlights();
        this.highlight(gos);
    }
}

