/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.cbio.causality.analysis.Graph;
import org.cbio.causality.data.portal.BroadAccessor;
import org.cbio.causality.data.portal.CBioPortalAccessor;
import org.cbio.causality.data.portal.CancerStudy;
import org.cbio.causality.data.portal.GeneticProfile;
import org.cbio.causality.model.AlterationPack;
import org.cbio.causality.network.PathwayCommons;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Color;
import org.gvt.ChisioMain;
import org.gvt.action.CoSELayoutAction;
import org.gvt.action.FetchFromCBioPortalAction;
import org.gvt.action.QueryPCAction;
import org.gvt.action.TCGASIFAction;
import org.gvt.editpart.ChsScalableRootEditPart;
import org.gvt.figure.HighlightLayer;
import org.gvt.gui.ItemSelectionDialog;
import org.gvt.model.NodeModel;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.gvt.util.Conf;
import org.patika.mada.algorithm.AlgoRunner;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;

public class LoadTCGASpecificSIFAction
extends TCGASIFAction {
    protected String caseID;
    protected String study;
    protected boolean newView = true;

    public LoadTCGASpecificSIFAction(ChisioMain main) {
        this("Load TCGA Specific SIF ...", main);
    }

    protected LoadTCGASpecificSIFAction(String text, ChisioMain main) {
        super(text, main);
    }

    public void setCaseID(String caseID) {
        this.caseID = caseID;
    }

    public void setStudy(String study) {
        this.study = study;
    }

    public void setNewView(boolean newView) {
        this.newView = newView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.study == null) {
                ItemSelectionDialog dialog = new ItemSelectionDialog(this.main.getShell(), 500, "Available studies", "Please select a study", this.prepareStudyList(BroadAccessor.getStudyCodes()), null, false, true, null);
                this.study = (String)dialog.open();
                if (this.study != null) {
                    this.study = this.study.substring(0, this.study.indexOf(" "));
                }
            }
            if (this.study == null) {
                return;
            }
            Set<String> genes = BroadAccessor.getMutsigGenes(this.study, 0.05, true);
            genes.addAll(BroadAccessor.getExpressionVerifiedGistic(this.study, 0.05));
            if (genes.isEmpty()) {
                MessageDialog.openInformation(this.main.getShell(), "No genes of interest", "Cannot find any genes of interest for the current study.");
                return;
            }
            Graph graph = PathwayCommons.getGraph(SIFEnum.CONTROLS_STATE_CHANGE_OF, SIFEnum.CONTROLS_EXPRESSION_OF);
            genes.addAll(graph.getEnrichedGenes(genes, null, 0.05, Graph.NeighborType.BOTHSTREAM, 1));
            BasicSIFGraph pcGraph = new BasicSIFGraph(graph);
            Set<Node> seed = QueryPCAction.getSeed(pcGraph, genes);
            Set<String> caseGenes = null;
            HashSet<String> caseOnly = null;
            if (this.caseID != null) {
                caseGenes = this.getAlteredGenesForTheCase(this.caseID);
                caseGenes = this.getNeighborsOfFirstAlsoInTheSecondSet(genes, caseGenes, seed);
                caseOnly = new HashSet<String>(caseGenes);
                caseOnly.removeAll(genes);
                genes.addAll(caseOnly);
                seed = QueryPCAction.getSeed(pcGraph, genes);
                System.out.println("caseOnly.size() = " + caseOnly.size());
                System.out.println("caseGenes = " + caseGenes.size());
            }
            if (seed.isEmpty()) {
                MessageDialog.openInformation(this.main.getShell(), "No genes of interest", "Loaded genes of interest do not intersect with genes in SIF data.");
                return;
            }
            Collection<GraphObject> graphObjects = AlgoRunner.searchPathsBetweenSIF(seed, 1, true, -1, true);
            BasicSIFGraph goi = (BasicSIFGraph)pcGraph.excise((Collection)graphObjects, true);
            goi.setName(this.study);
            goi.setAsRoot();
            System.out.println("GOI has " + goi.getNodes().size() + " nodes and " + goi.getEdges().size() + " edges.");
            if (this.newView) {
                this.main.createNewTab(goi);
            } else {
                HighlightLayer hLayer = (HighlightLayer)((ChsScalableRootEditPart)this.main.getViewer().getRootEditPart()).getLayer("Highlight Layer");
                hLayer.removeAll();
                hLayer.highlighted.clear();
                this.main.getViewer().deselectAll();
                this.main.getViewer().setContents(goi);
            }
            new CoSELayoutAction(this.main).run();
            new FetchFromCBioPortalAction(this.main, this.study.toLowerCase() + "_tcga").run();
            if (caseGenes != null && !caseGenes.isEmpty()) {
                Color color = new Color(null, 180, 255, 180);
                for (Object o : goi.getNodes()) {
                    NodeModel node = (NodeModel)o;
                    if (!caseGenes.contains(node.getText())) continue;
                    if (caseOnly.contains(node.getText())) {
                        node.setHighlightColor(color);
                    }
                    node.setHighlight(true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.study = null;
        }
    }

    private Set<String> getNeighborsOfFirstAlsoInTheSecondSet(Set<String> first, Set<String> second, Set<Node> nodes) {
        HashSet<String> neigh = new HashSet<String>();
        for (Node node : nodes) {
            Node n;
            for (Edge edge : node.getUpstream()) {
                n = edge.getSourceNode();
                neigh.add(n.getName());
            }
            for (Edge edge : node.getDownstream()) {
                n = edge.getTargetNode();
                neigh.add(n.getName());
            }
        }
        neigh.retainAll(second);
        return neigh;
    }

    private void keepOverValue(String study, Set<String> gistic, Set<String> dontTouchThis, double altThr) {
        CBioPortalAccessor acc = this.getPortalAccessor();
        acc.configureForStudy(study.toLowerCase() + "_tcga");
        HashSet<String> keep = new HashSet<String>(dontTouchThis);
        for (String s : gistic) {
            AlterationPack alts = acc.getAlterations(s);
            if (alts == null || !(alts.getAlteredRatio() >= altThr)) continue;
            keep.add(s);
        }
        gistic.retainAll(keep);
    }

    private CBioPortalAccessor getPortalAccessor() {
        if (ChisioMain.cBioPortalAccessor == null) {
            try {
                CBioPortalAccessor.setCacheDir(Conf.getPortalCacheDir());
                ChisioMain.cBioPortalAccessor = new CBioPortalAccessor();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ChisioMain.cBioPortalAccessor;
    }

    private Set<String> getAlteredGenesForTheCase(String caseID) {
        String url;
        CBioPortalAccessor acc = this.getPortalAccessor();
        String mutID = null;
        String cnaID = null;
        for (GeneticProfile gp : acc.getCurrentGeneticProfiles()) {
            if (gp.getId().contains("gistic")) {
                cnaID = gp.getId();
                continue;
            }
            if (!gp.getId().contains("mutation")) continue;
            mutID = gp.getId();
        }
        HashSet<String> set = new HashSet<String>();
        if (mutID != null) {
            url = "http://www.cbioportal.org/public-portal/mutations.json?case_id=" + caseID + "&mutation_profile=" + mutID;
            this.harvestAlteredCaseJSON(url, set);
        }
        if (mutID != null) {
            url = "http://www.cbioportal.org/public-portal/cna.json?case_id=" + caseID + "&cna_profile=" + cnaID;
            this.harvestAlteredCaseJSON(url, set);
        }
        return set;
    }

    private void harvestAlteredCaseJSON(String url, Set<String> set) {
        try {
            String content = IOUtils.toString(new URL(url), "UTF-8");
            int start = content.indexOf("\"gene\":[\"") + 9;
            int end = content.indexOf("\"]", start);
            content = content.substring(start, end);
            String[] token = content.split("\",\"");
            set.addAll(Arrays.asList(token));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<String> prepareStudyList(List<String> studyCodes) {
        ArrayList<String> list = new ArrayList<String>(studyCodes.size());
        try {
            CBioPortalAccessor acc = new CBioPortalAccessor();
            block2: for (String code : studyCodes) {
                code = code.toLowerCase();
                for (CancerStudy cancerStudy : acc.getCancerStudies()) {
                    if (!cancerStudy.getStudyId().equals(code + "_tcga")) continue;
                    list.add(code.toUpperCase() + " - " + cancerStudy.getName());
                    continue block2;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    static {
        CBioPortalAccessor.setCacheDir(Conf.getPortalCacheDir());
    }
}

