/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.query.QueryExecuter;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.wrapperL3.Filter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.gvt.ChisioMain;
import org.gvt.action.AbstractLocalQueryAction;
import org.gvt.action.RemoveHighlightsAction;
import org.gvt.gui.AbstractQueryParamDialog;
import org.gvt.gui.CommonStreamQueryParamDialog;
import org.gvt.gui.CommonStreamQueryParamWithEntitiesDialog;
import org.gvt.util.BioPAXUtil;
import org.gvt.util.EntityHolder;
import org.gvt.util.QueryOptionsPack;

public class LocalCommonStreamQueryAction
extends AbstractLocalQueryAction {
    QueryOptionsPack options;
    private boolean useSelection;

    public LocalCommonStreamQueryAction(ChisioMain main, boolean useSelection) {
        super(main, "Common Stream ...");
        this.setToolTipText(this.getText());
        this.options = new QueryOptionsPack();
        this.main = main;
        this.useSelection = useSelection;
    }

    @Override
    public void run() {
        Set<BioPAXElement> source;
        AbstractQueryParamDialog dialog;
        if (this.main.getBioPAXModel() == null) {
            MessageDialog.openError(this.main.getShell(), "Error!", "Load or query a BioPAX model first!");
            return;
        }
        RemoveHighlightsAction rha = new RemoveHighlightsAction(this.main);
        rha.run();
        if (this.useSelection) {
            if (this.main.getPathwayGraph() == null) {
                MessageDialog.openError(this.main.getShell(), "Error!", "This feature works only for BioPAX graphs");
                return;
            }
            dialog = new CommonStreamQueryParamDialog(this.main);
            this.options = dialog.open(this.options);
            if (this.options.isCancel()) {
                return;
            }
            this.options.setCancel(true);
            source = this.main.getSelectedBioPAXElements();
        } else {
            dialog = new CommonStreamQueryParamWithEntitiesDialog(this.main, BioPAXUtil.getEntities(this.main.getBioPAXModel()));
            this.options = dialog.open(this.options);
            if (this.options.isCancel()) {
                return;
            }
            this.options.setCancel(true);
            List<EntityHolder> addedEntities = dialog.getAddedSourceEntities();
            source = BioPAXUtil.getContent(addedEntities);
        }
        Set<BioPAXElement> result = QueryExecuter.runCommonStreamWithPOI(source, this.main.getBioPAXModel(), this.options.isDownstream() ? Direction.DOWNSTREAM : Direction.UPSTREAM, this.options.getLengthLimit(), new Filter[0]);
        this.viewAndHighlightResult(result, this.options.isCurrentView(), "Query Result");
    }
}

