/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.query.QueryExecuter;
import org.biopax.paxtools.query.algorithm.LimitType;
import org.biopax.paxtools.query.wrapperL3.Filter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.gvt.ChisioMain;
import org.gvt.action.AbstractLocalQueryAction;
import org.gvt.gui.PoIQueryParamWithEntitiesDialog;
import org.gvt.util.BioPAXUtil;
import org.gvt.util.EntityHolder;
import org.gvt.util.QueryOptionsPack;

public class LocalPoIQueryAction
extends AbstractLocalQueryAction {
    ChisioMain main;
    QueryOptionsPack options;

    public LocalPoIQueryAction(ChisioMain main) {
        super(main, "Paths From To ...");
        this.setToolTipText(this.getText());
        this.options = new QueryOptionsPack();
        this.main = main;
    }

    @Override
    public void run() {
        this.LocalPoI();
    }

    public void LocalPoI() {
        if (this.main.getBioPAXModel() == null) {
            MessageDialog.openError(this.main.getShell(), "Error!", "Load or query a BioPAX model first!");
            return;
        }
        PoIQueryParamWithEntitiesDialog dialog = new PoIQueryParamWithEntitiesDialog(this.main, BioPAXUtil.getEntities(this.main.getBioPAXModel()));
        this.options = dialog.open(this.options);
        if (this.options.isCancel()) {
            return;
        }
        this.options.setCancel(true);
        List<EntityHolder> sourceAddedEntities = dialog.getAddedSourceEntities();
        List<EntityHolder> targetAddedEntities = dialog.getAddedTargetEntities();
        Set<BioPAXElement> source = BioPAXUtil.getContent(sourceAddedEntities);
        Set<BioPAXElement> target = BioPAXUtil.getContent(targetAddedEntities);
        Set<BioPAXElement> result = QueryExecuter.runPathsFromTo(source, target, this.main.getBioPAXModel(), this.options.getLimitType() ? LimitType.NORMAL : LimitType.SHORTEST_PLUS_K, this.options.getLengthLimit(), new Filter[0]);
        this.viewAndHighlightResult(result, this.options.isCurrentView(), "Query Result");
    }
}

