/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.SimpleMerger;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.Model;
import org.eclipse.jface.dialogs.MessageDialog;
import org.gvt.ChisioMain;
import org.gvt.action.ChiBEAction;
import org.gvt.action.FileChooser;
import org.gvt.action.OpenPathwaysAction;
import org.gvt.action.UpdatePathwayAction;
import org.gvt.util.BioPAXUtil;
import org.gvt.util.PathwayHolder;

public class MergeAction
extends ChiBEAction {
    String filename;
    String newPathwayName;
    Model model;
    boolean updatePathways = true;
    boolean openPathways = true;
    boolean createNewPathway;
    String nameOfPathwayToOpen;

    public MergeAction(ChisioMain chisio) {
        super("Merge With ...", "icon/merge.png", chisio);
        this.addFilterExtension("FILE_KEY", new String[]{"*.owl"});
        this.addFilterName("FILE_KEY", new String[]{"BioPAX (*.owl)"});
    }

    public void setNameOfPathwayToOpen(String nameOfPathwayToOpen) {
        this.nameOfPathwayToOpen = nameOfPathwayToOpen;
    }

    public void setOpenPathways(boolean openPathways) {
        this.openPathways = openPathways;
    }

    public void setUpdatePathways(boolean updatePathways) {
        this.updatePathways = updatePathways;
    }

    public void setCreateNewPathway(boolean createNewPathway) {
        this.createNewPathway = createNewPathway;
    }

    public String getNewPathwayName() {
        return this.newPathwayName;
    }

    public void setNewPathwayName(String newPathwayName) {
        this.newPathwayName = newPathwayName;
    }

    public MergeAction(ChisioMain chisio, String filename) {
        this(chisio);
        this.filename = filename;
    }

    public MergeAction(ChisioMain chisio, Model model) {
        this(chisio);
        this.model = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.main.getBioPAXModel() == null) {
            MessageDialog.openError(this.main.getShell(), "Error!", "Load or query a BioPAX model first.");
            return;
        }
        if (this.filename == null && this.model == null) {
            this.filename = new FileChooser(this).choose("FILE_KEY");
            if (this.filename == null) {
                return;
            }
        }
        HashSet<Model> sources = new HashSet<Model>();
        try {
            assert (this.model == null || this.filename == null) : "One and only one must be null";
            assert (this.model != null || this.filename != null) : "One and only one must be null";
            if (this.model == null) {
                SimpleIOHandler reader = new SimpleIOHandler();
                this.model = reader.convertFromOWL(new FileInputStream(this.filename));
            }
            if (this.model.getObjects().isEmpty()) {
                MessageDialog.openInformation(this.main.getShell(), "No Data!", "The file is empty.");
                return;
            }
            if (this.main.getBioPAXModel().getLevel().equals((Object)this.model.getLevel())) {
                sources.add(this.model);
                SimpleMerger merger = new SimpleMerger(SimpleEditorMap.get(this.main.getBioPAXModel().getLevel()));
                merger.merge(this.main.getBioPAXModel(), this.model);
                if (this.createNewPathway) {
                    Set<String> intids = BioPAXUtil.getInteractionIDs(this.model);
                    PathwayHolder pathway2 = BioPAXUtil.createPathway(this.main.getBioPAXModel(), this.newPathwayName, intids);
                    this.nameOfPathwayToOpen = pathway2.getName();
                }
                this.main.makeDirty();
                if (this.updatePathways) {
                    new UpdatePathwayAction(this.main, true).run();
                }
                if (this.openPathways) {
                    if (this.nameOfPathwayToOpen != null) {
                        ArrayList<String> pnames = new ArrayList<String>(this.main.getOpenTabNames());
                        pnames.add(this.nameOfPathwayToOpen);
                        new OpenPathwaysAction(this.main, pnames).run();
                    } else {
                        new OpenPathwaysAction(this.main).run();
                    }
                }
            } else {
                MessageDialog.openError(this.main.getShell(), "Incompatible Levels", "Models with different levels cannot be merged.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.filename = null;
            this.model = null;
        }
    }
}

