/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import cpath.client.util.CPathException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.eclipse.jface.dialogs.MessageDialog;
import org.gvt.ChisioMain;
import org.gvt.action.QueryPCAction;
import org.gvt.gui.AbstractQueryParamDialog;
import org.gvt.gui.StringInputDialog;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.patika.mada.graph.GraphObject;

public class QueryPCGetAction
extends QueryPCAction {
    protected Set<String> ids;
    private String lastEntry;

    public QueryPCGetAction(ChisioMain main, boolean useSelected, QueryPCAction.QueryLocation qLoc) {
        super(main, "Object With Database ID ...", useSelected, qLoc);
    }

    @Override
    public void run() {
        if (this.main.getBioPAXModel() == null || this.main.getBioPAXModel().getLevel().equals((Object)BioPAXLevel.L3)) {
            if (!this.useSelected && (this.ids == null || this.ids.isEmpty())) {
                StringInputDialog dialog;
                String idStr = "";
                if (this.lastEntry != null) {
                    idStr = this.lastEntry;
                }
                if ((idStr = (dialog = new StringInputDialog(this.main.getShell(), "Get Objects", "Enter Pathway Commons ID of database object", idStr, "Find the specified object")).open()) != null) {
                    this.lastEntry = idStr;
                    if (this.ids == null) {
                        this.ids = new HashSet<String>();
                    }
                    Collections.addAll(this.ids, idStr.split("\\s+|;"));
                    if (this.ids.isEmpty()) {
                        this.ids = null;
                    }
                }
            }
            this.execute();
            this.ids = null;
        } else {
            MessageDialog.openError(this.main.getShell(), "Incompatible Levels", "This query is only applicable to Level 3 models.");
        }
    }

    public void setIDs(Set<String> ids) {
        this.ids = ids;
    }

    @Override
    protected String getSIFQueryType() {
        throw new RuntimeException("Code should not reach here!");
    }

    @Override
    protected Model doQuery() throws CPathException {
        if (this.useSelected && !this.options.getSourceList().isEmpty()) {
            this.ids = new HashSet<String>(this.options.getSourceList());
        }
        return this.getPCGetQuery().sources(this.ids).result();
    }

    @Override
    protected Set<BioPAXElement> doFileQuery(Model model) {
        if (this.useSelected && !this.options.getSourceList().isEmpty()) {
            this.ids = new HashSet<String>(this.options.getSourceList());
        }
        return this.findInFile(model, this.ids);
    }

    @Override
    protected Collection<GraphObject> doSIFQuery(BasicSIFGraph graph) throws CPathException {
        throw new UnsupportedOperationException("Cannot get from SIF");
    }

    @Override
    protected AbstractQueryParamDialog getDialog() {
        return null;
    }

    @Override
    protected boolean canQuery() {
        return this.ids != null || this.options.getSourceList() != null && !this.options.getSourceList().isEmpty();
    }
}

