/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabItem;
import org.gvt.ChisioMain;
import org.gvt.gui.StringInputDialog;

public class RenamePathwayAction
extends Action {
    private ChisioMain main;

    public RenamePathwayAction(ChisioMain main) {
        super("Rename Pathway ...");
        this.setToolTipText(this.getText());
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/pathway-rename.png"));
        this.main = main;
    }

    @Override
    public void run() {
        CTabItem tab = this.main.getSelectedTab();
        ScrollingGraphicalViewer viewer = this.main.getViewer();
        if (viewer != null) {
            StringInputDialog dialog;
            String newname;
            boolean again = false;
            do {
                if (again) {
                    MessageDialog.openError(this.main.getShell(), "Error", "Name already exists. Choose another name.");
                }
                again = true;
                dialog = new StringInputDialog(this.main.getShell(), "Rename Pathway", "Enter new name", tab.getText());
                dialog.setSelectText(true);
            } while ((newname = dialog.open()) != null && !newname.equals(tab.getText()) && (this.main.getAllPathwayNames().contains(newname) || this.main.getOpenTabNames().contains(newname)));
            if (newname != null && !newname.equals(tab.getText())) {
                this.main.renamePathway(tab, newname);
            }
        }
    }
}

