/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.FileOutputStream;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.gvt.ChisioMain;
import org.gvt.action.SaveAsBioPAXFileAction;
import org.gvt.model.BioPAXGraph;

public class SaveBioPAXFileAction
extends Action {
    private ChisioMain main;
    private String filename;
    private boolean saved;

    public SaveBioPAXFileAction(ChisioMain chisio) {
        super("Save");
        this.setToolTipText(this.getText());
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/save.png"));
        this.main = chisio;
    }

    public SaveBioPAXFileAction(ChisioMain main, String filename) {
        this(main);
        this.filename = filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.saved = false;
        if (this.main.getBioPAXModel() == null) {
            return;
        }
        if (this.filename == null) {
            this.filename = this.main.getOwlFileName();
        }
        if (this.filename == null) {
            SaveAsBioPAXFileAction action = new SaveAsBioPAXFileAction(this.main);
            action.run();
            this.saved = action.isSaved();
            return;
        }
        try {
            this.main.lockWithMessage("Saving ...");
            for (ScrollingGraphicalViewer viewer : this.main.getTabToViewerMap().values()) {
                BioPAXGraph graph;
                Object o = viewer.getContents().getModel();
                if (!(o instanceof BioPAXGraph) || !(graph = (BioPAXGraph)o).isMechanistic()) continue;
                graph.recordLayout();
            }
            SimpleIOHandler exporter = new SimpleIOHandler(this.main.getBioPAXModel().getLevel());
            FileOutputStream stream = new FileOutputStream(this.filename);
            exporter.convertToOWL(this.main.getBioPAXModel(), stream);
            stream.close();
            this.main.setOwlFileName(this.filename);
            this.main.markSaved();
            this.saved = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError(this.main.getShell(), "Chisio BioPAX Editor", "File cannot be saved!\n" + e.getMessage());
        }
        finally {
            this.main.unlock();
            this.filename = null;
        }
    }

    public boolean isSaved() {
        return this.saved;
    }
}

