/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.HashSet;
import java.util.List;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.gvt.ChisioMain;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.CompoundModel;
import org.gvt.model.EdgeModel;
import org.gvt.model.NodeModel;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.gvt.model.sifl3.SIFGraph;

public class ShowSIFStatisticsAction
extends Action {
    ChisioMain main;

    public ShowSIFStatisticsAction(ChisioMain main) {
        super("Show Graph Statistics ...");
        this.setToolTipText(this.getText());
        this.main = main;
    }

    @Override
    public void run() {
        ScrollingGraphicalViewer viewer = this.main.getViewer();
        if (viewer == null) {
            return;
        }
        BioPAXGraph graph = this.main.getPathwayGraph();
        if (!(graph instanceof BasicSIFGraph) && !(graph instanceof SIFGraph)) {
            return;
        }
        int relNum = 0;
        for (Object o : graph.getEdges()) {
            EdgeModel edge = (EdgeModel)o;
            int sourceNum = edge.getSource() instanceof CompoundModel ? ((CompoundModel)edge.getSource()).getChildren().size() : 1;
            int targetNum = edge.getTarget() instanceof CompoundModel ? ((CompoundModel)edge.getTarget()).getChildren().size() : 1;
            relNum += sourceNum * targetNum;
        }
        for (Object o : graph.getNodes()) {
            CompoundModel com;
            if (!(o instanceof CompoundModel) || (com = (CompoundModel)o).getText() == null || com.getText().length() <= 0) continue;
            int c = com.getChildren().size();
            relNum += c * (c - 1) / 2;
        }
        HashSet all = new HashSet();
        HashSet source = new HashSet();
        HashSet target = new HashSet();
        for (Object o : graph.getNodes()) {
            NodeModel node = (NodeModel)o;
            HashSet<NodeModel> set = new HashSet<NodeModel>();
            if (node instanceof CompoundModel) {
                set.addAll(((CompoundModel)node).getChildren());
            } else {
                set.add(node);
            }
            all.addAll(set);
            if (this.hasDirectedEdges(node.getSourceConnections())) {
                source.addAll(set);
            }
            if (!this.hasDirectedEdges(node.getTargetConnections())) continue;
            target.addAll(set);
        }
        MessageDialog.openInformation(this.main.getShell(), "Graph Statistics", "\nGenes = " + all.size() + "\nSource genes = " + source.size() + "\nTarget genes = " + target.size() + "\nRelations = " + relNum + "\n");
    }

    private boolean hasDirectedEdges(List list) {
        for (Object o : list) {
            EdgeModel edge;
            String arrow;
            if (!(o instanceof EdgeModel) || (arrow = (edge = (EdgeModel)o).getArrow()) == null || arrow.equals("None")) continue;
            return true;
        }
        return false;
    }
}

