/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.HashSet;
import java.util.Set;
import org.cbio.causality.data.portal.BroadAccessor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabItem;
import org.gvt.ChisioMain;
import org.gvt.model.CompoundModel;
import org.gvt.model.biopaxl3.BioPAXL3Graph;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.Graph;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;

public class TCGASIFAction
extends Action {
    ChisioMain main;

    public TCGASIFAction(String title, ChisioMain main) {
        super(title);
        this.setToolTipText(this.getText());
        this.main = main;
    }

    protected static boolean okToRun(ChisioMain main) {
        return TCGASIFAction.okToRun(main, true);
    }

    public static boolean okToRun(ChisioMain main, boolean displayError) {
        assert (main != null);
        if (main.getSelectedTab() == null) {
            if (displayError) {
                MessageDialog.openError(main.getShell(), "No graph", "Please load a TCGA scpecific SIF model first. You can get\nsuch a model using the menu item \"SIF --> Load TCGA specific SIF\".");
            }
            return false;
        }
        if (ChisioMain.cBioPortalAccessor == null) {
            if (displayError) {
                MessageDialog.openError(main.getShell(), "No alteration data", "This feature works only when the graph is overlayed with alteration data.");
            }
            return false;
        }
        if (TCGASIFAction.getGraph(main) == null || TCGASIFAction.getCurrentStudy() == null) {
            if (displayError) {
                MessageDialog.openError(main.getShell(), "Cannot show", "This feature only works for TCGA scpecific SIF models. You can get\nsuch a model using the menu item \"SIF --> Load TCGA specific SIF\".");
            }
            return false;
        }
        return true;
    }

    protected Set<GraphObject> getHighlighted(Graph graph) {
        HashSet<GraphObject> gos = new HashSet<GraphObject>();
        for (Node node : graph.getNodes()) {
            if (!node.isHighlighted()) continue;
            gos.add(node);
        }
        for (Edge edge : graph.getEdges()) {
            if (!edge.isHighlighted()) continue;
            gos.add(edge);
        }
        return gos;
    }

    protected void highlight(Set<GraphObject> gos) {
        for (GraphObject go : gos) {
            go.setHighlight(true);
        }
    }

    protected static String getCurrentStudy() {
        if (ChisioMain.cBioPortalAccessor != null) {
            String studyID = ChisioMain.cBioPortalAccessor.getCurrentCancerStudy().getStudyId();
            String code = studyID.substring(0, studyID.indexOf("_"));
            code = code.toUpperCase();
            if (BroadAccessor.getStudyCodes().contains(code)) {
                return code;
            }
        }
        return null;
    }

    protected static BioPAXL3Graph getGraph(ChisioMain main) {
        CompoundModel root;
        CTabItem tab = main.getSelectedTab();
        if (tab != null && (root = (CompoundModel)main.getTabToViewerMap().get(tab).getContents().getModel()) instanceof BioPAXL3Graph) {
            return (BioPAXL3Graph)root;
        }
        return null;
    }
}

