/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.command;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;

public class OrphanChildCommand
extends Command {
    private Point oldLocation;
    private CompoundModel parent;
    private NodeModel child;
    private boolean onlyRemoveCompound = false;

    public OrphanChildCommand() {
        super("OrphanChildCommand");
    }

    public void setOnlyRemoveCompound(boolean onlyRemoveCompound) {
        this.onlyRemoveCompound = onlyRemoveCompound;
    }

    @Override
    public void execute() {
        this.oldLocation = this.child.getLocation();
        this.parent.removeChild(this.child);
        this.child.setParentModel(null);
        if (!this.onlyRemoveCompound) {
            this.parent.calculateSizeUp();
        }
    }

    @Override
    public void redo() {
        this.parent.removeChild(this.child);
    }

    public void setChild(NodeModel child) {
        this.child = child;
    }

    public void setParent(CompoundModel parent) {
        this.parent = parent;
    }

    @Override
    public void undo() {
        this.child.setLocation(this.oldLocation);
        this.parent.addChild(this.child);
        this.child.setParentModel(this.parent);
    }

    public NodeModel getChild() {
        return this.child;
    }
}

