/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.figure;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.CompoundModel;

public class CompoundBorder
extends LineBorder {
    protected int labelHeight;
    protected Dimension labelSize;
    Color color;

    public CompoundBorder(Color c, int lblHeight) {
        this.color = c;
        this.labelHeight = lblHeight;
    }

    public CompoundBorder() {
        this.labelHeight = CompoundModel.LABEL_HEIGHT;
    }

    @Override
    public void setColor(Color c) {
        this.color = c;
    }

    public CompoundBorder(int width) {
        this.setGrabBarWidth(width);
        this.labelSize = new Dimension(width, 4);
    }

    @Override
    public Insets getInsets(IFigure figure) {
        return new Insets(this.getWidth() + 2, this.labelHeight + 2, this.getWidth() + 2, this.getWidth() + 2);
    }

    public Dimension getPreferredSize() {
        return this.labelSize;
    }

    @Override
    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        super.paint(figure, graphics, insets);
    }

    public void setGrabBarWidth(int width) {
        this.labelHeight = width;
    }
}

