/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.figure;

import org.eclipse.draw2d.BendpointLocator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.handles.BendpointHandle;
import org.eclipse.gef.tools.ConnectionBendpointTracker;

public class ConnectionBendpointHandle
extends BendpointHandle {
    String type;

    public ConnectionBendpointHandle(ConnectionEditPart owner, int index, int locatorIndex, String type) {
        this.setCursor(SharedCursors.SIZEALL);
        this.setOwner(owner);
        this.setIndex(index);
        if (type.equals("create")) {
            this.setLocator(new MidpointLocator(this.getConnection(), locatorIndex));
            this.setPreferredSize(new Dimension(5, 5));
        } else if (type.equals("move")) {
            this.setLocator(new BendpointLocator(this.getConnection(), locatorIndex));
        }
        this.type = type;
    }

    @Override
    protected DragTracker createDragTracker() {
        ConnectionBendpointTracker tracker = new ConnectionBendpointTracker((ConnectionEditPart)this.getOwner(), this.getIndex());
        if (this.type.equals("create")) {
            tracker.setType("create bendpoint");
        } else if (this.type.equals("move")) {
            tracker.setType("move bendpoint");
        }
        tracker.setDefaultCursor(this.getCursor());
        return tracker;
    }

    @Override
    public void paintFigure(Graphics g) {
        Rectangle r = this.getBounds();
        r.shrink(1, 1);
        try {
            g.setBackgroundColor(ColorConstants.cyan);
            g.fillRectangle(r.x, r.y, r.width, r.height);
            g.setForegroundColor(ColorConstants.cyan);
            g.drawRectangle(r.x, r.y, r.width, r.height);
        }
        finally {
            r.expand(1, 1);
        }
    }
}

