/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.figure;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.RelativeHandleLocator;
import org.eclipse.gef.handles.SquareHandle;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.swt.graphics.Cursor;

public class ResizeHandle
extends SquareHandle {
    private int cursorDirection = 0;
    private boolean isResizable;

    public ResizeHandle(GraphicalEditPart owner, int direction, boolean isResizable) {
        this.setOwner(owner);
        this.setLocator(new RelativeHandleLocator(owner.getFigure(), direction));
        this.setCursor(Cursors.getDirectionalCursor(direction, owner.getFigure().isMirrored()));
        this.cursorDirection = direction;
        this.isResizable = isResizable;
    }

    public ResizeHandle(GraphicalEditPart owner, Locator loc, Cursor c) {
        super(owner, loc, c);
    }

    @Override
    protected DragTracker createDragTracker() {
        return new ResizeTracker(this.getOwner(), this.cursorDirection);
    }

    @Override
    public void paintFigure(Graphics g) {
        Rectangle r = this.getBounds();
        r.shrink(1, 1);
        try {
            if (this.isResizable) {
                g.setBackgroundColor(ColorConstants.cyan);
            } else {
                g.setBackgroundColor(ColorConstants.white);
            }
            g.fillRectangle(r.x, r.y, r.width, r.height);
            g.setForegroundColor(ColorConstants.cyan);
            g.drawRectangle(r.x, r.y, r.width, r.height);
        }
        finally {
            r.expand(1, 1);
        }
    }
}

