/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gvt.ChisioMain;

public class AddCompartmentDialog
extends Dialog {
    private ArrayList<String> selectedCompartments;
    private List<String> allCompartments;
    private String[] allCompartmentNames;
    private boolean addPressed;
    private org.eclipse.swt.widgets.List compartmentList;
    private Button addButton;
    private Button cancelButton;
    private Shell shell;

    public AddCompartmentDialog(Shell shell, List<String> allCompartments) {
        super(shell);
        this.shell = shell;
        this.allCompartments = allCompartments;
        this.allCompartmentNames = new String[allCompartments.size()];
        for (int i = 0; i < allCompartments.size(); ++i) {
            this.allCompartmentNames[i] = allCompartments.get(i);
        }
        Arrays.sort(this.allCompartmentNames);
        this.selectedCompartments = new ArrayList();
        this.addPressed = false;
    }

    public boolean open() {
        this.createContents();
        this.shell.setLocation(this.getParent().getLocation().x + this.getParent().getSize().x / 2 - this.shell.getSize().x / 2, this.getParent().getLocation().y + this.getParent().getSize().y / 2 - this.shell.getSize().y / 2);
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.addPressed;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setText("Add Compartment");
        ImageDescriptor id = ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png");
        this.shell.setImage(id.createImage());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.shell.setLayout(gridLayout);
        this.compartmentList = new org.eclipse.swt.widgets.List(this.shell, 2818);
        this.compartmentList.setItems(this.allCompartmentNames);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.heightHint = this.compartmentList.getItemHeight() * 5;
        gridData.widthHint = 200;
        this.compartmentList.setLayoutData(gridData);
        this.addButton = new Button(this.shell, 0);
        this.addButton.setText("Add");
        this.addButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                AddCompartmentDialog.this.saveSelectedCompartments();
                AddCompartmentDialog.this.addPressed = true;
                AddCompartmentDialog.this.shell.dispose();
            }
        });
        gridData = new GridData(1, 2, true, false);
        gridData.minimumWidth = 100;
        this.addButton.setLayoutData(gridData);
        this.cancelButton = new Button(this.shell, 0);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                AddCompartmentDialog.this.addPressed = false;
                AddCompartmentDialog.this.shell.dispose();
            }
        });
        gridData = new GridData(3, 2, true, false);
        gridData.minimumWidth = 100;
        this.cancelButton.setLayoutData(gridData);
        this.shell.pack();
    }

    private void saveSelectedCompartments() {
        String[] selectionResult;
        this.selectedCompartments.clear();
        for (String selected : selectionResult = this.compartmentList.getSelection()) {
            for (String compartment : this.allCompartments) {
                if (selected == null || !selected.equals(compartment)) continue;
                this.selectedCompartments.add(compartment);
            }
        }
    }

    public List<String> getSelectedCompartments() {
        return this.selectedCompartments;
    }
}

