/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.gvt.ChisioMain;
import org.gvt.gui.AbstractQueryParamDialog;
import org.gvt.util.EntityHolder;
import org.gvt.util.QueryOptionsPack;

public class CommonStreamQueryParamWithEntitiesDialog
extends AbstractQueryParamDialog {
    Collection<EntityHolder> allEntities;
    public static String info = "Find molecules within the specified distance that are affecting or affected by a specific set of molecules in common";

    public CommonStreamQueryParamWithEntitiesDialog(ChisioMain main, Collection<EntityHolder> allEntities) {
        super(main);
        this.allEntities = allEntities;
    }

    public CommonStreamQueryParamWithEntitiesDialog(ChisioMain main, boolean forSIF) {
        super(main, forSIF);
    }

    @Override
    protected void createContents(QueryOptionsPack opt) {
        super.createContents(opt);
        this.shell.setText("Common Stream Query Properties");
        this.infoLabel.setText(info);
        ImageDescriptor id = ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png");
        this.shell.setImage(id.createImage());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        this.shell.setLayout(gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 5;
        gridData.horizontalSpan = 1;
        gridData.widthHint = 150;
        if (this.allEntities != null) {
            this.sourceElg = new AbstractQueryParamDialog.EntityListGroup(this.shell, 0, this.allEntities);
            this.sourceElg.init();
            this.sourceElg.setLayoutData(gridData);
        } else {
            this.sourceST = new AbstractQueryParamDialog.SymbolText(this.shell, 0);
            this.sourceST.init(null);
            this.sourceST.setLayoutData(gridData);
        }
        this.createResultViewGroup(2, 2);
        this.createStreamDirectionGroup(2, 2, false);
        this.createLengthLimit(1, 1, 1, 1, 50);
        this.createExeCancDefGroup(opt, 6);
        if (this.allEntities == null) {
            this.currentViewButton.setEnabled(false);
        }
        this.shell.pack();
        this.setInitialValues(opt);
    }
}

