/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cbio.causality.data.portal.CancerStudy;
import org.cbio.causality.data.portal.CaseList;
import org.cbio.causality.data.portal.GeneticProfile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.gvt.ChisioMain;
import org.gvt.gui.CBioPortalSettingsDialog;

public class FetchFromCBioPortalDialog
extends Dialog {
    private ChisioMain main;
    private Shell shell;
    private static int[] memorizeChoices = null;

    public FetchFromCBioPortalDialog(ChisioMain main) {
        super(main.getShell(), 0);
        this.main = main;
    }

    public void open() {
        if (ChisioMain.cBioPortalAccessor == null) {
            System.err.println("Portal accessor is not initialized!");
            return;
        }
        this.createContents();
        this.shell.pack();
        this.shell.setLocation(this.getParent().getLocation().x + this.getParent().getSize().x / 2 - this.shell.getSize().x / 2, this.getParent().getLocation().y + this.getParent().getSize().y / 2 - this.shell.getSize().y / 2);
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setText("Fetch from cBio Portal");
        ImageDescriptor id = ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png");
        this.shell.setImage(id.createImage());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.shell.setLayout(gridLayout);
        Label cancerStudyLabel = new Label(this.shell, 1);
        cancerStudyLabel.setText("1) Select a cancer study");
        GridData gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 2;
        cancerStudyLabel.setLayoutData(gridData);
        final Combo studyCombo = new Combo(this.shell, 2060);
        gridData = new GridData(4, 2, true, false);
        gridData.horizontalSpan = 2;
        studyCombo.setLayoutData(gridData);
        studyCombo.removeAll();
        for (CancerStudy cancerStudy : ChisioMain.cBioPortalAccessor.getCancerStudies()) {
            studyCombo.add(cancerStudy.getName());
        }
        Label caseListLabel = new Label(this.shell, 0);
        caseListLabel.setText("2) Select a case list");
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 2;
        caseListLabel.setLayoutData(gridData);
        final Combo caseListCombo = new Combo(this.shell, 2060);
        gridData = new GridData(4, 2, true, false);
        gridData.horizontalSpan = 2;
        caseListCombo.setLayoutData(gridData);
        final ArrayList<GeneticProfile> supportedProfiles = new ArrayList<GeneticProfile>();
        Label genomicProfileLabel = new Label(this.shell, 0);
        genomicProfileLabel.setText("3) Select genomic profile(s)");
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 2;
        genomicProfileLabel.setLayoutData(gridData);
        final org.eclipse.swt.widgets.List genomicProfilesList = new org.eclipse.swt.widgets.List(this.shell, 2562);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 100;
        genomicProfilesList.setLayoutData(gridData);
        Group buttonGroup = new Group(this.shell, 0);
        gridData = new GridData(4, 2, false, false);
        gridData.horizontalSpan = 2;
        buttonGroup.setLayoutData(gridData);
        buttonGroup.setLayout(new GridLayout(3, true));
        final Button loadDataButton = new Button(buttonGroup, 0);
        loadDataButton.setText("Load data");
        gridData = new GridData(3, 2, true, false);
        loadDataButton.setEnabled(false);
        loadDataButton.setLayoutData(gridData);
        Button cancelButton = new Button(buttonGroup, 0);
        cancelButton.setText("Cancel");
        gridData = new GridData(2, 2, true, false);
        cancelButton.setLayoutData(gridData);
        Button settingsButton = new Button(buttonGroup, 0);
        settingsButton.setText("Settings");
        gridData = new GridData(1, 2, true, false);
        settingsButton.setLayoutData(gridData);
        studyCombo.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                FetchFromCBioPortalDialog.this.selectCancerStudy(studyCombo, caseListCombo, genomicProfilesList, supportedProfiles);
            }
        });
        genomicProfilesList.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                loadDataButton.setEnabled(genomicProfilesList.getSelectionCount() > 0);
            }
        });
        settingsButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                CBioPortalSettingsDialog cBioPortalSettingsDialog = new CBioPortalSettingsDialog(FetchFromCBioPortalDialog.this.main);
                cBioPortalSettingsDialog.open();
            }
        });
        loadDataButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                int selectionIndex;
                try {
                    selectionIndex = caseListCombo.getSelectionIndex();
                    CaseList caseList = ChisioMain.cBioPortalAccessor.getCaseListsForCurrentStudy().get(selectionIndex);
                    ChisioMain.cBioPortalAccessor.setCurrentCaseList(caseList);
                }
                catch (IOException e) {
                    MessageDialog.openError(FetchFromCBioPortalDialog.this.main.getShell(), "Error!", "Could not load case lists for current study.\n" + e.toString());
                    return;
                }
                List<GeneticProfile> selectedProfiles = ChisioMain.cBioPortalAccessor.getCurrentGeneticProfiles();
                selectedProfiles.clear();
                for (int i : genomicProfilesList.getSelectionIndices()) {
                    GeneticProfile geneticProfile = (GeneticProfile)supportedProfiles.get(i);
                    selectedProfiles.add(geneticProfile);
                }
                int profileCnt = genomicProfilesList.getSelectionCount();
                FetchFromCBioPortalDialog.access$202(new int[profileCnt + 2]);
                memorizeChoices[0] = ChisioMain.cBioPortalAccessor.getCancerStudies().indexOf(ChisioMain.cBioPortalAccessor.getCurrentCancerStudy());
                memorizeChoices[1] = selectionIndex;
                for (int i = 0; i < profileCnt; ++i) {
                    memorizeChoices[i + 2] = genomicProfilesList.getSelectionIndices()[i];
                }
                FetchFromCBioPortalDialog.this.shell.close();
            }
        });
        cancelButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                FetchFromCBioPortalDialog.this.shell.close();
            }
        });
        if (memorizeChoices != null) {
            studyCombo.select(memorizeChoices[0]);
            this.selectCancerStudy(studyCombo, caseListCombo, genomicProfilesList, supportedProfiles);
            caseListCombo.select(memorizeChoices[1]);
            int[] select = new int[memorizeChoices.length - 2];
            System.arraycopy(memorizeChoices, 2, select, 0, select.length);
            genomicProfilesList.select(select);
            loadDataButton.setEnabled(true);
        }
    }

    private void selectCancerStudy(Combo comboDropDown, Combo caseListList, org.eclipse.swt.widgets.List genomicProfilesList, ArrayList<GeneticProfile> supportedProfiles) {
        CancerStudy cancerStudy = ChisioMain.cBioPortalAccessor.getCancerStudies().get(comboDropDown.getSelectionIndex());
        ChisioMain.cBioPortalAccessor.setCurrentCancerStudy(cancerStudy);
        try {
            caseListList.removeAll();
            for (CaseList caseList : ChisioMain.cBioPortalAccessor.getCaseListsForCurrentStudy()) {
                caseListList.add(caseList.getDescription() + " (" + caseList.getCases().length + " cases)");
            }
            caseListList.select(0);
            genomicProfilesList.removeAll();
            supportedProfiles.clear();
            for (GeneticProfile geneticProfile : ChisioMain.cBioPortalAccessor.getGeneticProfilesForCurrentStudy()) {
                switch (geneticProfile.getType()) {
                    case MRNA_EXPRESSION: {
                        if (!geneticProfile.getId().toLowerCase().endsWith("_zscores")) break;
                    }
                    case COPY_NUMBER_ALTERATION: 
                    case MUTATION_EXTENDED: {
                        genomicProfilesList.add(geneticProfile.getName());
                        supportedProfiles.add(geneticProfile);
                    }
                }
            }
        }
        catch (IOException e) {
            MessageDialog.openError(this.main.getShell(), "Error!", "Could not load meta data for current study.\n" + e.toString());
        }
    }

    static /* synthetic */ int[] access$202(int[] x0) {
        memorizeChoices = x0;
        return x0;
    }
}

