/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gvt.ChisioMain;

public class StringInputDialog
extends Dialog {
    private String message;
    private String title;
    private String input;
    private String info;
    private boolean infoPresent = false;
    private boolean selectText;
    private Shell shell;
    private Text text;
    private Button okButton;
    private Button cancelButton;

    public StringInputDialog(Shell shell, String title, String message, String input) {
        super(shell);
        this.title = title;
        this.message = message;
        this.input = input;
    }

    public StringInputDialog(Shell shell, String title, String message, String input, String info) {
        super(shell);
        this.title = title;
        this.message = message;
        this.input = input;
        this.info = info;
        this.infoPresent = true;
    }

    public void setSelectText(boolean selectText) {
        this.selectText = selectText;
    }

    public String open() {
        this.createContents();
        this.shell.pack();
        this.shell.setLocation(this.getParent().getLocation().x + this.getParent().getSize().x / 2 - this.shell.getSize().x / 2, this.getParent().getLocation().y + this.getParent().getSize().y / 2 - this.shell.getSize().y / 2);
        this.shell.setImage(ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png").createImage());
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.input;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67680);
        if (this.infoPresent) {
            Label infoLabel = new Label(this.shell, 0);
            infoLabel.setText(this.info);
            GridData gridData = new GridData(4, 4, false, false);
            gridData.verticalSpan = 6;
            infoLabel.setLayoutData(gridData);
        }
        GridLayout grLy = new GridLayout();
        grLy.numColumns = 1;
        this.shell.setLayout(grLy);
        this.shell.setText(this.title);
        Group itemsGroup = new Group(this.shell, 0);
        itemsGroup.setLayout(new FillLayout());
        itemsGroup.setText(this.message);
        GridData gd = new GridData(4, 4, false, true);
        gd.widthHint = 200;
        gd.heightHint = 20;
        itemsGroup.setLayoutData(gd);
        ButtonAdapter adapter = new ButtonAdapter();
        this.text = new Text(itemsGroup, 4);
        this.text.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13) {
                    StringInputDialog.this.okPressed();
                }
            }
        });
        if (this.input != null) {
            this.text.setText(this.input);
        }
        if (this.selectText) {
            this.text.selectAll();
        }
        Composite buttonsGroup = new Composite(this.shell, 0);
        buttonsGroup.setLayout(new RowLayout());
        gd = new GridData();
        gd.horizontalAlignment = 2;
        buttonsGroup.setLayoutData(gd);
        this.okButton = new Button(buttonsGroup, 0);
        this.okButton.setText("OK");
        this.okButton.addSelectionListener(adapter);
        this.cancelButton = new Button(buttonsGroup, 0);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addSelectionListener(adapter);
    }

    private void cancelPressed() {
        this.input = null;
        this.shell.dispose();
    }

    private void okPressed() {
        this.input = this.text.getText();
        this.shell.dispose();
    }

    class ButtonAdapter
    extends SelectionAdapter {
        ButtonAdapter() {
        }

        @Override
        public void widgetSelected(SelectionEvent arg) {
            Button button = (Button)arg.widget;
            if (button == StringInputDialog.this.okButton) {
                StringInputDialog.this.okPressed();
            } else if (button == StringInputDialog.this.cancelButton) {
                StringInputDialog.this.cancelPressed();
            }
        }
    }
}

